/*
 * Decompiled with CFR 0.152.
 */
package org.restdoc.cxf;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.restdoc.api.GlobalHeader;
import org.restdoc.server.impl.RestDocGenerator;
import org.slf4j.LoggerFactory;

public abstract class RestDocFeature
extends AbstractFeature {
    private static final String ENCODING = "UTF-8";
    private static final String HTTP_METHOD = "OPTIONS";
    private static final String FIELD_REQUEST_URI = "org.apache.cxf.request.uri";
    private static final String FIELD_REQUEST_METHOD = "org.apache.cxf.request.method";
    private final RestDocGenerator restDoc = new RestDocGenerator();

    public RestDocFeature() {
        this.customInit(this.restDoc);
        this.restDoc.init((Class[])this.getClasses(), this.getHeader(), this.getBaseURL());
    }

    protected void customInit(RestDocGenerator generator) {
    }

    protected abstract String getBaseURL();

    protected abstract Class<?>[] getClasses();

    protected abstract GlobalHeader getHeader();

    public final void initialize(Server server, Bus bus) {
        server.getEndpoint().getInInterceptors().add(new AbstractPhaseInterceptor<Message>("read"){

            public void handleMessage(Message message) throws Fault {
                Response response = RestDocFeature.this.handleRequest(message);
                if (response != null) {
                    RestDocFeature.this.createOutMessage(message, response);
                    message.getInterceptorChain().doInterceptStartingAt(message, OutgoingChainInterceptor.class.getName());
                }
            }
        });
    }

    final Response handleRequest(Message message) {
        String verb = (String)message.get((Object)FIELD_REQUEST_METHOD);
        if (!verb.equals(HTTP_METHOD)) {
            return null;
        }
        String path = (String)message.get((Object)FIELD_REQUEST_URI);
        if (!path.startsWith(this.getBaseURL())) {
            return null;
        }
        try {
            String decode = URLDecoder.decode(path, ENCODING);
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug(String.format("RestDoc request: %s", decode));
            return Response.ok((Object)this.restDoc.getRestDocStringForPath(decode), (String)"application/x-restdoc+json").build();
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("RestDoc exception: " + e.getMessage(), (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    private Message createOutMessage(Message inMessage, Response r) {
        Endpoint e = (Endpoint)inMessage.getExchange().get(Endpoint.class);
        Message mout = e.getBinding().createMessage();
        mout.setContent(List.class, (Object)new MessageContentsList(new Object[]{r}));
        mout.setExchange(inMessage.getExchange());
        mout.setInterceptorChain(OutgoingChainInterceptor.getOutInterceptorChain((Exchange)inMessage.getExchange()));
        inMessage.getExchange().setOutMessage(mout);
        return mout;
    }
}

