/*
 * Decompiled with CFR 0.152.
 */
package org.restdoc.api.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.restdoc.api.RestDoc;

public final class RestDocParser {
    private RestDocParser() {
    }

    public static RestDoc parseString(String json) throws IOException {
        return (RestDoc)RestDocParser.createMapper().readValue(json, RestDoc.class);
    }

    public static RestDoc parseFile(File json) throws IOException {
        return (RestDoc)RestDocParser.createMapper().readValue(json, RestDoc.class);
    }

    public static RestDoc parseResource(String name) throws IOException {
        InputStream stream = RestDocParser.class.getResourceAsStream(name);
        return (RestDoc)RestDocParser.createMapper().readValue(stream, RestDoc.class);
    }

    public static String writeRestDoc(RestDoc doc) throws IOException {
        return RestDocParser.createMapper().writeValueAsString((Object)doc);
    }

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }
}

