/*
 * Decompiled with CFR 0.152.
 */
package de.bertilmuth.javadataclass.read;

import de.bertilmuth.javadataclass.model.ClassSpecification;
import de.bertilmuth.javadataclass.model.FieldSpecification;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class YamlClassSpecificationReader {
    public List<ClassSpecification> read(File yamlFile) throws FileNotFoundException {
        return this.read(new FileReader(yamlFile));
    }

    public List<ClassSpecification> read(Reader reader) {
        Map<String, Map<String, String>> yamlClassSpecifications = this.readYamlClassSpecifications(reader);
        List<ClassSpecification> classSpecifications = this.createClassSpecificationsFrom(yamlClassSpecifications);
        return classSpecifications;
    }

    private Map<String, Map<String, String>> readYamlClassSpecifications(Reader reader) {
        Yaml yaml = new Yaml();
        Map yamlClassSpecifications = (Map)yaml.load(reader);
        return yamlClassSpecifications;
    }

    private List<ClassSpecification> createClassSpecificationsFrom(Map<String, Map<String, String>> yamlClassSpecifications) {
        Map<String, List<FieldSpecification>> classNameToFieldSpecificationsMap = this.createClassNameToFieldSpecificationsMap(yamlClassSpecifications);
        List<ClassSpecification> classSpecifications = classNameToFieldSpecificationsMap.entrySet().stream().map(e -> new ClassSpecification((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
        return classSpecifications;
    }

    private Map<String, List<FieldSpecification>> createClassNameToFieldSpecificationsMap(Map<String, Map<String, String>> yamlClassSpecifications) {
        if (yamlClassSpecifications == null) {
            return new HashMap<String, List<FieldSpecification>>();
        }
        return yamlClassSpecifications.entrySet().stream().collect(Collectors.toMap(this::className, this::fieldSpecifications));
    }

    private String className(Map.Entry<String, Map<String, String>> yamlOuterMapEntry) {
        return yamlOuterMapEntry.getKey();
    }

    private List<FieldSpecification> fieldSpecifications(Map.Entry<String, Map<String, String>> yamlOuterMapEntry) {
        Map<String, String> yamlFieldSpecifications = yamlOuterMapEntry.getValue();
        if (yamlFieldSpecifications == null) {
            return new ArrayList<FieldSpecification>();
        }
        return yamlFieldSpecifications.entrySet().stream().map(e -> new FieldSpecification((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }
}

