/*
 * Decompiled with CFR 0.152.
 */
package de.bertilmuth.javadataclass.generate;

import de.bertilmuth.javadataclass.model.ClassSpecification;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;

public class JavaDataClassGenerator {
    private Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);

    public JavaDataClassGenerator() throws IOException {
        this.configuration.setClassLoaderForTemplateLoading(this.getClass().getClassLoader(), "");
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.configuration.setLogTemplateExceptions(false);
        this.configuration.setWrapUncheckedExceptions(true);
    }

    public void generateJavaSourceFiles(Collection<ClassSpecification> classSpecifications, File yamlFileDirectory) throws Exception {
        HashMap<String, ClassSpecification> freemarkerDataModel = new HashMap<String, ClassSpecification>();
        Template template = this.configuration.getTemplate("javadataclass.ftl");
        for (ClassSpecification classSpecification : classSpecifications) {
            freemarkerDataModel.put("classSpecification", classSpecification);
            File javaSourceFile = new File(yamlFileDirectory, classSpecification.getName() + ".java");
            FileWriter javaSourceFileWriter = new FileWriter(javaSourceFile);
            template.process(freemarkerDataModel, (Writer)javaSourceFileWriter);
        }
    }
}

