/*
 * Decompiled with CFR 0.152.
 */
package de.bertilmuth.javadataclass;

import de.bertilmuth.javadataclass.generate.JavaDataClassGenerator;
import de.bertilmuth.javadataclass.model.ClassSpecification;
import de.bertilmuth.javadataclass.read.YamlClassSpecificationReader;
import java.io.File;
import java.util.List;

public class Main {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Please supply exactly one argument, the absolute path of the YAML file.");
            return;
        }
        String yamlFilePath = args[0];
        File yamlFile = new File(yamlFilePath);
        File outputDirectory = yamlFile.getParentFile();
        YamlClassSpecificationReader yamlReader = new YamlClassSpecificationReader();
        List<ClassSpecification> classSpecifications = yamlReader.read(yamlFile);
        JavaDataClassGenerator javaDataClassGenerator = new JavaDataClassGenerator();
        javaDataClassGenerator.generateJavaSourceFiles(classSpecifications, outputDirectory);
        System.out.println("Successfully generated files to: " + outputDirectory.getAbsolutePath());
    }
}

