/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.refcodes.data.Encoding;
import org.refcodes.web.AuthType;
import org.refcodes.web.AuthTypeCredentials;
import org.refcodes.web.BasicCredentials;
import org.refcodes.web.ForbiddenException;

public class BasicAuthCredentials
extends BasicCredentials
implements AuthTypeCredentials<BasicAuthCredentials, BasicCredentials> {
    public static final char DELIMITER_BASIC_AUTH = ' ';
    public static final char DELIMITER_CREDENTIALS = ':';

    public BasicAuthCredentials() {
    }

    public BasicAuthCredentials(String aIdentity, String aSecret) {
        super(aIdentity, aSecret);
    }

    @Override
    public void validate(BasicCredentials aCredentials) throws ForbiddenException {
        if (!this.isValid(aCredentials)) {
            throw new ForbiddenException("Access denied as of unsuccessful authentification!");
        }
    }

    public void validate(String aUserName, String aSecret) throws ForbiddenException {
        if (!this.isValid(aUserName, aSecret)) {
            throw new ForbiddenException("Access denied as of unsuccessfull authentification!");
        }
    }

    @Override
    public BasicAuthCredentials withHttpAuthorization(String aHttpAuthorization) {
        this.fromHttpAuthorization(aHttpAuthorization);
        return this;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.BASIC;
    }

    @Override
    public String getIdentity() {
        return this._identity;
    }

    @Override
    public String getSecret() {
        return this._secret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._secret == null ? 0 : this._secret.hashCode());
        result = 31 * result + (this._identity == null ? 0 : this._identity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicAuthCredentials)) {
            return false;
        }
        BasicAuthCredentials other = (BasicAuthCredentials)obj;
        if (this._secret == null ? other._secret != null : !this._secret.equals(other._secret)) {
            return false;
        }
        return !(this._identity == null ? other._identity != null : !this._identity.equalsIgnoreCase(other._identity));
    }

    public String toString() {
        return "<" + this._identity + "> with secret <...>";
    }

    @Override
    public void fromHttpAuthorization(String aHttpAuthorization) {
        String theCredentialsText;
        if (aHttpAuthorization == null) {
            throw new IllegalArgumentException("The provided HTTP authorization value does not conform to the format expected for Basic-Authentication.");
        }
        int theMarker = aHttpAuthorization.indexOf(32);
        if (theMarker == -1 || !aHttpAuthorization.substring(0, theMarker).equals(AuthType.BASIC.getName())) {
            throw new IllegalArgumentException("The provided HTTP authorization value does not conform to the format expected for Basic-Authentication.");
        }
        byte[] theCredentialChars = Base64.getDecoder().decode(aHttpAuthorization.substring(theMarker + 1));
        try {
            theCredentialsText = new String(theCredentialChars, Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException e) {
            theCredentialsText = new String(theCredentialChars);
        }
        theMarker = theCredentialsText.indexOf(58);
        this._identity = theCredentialsText.substring(0, theMarker);
        this._secret = theCredentialsText.substring(theMarker + 1);
    }

    @Override
    public String toHttpAuthorization() {
        Object theCredentials = this.getIdentity() + ":" + this.getSecret();
        try {
            theCredentials = Base64.getEncoder().encodeToString(((String)theCredentials).getBytes(Encoding.UTF_8.getCode()));
        }
        catch (UnsupportedEncodingException e) {
            theCredentials = Base64.getEncoder().encodeToString(((String)theCredentials).getBytes());
        }
        theCredentials = AuthType.BASIC.getName() + " " + (String)theCredentials;
        return theCredentials;
    }
}

