/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.net.MalformedURLException;
import java.net.URL;
import org.refcodes.data.Port;
import org.refcodes.data.Scheme;
import org.refcodes.web.Url;

public interface BaseUrlAccessor {
    public Url getBaseUrl();

    public static interface BaseUrlProperty
    extends BaseUrlAccessor,
    BaseUrlMutator {
        default public Url letBaseUrl(Scheme aScheme, String aHost) throws MalformedURLException {
            this.setBaseUrl(aScheme, aHost);
            return this.getBaseUrl();
        }

        default public Url letBaseUrl(Scheme aScheme, String aHost, int aPort) throws MalformedURLException {
            this.setBaseUrl(aScheme, aHost, aPort);
            return this.getBaseUrl();
        }

        default public String letBaseUrl(String aBaseUrl) throws MalformedURLException {
            this.setBaseUrl(aBaseUrl);
            return aBaseUrl;
        }

        default public Url letBaseUrl(Scheme aScheme, String aHost, String aPath) throws MalformedURLException {
            this.setBaseUrl(aScheme, aHost, aPath);
            return this.getBaseUrl();
        }

        default public Url letBaseUrl(Url aBaseUrl) throws MalformedURLException {
            this.setBaseUrl(aBaseUrl);
            return aBaseUrl;
        }

        default public URL letBaseUrl(URL aBaseUrl) throws MalformedURLException {
            this.setBaseUrl(aBaseUrl);
            return aBaseUrl;
        }

        default public Url letBaseUrl(String aProtocol, String aHost) throws MalformedURLException {
            this.setBaseUrl(aProtocol, aHost);
            return this.getBaseUrl();
        }

        default public Url letBaseUrl(String aProtocol, String aHost, int aPort) throws MalformedURLException {
            this.setBaseUrl(aProtocol, aHost, aPort);
            return this.getBaseUrl();
        }

        default public Url letBaseUrl(String aProtocol, String aHost, String aPath) throws MalformedURLException {
            this.setBaseUrl(aProtocol, aHost, aPath);
            return this.getBaseUrl();
        }

        default public Url letBaseUrl(String aProtocol, String aHost, int aPort, String aPath) throws MalformedURLException {
            this.setBaseUrl(aProtocol, aHost, aPort, aPath);
            return this.getBaseUrl();
        }

        default public Url letBaseUrl(Scheme aScheme, String aHost, int aPort, String aPath) throws MalformedURLException {
            this.setBaseUrl(aScheme, aHost, aPort, aPath);
            return this.getBaseUrl();
        }
    }

    public static interface BaseUrlBuilder<B extends BaseUrlBuilder<B>> {
        public B withBaseUrl(Url var1);

        public B withBaseUrl(URL var1);

        default public B withBaseUrl(String aBaseUrl) throws MalformedURLException {
            return this.withBaseUrl(new URL(aBaseUrl));
        }

        default public B withBaseUrl(String aProtocol, String aHost) throws MalformedURLException {
            int thePort = -1;
            if (Scheme.HTTP.getName().equalsIgnoreCase(aProtocol)) {
                thePort = Port.HTTP.getPort();
            }
            if (Scheme.HTTPS.getName().equalsIgnoreCase(aProtocol)) {
                thePort = Port.HTTPS.getPort();
            }
            return this.withBaseUrl(new URL(aProtocol, aHost, thePort, ""));
        }

        default public B withBaseUrl(Scheme aScheme, String aHost) throws MalformedURLException {
            int thePort = -1;
            if (Scheme.HTTP == aScheme) {
                thePort = Port.HTTP.getPort();
            }
            if (Scheme.HTTPS == aScheme) {
                thePort = Port.HTTPS.getPort();
            }
            return this.withBaseUrl(new URL(aScheme.getName(), aHost, thePort, ""));
        }

        default public B withBaseUrl(String aProtocol, String aHost, String aPath) throws MalformedURLException {
            int thePort = -1;
            if (Scheme.HTTP.getName().equalsIgnoreCase(aProtocol)) {
                thePort = Port.HTTP.getPort();
            }
            if (Scheme.HTTPS.getName().equalsIgnoreCase(aProtocol)) {
                thePort = Port.HTTPS.getPort();
            }
            return this.withBaseUrl(new URL(aProtocol, aHost, thePort, aPath));
        }

        default public B withBaseUrl(Scheme aScheme, String aHost, String aPath) throws MalformedURLException {
            int thePort = -1;
            if (Scheme.HTTP == aScheme) {
                thePort = Port.HTTP.getPort();
            }
            if (Scheme.HTTPS == aScheme) {
                thePort = Port.HTTPS.getPort();
            }
            return this.withBaseUrl(new URL(aScheme.getName(), aHost, thePort, aPath));
        }

        default public B withBaseUrl(String aProtocol, String aHost, int aPort) throws MalformedURLException {
            return this.withBaseUrl(new URL(aProtocol, aHost, aPort, ""));
        }

        default public B withBaseUrl(Scheme aScheme, String aHost, int aPort) throws MalformedURLException {
            return this.withBaseUrl(new URL(aScheme.getName(), aHost, aPort, ""));
        }

        default public B withBaseUrl(String aProtocol, String aHost, int aPort, String aPath) throws MalformedURLException {
            return this.withBaseUrl(new URL(aProtocol, aHost, aPort, aPath));
        }

        default public B withBaseUrl(Scheme aScheme, String aHost, int aPort, String aPath) throws MalformedURLException {
            return this.withBaseUrl(new URL(aScheme.getName(), aHost, aPort, aPath));
        }
    }

    public static interface BaseUrlMutator {
        public void setBaseUrl(Url var1);

        public void setBaseUrl(URL var1);

        default public void setBaseUrl(String aBaseUrl) throws MalformedURLException {
            this.setBaseUrl(new URL(aBaseUrl));
        }

        default public void setBaseUrl(String aProtocol, String aHost) throws MalformedURLException {
            int thePort = -1;
            if (Scheme.HTTP.getName().equalsIgnoreCase(aProtocol)) {
                thePort = Port.HTTP.getPort();
            }
            if (Scheme.HTTPS.getName().equalsIgnoreCase(aProtocol)) {
                thePort = Port.HTTPS.getPort();
            }
            this.setBaseUrl(new URL(aProtocol, aHost, thePort, ""));
        }

        default public void setBaseUrl(String aProtocol, String aHost, int aPort) throws MalformedURLException {
            this.setBaseUrl(new URL(aProtocol, aHost, aPort, ""));
        }

        default public void setBaseUrl(Scheme aScheme, String aHost) throws MalformedURLException {
            int thePort = -1;
            if (Scheme.HTTP == aScheme) {
                thePort = Port.HTTP.getPort();
            }
            if (Scheme.HTTPS == aScheme) {
                thePort = Port.HTTPS.getPort();
            }
            this.setBaseUrl(new URL(aScheme.getName(), aHost, thePort, ""));
        }

        default public void setBaseUrl(Scheme aScheme, String aHost, int aPort) throws MalformedURLException {
            this.setBaseUrl(new URL(aScheme.getName(), aHost, aPort, ""));
        }

        default public void setBaseUrl(String aProtocol, String aHost, String aPath) throws MalformedURLException {
            int thePort = -1;
            if (Scheme.HTTP.getName().equalsIgnoreCase(aProtocol)) {
                thePort = Port.HTTP.getPort();
            }
            if (Scheme.HTTPS.getName().equalsIgnoreCase(aProtocol)) {
                thePort = Port.HTTPS.getPort();
            }
            this.setBaseUrl(new URL(aProtocol, aHost, thePort, ""));
        }

        default public void setBaseUrl(String aProtocol, String aHost, int aPort, String aPath) throws MalformedURLException {
            this.setBaseUrl(new URL(aProtocol, aHost, aPort, aPath));
        }

        default public void setBaseUrl(Scheme aScheme, String aHost, String aPath) throws MalformedURLException {
            int thePort = -1;
            if (Scheme.HTTP == aScheme) {
                thePort = Port.HTTP.getPort();
            }
            if (Scheme.HTTPS == aScheme) {
                thePort = Port.HTTPS.getPort();
            }
            this.setBaseUrl(new URL(aScheme.getName(), aHost, thePort, ""));
        }

        default public void setBaseUrl(Scheme aScheme, String aHost, int aPort, String aPath) throws MalformedURLException {
            this.setBaseUrl(new URL(aScheme.getName(), aHost, aPort, aPath));
        }
    }
}

