/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.data.Delimiter;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.Scheme;
import org.refcodes.data.SystemProperty;

public enum Proxy {
    HTTP(EnvironmentVariable.HTTP_PROXY, SystemProperty.HTTP_PROXY_HOST, SystemProperty.HTTP_PROXY_PORT, Scheme.HTTP),
    HTTPS(EnvironmentVariable.HTTPS_PROXY, SystemProperty.HTTPS_PROXY_HOST, SystemProperty.HTTPS_PROXY_PORT, Scheme.HTTPS),
    SOCKS(EnvironmentVariable.HTTP_PROXY, SystemProperty.SOCKS_PROXY_HOST, SystemProperty.SOCKS_PROXY_PORT, Scheme.SOCKS),
    SOCKS4(EnvironmentVariable.HTTP_PROXY, SystemProperty.SOCKS_PROXY_HOST, SystemProperty.SOCKS_PROXY_PORT, Scheme.SOCKS4),
    SOCKS5(EnvironmentVariable.HTTP_PROXY, SystemProperty.SOCKS_PROXY_HOST, SystemProperty.SOCKS_PROXY_PORT, Scheme.SOCKS5);

    private EnvironmentVariable _envProxy;
    private SystemProperty _sysHost;
    private SystemProperty _sysPort;
    private Scheme _protocol;

    private Proxy(EnvironmentVariable environmentVariable, SystemProperty systemProperty, SystemProperty systemProperty2, Scheme scheme) {
        this._envProxy = environmentVariable;
        this._protocol = scheme;
        this._sysHost = systemProperty;
        this._sysPort = systemProperty2;
    }

    public void initialize() {
        Proxy.toProxySettings(this._envProxy, this._sysHost, this._sysPort, this._protocol);
    }

    public static void initializeAll() {
        for (Proxy proxy : Proxy.values()) {
            proxy.initialize();
        }
    }

    protected static void toProxySettings(EnvironmentVariable environmentVariable, SystemProperty systemProperty, SystemProperty systemProperty2, Scheme scheme) {
        String string;
        if ((systemProperty.getValue() == null || systemProperty.getValue().length() == 0) && (string = environmentVariable.getValue()) != null && string.toLowerCase().startsWith(scheme.getMarker().toLowerCase())) {
            int n = string.lastIndexOf(Delimiter.URL_PORT.getChar());
            if (n != -1) {
                try {
                    int n2 = Integer.valueOf(string.substring(n + 1));
                    String string2 = string.substring(0, n);
                    systemProperty.setValue(string2);
                    systemProperty2.setValue("" + n2);
                }
                catch (Exception exception) {
                    systemProperty.setValue(string);
                }
            } else {
                systemProperty.setValue(string);
            }
        }
    }
}

