/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.data.Scheme;
import org.refcodes.io.MaxConnectionsAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.security.KeyStoreDescriptor;
import org.refcodes.security.KeyStoreDescriptorAccessor;
import org.refcodes.web.HttpServerContext;
import org.refcodes.web.SchemeAccessor;

public class HttpServerContextBuilder
implements HttpServerContext,
SchemeAccessor.SchemeProperty,
SchemeAccessor.SchemeBuilder<HttpServerContextBuilder>,
KeyStoreDescriptorAccessor.KeyStoreDescriptorProperty,
KeyStoreDescriptorAccessor.KeyStoreDescriptorBuilder<HttpServerContextBuilder>,
PortAccessor.PortProperty,
PortAccessor.PortBuilder<HttpServerContextBuilder>,
MaxConnectionsAccessor.MaxConnectionsProperty,
MaxConnectionsAccessor.MaxConnectionsBuilder<HttpServerContextBuilder> {
    public static final Scheme DEFAULT_SCHEME = Scheme.HTTP;
    public static final int DEFAULT_PORT = 8080;
    private KeyStoreDescriptor _keyStoreDescriptor = null;
    private int _maxConnections = -1;
    private int _port = 8080;
    private Scheme _scheme = DEFAULT_SCHEME;
    private String _protocol = null;

    public HttpServerContextBuilder() {
    }

    public HttpServerContextBuilder(int n) {
        this._port = n;
    }

    public HttpServerContextBuilder(Scheme scheme, int n) {
        this.setScheme(scheme);
        this._port = n;
    }

    public HttpServerContextBuilder(String string, int n) {
        this.setProtocol(string);
        this._port = n;
    }

    public HttpServerContextBuilder(Scheme scheme, int n, KeyStoreDescriptor keyStoreDescriptor, int n2) {
        this.setScheme(scheme);
        this._port = n;
        this._keyStoreDescriptor = keyStoreDescriptor;
        this._maxConnections = n2;
    }

    public HttpServerContextBuilder(String string, int n, KeyStoreDescriptor keyStoreDescriptor, int n2) {
        this.setProtocol(string);
        this._port = n;
        this._keyStoreDescriptor = keyStoreDescriptor;
        this._maxConnections = n2;
    }

    public KeyStoreDescriptor getKeyStoreDescriptor() {
        return this._keyStoreDescriptor;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public int getPort() {
        return this._port;
    }

    @Override
    public Scheme getScheme() {
        return this._scheme;
    }

    public void setKeyStoreDescriptor(KeyStoreDescriptor keyStoreDescriptor) {
        this._keyStoreDescriptor = keyStoreDescriptor;
    }

    public void setMaxConnections(int n) {
        this._maxConnections = n;
    }

    public void setPort(int n) {
        this._port = n;
    }

    @Override
    public void setScheme(Scheme scheme) {
        this._scheme = scheme;
        this._protocol = null;
    }

    @Override
    public String toProtocol() {
        if (this._scheme != null) {
            return this._scheme.toProtocol();
        }
        return this._protocol;
    }

    @Override
    public void setProtocol(String string) {
        Scheme scheme = Scheme.fromProtocol((String)string);
        if (scheme != null) {
            this._scheme = scheme;
            this._protocol = null;
        } else {
            this._protocol = string;
            this._scheme = null;
        }
    }

    public HttpServerContextBuilder withKeyStoreDescriptor(KeyStoreDescriptor keyStoreDescriptor) {
        this.setKeyStoreDescriptor(keyStoreDescriptor);
        return this;
    }

    public HttpServerContextBuilder withMaxConnections(int n) {
        this.setMaxConnections(n);
        return this;
    }

    public HttpServerContextBuilder withPort(int n) {
        this.setPort(n);
        return this;
    }

    @Override
    public HttpServerContextBuilder withProtocol(String string) {
        this.setProtocol(string);
        return this;
    }

    @Override
    public HttpServerContextBuilder withScheme(Scheme scheme) {
        this.setScheme(scheme);
        return this;
    }
}

