/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.runtime.Terminal;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxStyle;

public enum TableStyle {
    SINGLE(TextBoxStyle.SINGLE, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    SINGLE_HEADER_SINGLE_BODY(TextBoxStyle.SINGLE, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    DOUBLE_SINGLE_HEADER_SINGLE_BODY(TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    DOUBLE(TextBoxStyle.DOUBLE, TextBoxStyle.DOUBLE, TextBoxStyle.DOUBLE),
    DOUBLE_HEADER_DOUBLE_BODY(TextBoxStyle.DOUBLE, TextBoxStyle.DOUBLE, TextBoxStyle.DOUBLE),
    DOUBLE_SINGLE_HEADER_DOUBLE_SINGLE_BODY(TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.DOUBLE_SINGLE),
    SINGLE_DOUBLE_HEADER_SINGLE_BODY(TextBoxStyle.SINGLE_DOUBLE, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    SINGLE_DOUBLE_HEADER_SINGLE_DOUBLE_BODY(TextBoxStyle.SINGLE_DOUBLE, TextBoxStyle.SINGLE_DOUBLE, TextBoxStyle.SINGLE_DOUBLE),
    DOUBLE_HEADER_DOUBLE_SINGLE_BODY(TextBoxStyle.DOUBLE, TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.DOUBLE_SINGLE),
    DOUBLE_SINGLE_HEADER_SINGLE_DASHED_BODY(TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.SINGLE_DASHED, TextBoxStyle.SINGLE_DASHED),
    BOLD(TextBoxStyle.BOLD, TextBoxStyle.BOLD, TextBoxStyle.BOLD),
    BOLD_HEADER_BOLD_BODY(TextBoxStyle.BOLD, TextBoxStyle.BOLD, TextBoxStyle.BOLD),
    BOLD_HEADER_SINGLE_BODY(TextBoxStyle.BOLD_HEADER_SINGLE_BODY, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    HYBRID_BOLD_HEADER_SINGLE_BODY(TextBoxStyle.HYBRID_BOLD_HEADER_SINGLE_BODY, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    ASCII(TextBoxStyle.ASCII, TextBoxStyle.ASCII, TextBoxStyle.ASCII),
    ASCII_HEADER_ASCII_BODY(TextBoxStyle.ASCII, TextBoxStyle.ASCII, TextBoxStyle.ASCII),
    BLANK(TextBoxStyle.BLANK, TextBoxStyle.BLANK, TextBoxStyle.BLANK),
    BLANK_HEADER_BLANK_BODY(TextBoxStyle.BLANK, TextBoxStyle.BLANK, TextBoxStyle.BLANK),
    SINGLE_BLANK_HEADER_SINGLE_BLANK_BODY(TextBoxStyle.SINGLE_BLANK, TextBoxStyle.SINGLE_BLANK, TextBoxStyle.SINGLE_BLANK),
    ASCII_BLANK_HEADER_ASCII_BLANK_BODY(TextBoxStyle.ASCII_BLANK, TextBoxStyle.ASCII_BLANK, TextBoxStyle.ASCII_BLANK);

    public static final TableStyle UNICODE_TABLE_STYLE;
    public static final TableStyle WINDOWS_TABLE_STYLE;
    public static final TableStyle ASCII_TABLE_STYLE;
    private TextBoxGrid _tableHeader;
    private TextBoxGrid _tableBody;
    private TextBoxGrid _tableTail;

    private TableStyle(TextBoxStyle aTableHeader, TextBoxStyle aTableBody, TextBoxStyle aTableTail) {
        this._tableHeader = aTableHeader;
        this._tableBody = aTableBody;
        this._tableTail = aTableTail;
    }

    public TextBoxGrid getHeader() {
        return this._tableHeader;
    }

    public TextBoxGrid getBody() {
        return this._tableBody;
    }

    public TextBoxGrid getTail() {
        return this._tableTail;
    }

    public static TableStyle toTableStyle(String aValue) {
        aValue = aValue != null ? aValue.replaceAll("-", "").replaceAll("_", "") : aValue;
        for (TableStyle eValue : TableStyle.values()) {
            if (!eValue.name().replaceAll("-", "").replaceAll("_", "").equalsIgnoreCase(aValue)) continue;
            return eValue;
        }
        return null;
    }

    public static TableStyle toExecutionTableStyle() {
        return switch (Terminal.toCharSetCapability()) {
            default -> throw new IncompatibleClassChangeError();
            case Terminal.CharSetCapability.UNICODE -> UNICODE_TABLE_STYLE;
            case Terminal.CharSetCapability.WINDOWS -> WINDOWS_TABLE_STYLE;
            case Terminal.CharSetCapability.ASCII -> ASCII_TABLE_STYLE;
        };
    }

    static {
        UNICODE_TABLE_STYLE = HYBRID_BOLD_HEADER_SINGLE_BODY;
        WINDOWS_TABLE_STYLE = SINGLE_HEADER_SINGLE_BODY;
        ASCII_TABLE_STYLE = ASCII_HEADER_ASCII_BODY;
    }
}

