/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.MoreText;
import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.PrintStreamAccessor;
import org.refcodes.mixin.ResetEscapeCodeAccessor;
import org.refcodes.mixin.RowWidthAccessor;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.ColumnFormatMetrics;
import org.refcodes.textual.ColumnFormatMetricsImpl;
import org.refcodes.textual.ColumnWidthMetrics;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.MoreTextBuilder;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TablePrinter;
import org.refcodes.textual.TableStatus;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextFormatMode;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.VertAlignTextBuilder;
import org.refcodes.textual.VertAlignTextMode;

public class TableBuilder
implements TablePrinter,
RowWidthAccessor.RowWidthProperty,
RowWidthAccessor.RowWidthBuilder<TableBuilder>,
PrintStreamAccessor.PrintStreamProperty,
PrintStreamAccessor.PrintStreamBuilder<TableBuilder>,
ResetEscapeCodeAccessor.ResetEscapeCodeProperty,
ResetEscapeCodeAccessor.ResetEscapeCodeBuilder<TableBuilder>,
EscapeCodesStatusAccessor.EscapeCodeStatusProperty,
EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<TableBuilder> {
    private TableStatus _tableStatus = TableStatus.NONE;
    private final List<ColumnRecord> _columnRecords = new ArrayList<ColumnRecord>();
    private int[] _columnWidths = null;
    private int _rowWidth;
    private TableStyle _tableStyle = TableStyle.DOUBLE_SINGLE_HEADER_SINGLE_BODY;
    private String _lineBreak = Terminal.getLineBreak();
    private PrintStream _printStream = System.out;
    private HorizAlignTextMode _headerAlignMode = HorizAlignTextMode.CENTER;
    private HorizAlignTextMode _rowHorizAlignTextMode = HorizAlignTextMode.LEFT;
    private SplitTextMode _headerSplitMode = SplitTextMode.AT_SPACE;
    private SplitTextMode _rowSplitTextMode = SplitTextMode.AT_SPACE;
    private MoreTextMode _headerMoreMode = MoreTextMode.NONE;
    private MoreTextMode _rowMoreTextMode = MoreTextMode.NONE;
    private String _rowEscCode = null;
    private String _borderEscCode = null;
    private String _headerEscCode = null;
    private String _resetEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
    private boolean _hasLeftBorder = true;
    private boolean _hasRightBorder = true;
    private boolean _hasDividerLine = true;
    private TextFormatMode _headerFormatMode = TextFormatMode.TEXT;
    private boolean _isEscCodesEnabled = true;
    private TextFormatMode _rowTextFormatMode = TextFormatMode.TEXT;

    public TableBuilder() {
        this(Terminal.toHeuristicWidth());
    }

    public TableBuilder(RowWidthMode aMode) {
    }

    public TableBuilder(int aRowWidth) {
        this._rowWidth = aRowWidth;
    }

    private String[][] toColumns(String[][] aColumns, VertAlignTextMode aTextBlockMode) {
        int theMaxLines = TableBuilder.toMaxLength(aColumns);
        String[][] theColumns = new String[aColumns.length][];
        for (int i = 0; i < aColumns.length; ++i) {
            theColumns[i] = ((VertAlignTextBuilder)new VertAlignTextBuilder().withText(aColumns[i])).withRowHeight(theMaxLines).withVertAlignTextMode(aTextBlockMode).withEscapeCodesEnabled(this._isEscCodesEnabled).toStrings();
        }
        return theColumns;
    }

    static int[] toColumnWidths(int aTotalWidth, ColumnWidthMetrics ... aColumnWidths) {
        int i;
        int theNumCharWidths = -1;
        int theRelativeWidths = -1;
        block8: for (ColumnWidthMetrics columnWidthMetrics : aColumnWidths) {
            switch (columnWidthMetrics.getColumnWidthType()) {
                case ABSOLUTE: {
                    if (theNumCharWidths == -1) {
                        theNumCharWidths = columnWidthMetrics.getColumnWidth();
                        continue block8;
                    }
                    theNumCharWidths += columnWidthMetrics.getColumnWidth();
                    continue block8;
                }
                case RELATIVE: {
                    if (theRelativeWidths == -1) {
                        theRelativeWidths = columnWidthMetrics.getColumnWidth();
                        continue block8;
                    }
                    theRelativeWidths += columnWidthMetrics.getColumnWidth();
                }
            }
        }
        if (aTotalWidth == -1) {
            aTotalWidth = theNumCharWidths;
        }
        if (theNumCharWidths < aTotalWidth && theRelativeWidths == -1) {
            throw new IllegalArgumentException("Your provided overall number of char width <" + theNumCharWidths + "> does not add up to the total width available of <" + aTotalWidth + "> and you did not specify an percent (%) width to fill up the missing gap.");
        }
        if (theNumCharWidths > aTotalWidth) {
            throw new IllegalArgumentException("The total width available <" + aTotalWidth + "> is exceeded by the provided overall number of char widths <" + theNumCharWidths + "> requested.");
        }
        int[] theColumnWidths = new int[aColumnWidths.length];
        int theRemainderWidth = aTotalWidth - theNumCharWidths;
        int theMaxRelativeWidth = 0;
        for (ColumnWidthMetrics eColumnWidth : aColumnWidths) {
            if (eColumnWidth.getColumnWidthType() != ColumnWidthType.RELATIVE) continue;
            theMaxRelativeWidth += eColumnWidth.getColumnWidth();
        }
        block10: for (i = 0; i < aColumnWidths.length; ++i) {
            ColumnWidthMetrics columnWidthMetrics = aColumnWidths[i];
            switch (columnWidthMetrics.getColumnWidthType()) {
                case ABSOLUTE: {
                    theColumnWidths[i] = columnWidthMetrics.getColumnWidth();
                    continue block10;
                }
                case RELATIVE: {
                    theColumnWidths[i] = (int)((double)theRemainderWidth / (double)theMaxRelativeWidth * (double)columnWidthMetrics.getColumnWidth());
                    continue block10;
                }
                default: {
                    throw new UnhandledEnumBugException((Enum)columnWidthMetrics.getColumnWidthType());
                }
            }
        }
        block11: while (NumericalUtility.sum((int[])theColumnWidths) < aTotalWidth) {
            for (i = 0; i < theColumnWidths.length; ++i) {
                if (aColumnWidths[i].getColumnWidthType() != ColumnWidthType.RELATIVE) continue;
                int n = i;
                theColumnWidths[n] = theColumnWidths[n] + 1;
                if (NumericalUtility.sum((int[])theColumnWidths) == aTotalWidth) break block11;
            }
        }
        block13: while (NumericalUtility.sum((int[])theColumnWidths) > aTotalWidth) {
            i = 0;
            while (i < theColumnWidths.length) {
                int n = i++;
                theColumnWidths[n] = theColumnWidths[n] - 1;
                if (NumericalUtility.sum((int[])theColumnWidths) == aTotalWidth) break block13;
            }
        }
        block15: while (NumericalUtility.sum((int[])theColumnWidths) < aTotalWidth) {
            i = 0;
            while (i < theColumnWidths.length) {
                int n = i++;
                theColumnWidths[n] = theColumnWidths[n] + 1;
                if (NumericalUtility.sum((int[])theColumnWidths) == aTotalWidth) break block15;
            }
        }
        return theColumnWidths;
    }

    public TableBuilder addColumn() {
        this._columnRecords.add(new ColumnRecord());
        this._columnWidths = null;
        return this;
    }

    public TableBuilder addColumn(int aWidth) {
        ColumnRecord theColumn = new ColumnRecord();
        theColumn.setColumnWidth(aWidth);
        this._columnRecords.add(theColumn);
        this._columnWidths = null;
        return this;
    }

    public TableBuilder addColumn(int aWidth, ColumnWidthType aWidthType) {
        ColumnRecord theColumn = new ColumnRecord();
        theColumn.setColumnWidth(aWidth);
        theColumn.setColumnWidthType(aWidthType);
        this._columnRecords.add(theColumn);
        this._columnWidths = null;
        return this;
    }

    public PrintStream getPrintStream() {
        return this._printStream;
    }

    public String getResetEscapeCode() {
        return this._resetEscCode;
    }

    public int getRowWidth() {
        return this._rowWidth;
    }

    @Override
    public TableStatus getTableStatus() {
        return this._tableStatus;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscCodesEnabled;
    }

    public void setPrintStream(PrintStream aPrintStream) {
        this._printStream = aPrintStream;
    }

    public void setResetEscapeCode(String aResetEscCode) {
        this._resetEscCode = aResetEscCode;
    }

    public void setRowWidth(int aRowWidth) {
        this._rowWidth = aRowWidth;
        this.updateColumnWidths();
    }

    @Override
    public TableBuilder setTableStatus(TableStatus aTableStatus) {
        this._tableStatus = aTableStatus;
        return this;
    }

    public int[] toColumnWidths() {
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        return this._columnWidths;
    }

    @Override
    public String toHeader(String ... aColumns) {
        if (this._columnRecords.size() < aColumns.length) {
            int theAdd = aColumns.length - this._columnRecords.size();
            for (int i = 0; i < theAdd; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnTopBorder(this._columnWidths, TableSection.HEADER, theBuilder);
        this.printlnLine(this._columnWidths, TableSection.HEADER, theBuilder, aColumns);
        this._tableStatus = TableStatus.HEADER_CONTINUE;
        return theBuilder.toString();
    }

    @Override
    public String toHeaderBegin() {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column before printing the header.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnTopBorder(this._columnWidths, TableSection.HEADER, theBuilder);
        this._tableStatus = TableStatus.HEADER_BEGIN;
        return theBuilder.toString();
    }

    @Override
    public String toHeaderContinue(String ... aColumns) {
        if (this._columnRecords.size() == 0) {
            for (int i = 0; i < aColumns.length; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnLine(this._columnWidths, TableSection.HEADER, theBuilder, aColumns);
        this._tableStatus = TableStatus.HEADER_CONTINUE;
        return theBuilder.toString();
    }

    @Override
    public String toHeaderEnd() {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column before printing the header.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnBottomBorder(this._columnWidths, TableSection.HEADER, theBuilder);
        this._tableStatus = TableStatus.HEADER_END;
        return theBuilder.toString();
    }

    @Override
    public String toHeaderEnd(TableBuilder aTablePrinter) {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column to this table printer before joining the tables.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        if (aTablePrinter.toColumnWidths().length == 0) {
            throw new IllegalStateException("You must add least a column to the provided table printer before joining the tables.");
        }
        StringBuilder theBuilder = new StringBuilder();
        this.joinRow(aTablePrinter, TableSection.HEADER, theBuilder);
        return theBuilder.toString();
    }

    @Override
    public String toRow(String ... aColumns) {
        if (this._columnRecords.size() == 0 && this._columnRecords.size() == 0) {
            for (int i = 0; i < aColumns.length; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        if (this._tableStatus == TableStatus.NONE) {
            this.printlnTopBorder(this._columnWidths, TableSection.BODY, theBuilder);
        } else if (this._tableStatus == TableStatus.ROW_CONTINUE) {
            this.printlnTopBorder(this._columnWidths, TableSection.BODY, theBuilder);
        } else if (this._tableStatus == TableStatus.HEADER_CONTINUE) {
            this.printlnTopBorder(this._columnWidths, TableSection.HEADER, theBuilder);
        }
        this.printlnLine(this._columnWidths, TableSection.BODY, theBuilder, aColumns);
        this._tableStatus = TableStatus.ROW_CONTINUE;
        return theBuilder.toString();
    }

    @Override
    public String toRowBegin() {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column before printing the header.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnTopBorder(this._columnWidths, TableSection.BODY, theBuilder);
        this._tableStatus = TableStatus.ROW_BEGIN;
        return theBuilder.toString();
    }

    @Override
    public String toRowContinue(String ... aColumns) {
        if (this._columnRecords.size() == 0) {
            for (int i = 0; i < aColumns.length; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnLine(this._columnWidths, TableSection.BODY, theBuilder, aColumns);
        this._tableStatus = TableStatus.ROW_CONTINUE;
        return theBuilder.toString();
    }

    @Override
    public String toRowEnd(TableBuilder aTablePrinter) {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column to this table printer before joining the tables.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        if (aTablePrinter.toColumnWidths().length == 0) {
            throw new IllegalStateException("You must add least a column to the provided table printer before joining the tables.");
        }
        StringBuilder theBuilder = new StringBuilder();
        this.joinRow(aTablePrinter, TableSection.BODY, theBuilder);
        return theBuilder.toString();
    }

    @Override
    public String toTail() {
        StringBuilder theBuilder = new StringBuilder();
        this.printlnBottomBorder(this._columnWidths, TableSection.TAIL, theBuilder);
        return theBuilder.toString();
    }

    public TableBuilder withBorderEscapeCode(String aEscapeCode) {
        this._borderEscCode = aEscapeCode;
        return this;
    }

    public TableBuilder withColumnFormatMetrics(ColumnFormatMetrics aColumnFormatMetrics) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.fromColumnFormatMetrics(aColumnFormatMetrics);
        this._columnWidths = null;
        return this;
    }

    public TableBuilder withColumnHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderHorizAlignTextMode(aHorizAlignTextMode);
        theColumnRecord.setRowHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    public TableBuilder withColumnMoreTextMode(MoreTextMode aMoreTextMode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderMoreTextMode(aMoreTextMode);
        theColumnRecord.setRowMoreTextMode(aMoreTextMode);
        return this;
    }

    public TableBuilder withColumnSplitTextMode(SplitTextMode aSplitTextMode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderSplitTextMode(aSplitTextMode);
        theColumnRecord.setRowSplitTextMode(aSplitTextMode);
        return this;
    }

    public TableBuilder withColumnTextFormatMode(TextFormatMode aTextFormatMode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderTextFormatMode(aTextFormatMode);
        theColumnRecord.setRowTextFormatMode(aTextFormatMode);
        return this;
    }

    public TableBuilder withColumnWidth(int aWidth) {
        return this.withColumnWidth(aWidth, ColumnWidthType.ABSOLUTE);
    }

    public TableBuilder withColumnWidth(int aWidth, ColumnWidthType aWidthType) {
        this.currentColumnRecord().setColumnWidth(aWidth);
        this.currentColumnRecord().setColumnWidthType(aWidthType);
        this._columnWidths = null;
        return this;
    }

    public TableBuilder withColumnWidthMetrics(ColumnWidthMetrics aColumnWidthMetrics) {
        this.currentColumnRecord().setColumnWidth(aColumnWidthMetrics.getColumnWidth());
        this.currentColumnRecord().setColumnWidthType(aColumnWidthMetrics.getColumnWidthType());
        this._columnWidths = null;
        return this;
    }

    public TableBuilder withEscapeCode(String aEscapeCode) {
        this.withBorderEscapeCode(aEscapeCode);
        this.withTextEscapeCode(aEscapeCode);
        return this;
    }

    public void setEscapeCodesEnabled(boolean isEscCodesEnabled) {
        this._isEscCodesEnabled = isEscCodesEnabled;
    }

    public TableBuilder withHeaderColumnEscapeCode(String aEscapeCode) {
        this.currentColumnRecord().setHeaderEscapeCode(aEscapeCode);
        return this;
    }

    public TableBuilder withHeaderColumnHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.currentColumnRecord().setHeaderHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    public TableBuilder withHeaderColumnMoreTextMode(MoreTextMode aMoreTextMode) {
        this.currentColumnRecord().setHeaderMoreTextMode(aMoreTextMode);
        return this;
    }

    public TableBuilder withHeaderColumnSplitTextMode(SplitTextMode aSplitTextMode) {
        this.currentColumnRecord().setHeaderSplitTextMode(aSplitTextMode);
        return this;
    }

    public TableBuilder withHeaderColumnTextFormatMode(TextFormatMode aTextFormatMode) {
        this.currentColumnRecord().setHeaderTextFormatMode(aTextFormatMode);
        return this;
    }

    public TableBuilder withHeaderEscapeCode(String aEscapeCode) {
        if (aEscapeCode != null) {
            if (aEscapeCode.length() > 0 && !aEscapeCode.startsWith("" + AnsiEscapeCode.ESCAPE)) {
                throw new IllegalArgumentException("The provided ANSI Escape-Code does not start with \"" + AnsiEscapeCode.toEscapedSequence((String)("" + AnsiEscapeCode.ESCAPE)) + "\".");
            }
            if (aEscapeCode.isEmpty()) {
                throw new IllegalArgumentException("Either use null to reset the ANSI Escape-Code or provide a valid ANSI Escape-Code with a length > 0.");
            }
        }
        this._headerEscCode = aEscapeCode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderEscapeCode(aEscapeCode);
        }
        return this;
    }

    public TableBuilder withHeaderHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.currentColumnRecord().setHeaderHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    public TableBuilder withHeaderMoreTextMode(MoreTextMode aMoreTextMode) {
        this.currentColumnRecord().setHeaderMoreTextMode(aMoreTextMode);
        return this;
    }

    public TableBuilder withHeaderSplitTextMode(SplitTextMode aSplitTextMode) {
        this.currentColumnRecord().setHeaderSplitTextMode(aSplitTextMode);
        return this;
    }

    public TableBuilder withHeaderTextFormatMode(TextFormatMode aTextFormatMode) {
        this.currentColumnRecord().setHeaderTextFormatMode(aTextFormatMode);
        return this;
    }

    public TableBuilder withHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this._headerAlignMode = aHorizAlignTextMode;
        this._rowHorizAlignTextMode = aHorizAlignTextMode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderHorizAlignTextMode(aHorizAlignTextMode);
            eRecord.setRowHorizAlignTextMode(aHorizAlignTextMode);
        }
        return this;
    }

    public TableBuilder withLeftBorder(boolean hasLeftBorder) {
        this._hasLeftBorder = hasLeftBorder;
        return this;
    }

    public TableBuilder withLineBreak(String aLineBreak) {
        this._lineBreak = aLineBreak;
        return this;
    }

    public TableBuilder withMoreTextMode(MoreTextMode aMoreTextMode) {
        this._headerMoreMode = aMoreTextMode;
        this._rowMoreTextMode = aMoreTextMode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderMoreTextMode(aMoreTextMode);
            eRecord.setRowMoreTextMode(aMoreTextMode);
        }
        return this;
    }

    public TableBuilder withResetEscapeCode(String aEscapeCode) {
        this._resetEscCode = aEscapeCode;
        return this;
    }

    public TableBuilder withRightBorder(boolean hasRightBorder) {
        this._hasRightBorder = hasRightBorder;
        return this;
    }

    public TableBuilder withDividerLine(boolean hasDividerLine) {
        this._hasDividerLine = hasDividerLine;
        return this;
    }

    public TableBuilder withRowColumnEscapeCode(String aEscapeCode) {
        this.currentColumnRecord().setRowEscapeCode(aEscapeCode);
        return this;
    }

    public TableBuilder withRowColumnHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.currentColumnRecord().setRowHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    public TableBuilder withRowColumnMoreTextMode(MoreTextMode aMoreTextMode) {
        this.currentColumnRecord().setRowMoreTextMode(aMoreTextMode);
        return this;
    }

    public TableBuilder withRowColumnSplitTextMode(SplitTextMode aSplitTextMode) {
        this.currentColumnRecord().setRowSplitTextMode(aSplitTextMode);
        return this;
    }

    public TableBuilder withRowColumnTextFormatMode(TextFormatMode aTextFormatMode) {
        this.currentColumnRecord().setRowTextFormatMode(aTextFormatMode);
        return this;
    }

    public TableBuilder withRowEscapeCode(String aEscapeCode) {
        if (aEscapeCode != null) {
            if (aEscapeCode.length() > 0 && !aEscapeCode.startsWith("" + AnsiEscapeCode.ESCAPE)) {
                throw new IllegalArgumentException("The provided ANSI Escape-Code does not start with \"" + AnsiEscapeCode.toEscapedSequence((String)("" + AnsiEscapeCode.ESCAPE)) + "\".");
            }
            if (aEscapeCode.isEmpty()) {
                throw new IllegalArgumentException("Either use null to reset the ANSI Escape-Code or provide a valid ANSI Escape-Code with a length > 0.");
            }
        }
        this._rowEscCode = aEscapeCode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setRowEscapeCode(aEscapeCode);
        }
        return this;
    }

    public TableBuilder withRowHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this._rowHorizAlignTextMode = aHorizAlignTextMode;
        return this;
    }

    public TableBuilder withRowMoreTextMode(MoreTextMode aMoreTextMode) {
        this._rowMoreTextMode = aMoreTextMode;
        return this;
    }

    public TableBuilder withRowSplitTextMode(SplitTextMode aSplitTextMode) {
        this._rowSplitTextMode = aSplitTextMode;
        return this;
    }

    public TableBuilder withRowTextFormatMode(TextFormatMode aTextFormatMode) {
        this._rowTextFormatMode = aTextFormatMode;
        return this;
    }

    public TableBuilder withRowWidth(int aRowWidth) {
        this.setRowWidth(aRowWidth);
        return this;
    }

    public TableBuilder withSplitTextMode(SplitTextMode aSplitTextMode) {
        this._headerSplitMode = aSplitTextMode;
        this._rowSplitTextMode = aSplitTextMode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderSplitTextMode(aSplitTextMode);
            eRecord.setRowSplitTextMode(aSplitTextMode);
        }
        return this;
    }

    public TableBuilder withTableStyle(TableStyle aTableStyle) {
        this.setTableStyle(aTableStyle);
        return this;
    }

    public void setTableStyle(TableStyle aTableStyle) {
        this._tableStyle = aTableStyle;
    }

    public TableBuilder withTextColumnEscapeCode(String aEscapeCode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderEscapeCode(aEscapeCode);
        theColumnRecord.setRowEscapeCode(aEscapeCode);
        return this;
    }

    public TableBuilder withTextEscapeCode(String aEscapeCode) {
        if (aEscapeCode != null) {
            if (aEscapeCode.length() > 0 && !aEscapeCode.startsWith("" + AnsiEscapeCode.ESCAPE)) {
                throw new IllegalArgumentException("The provided ANSI Escape-Code does not start with \"" + AnsiEscapeCode.toEscapedSequence((String)("" + AnsiEscapeCode.ESCAPE)) + "\".");
            }
            if (aEscapeCode.isEmpty()) {
                throw new IllegalArgumentException("Either use null to reset the ANSI Escape-Code or provide a valid ANSI Escape-Code with a length > 0.");
            }
        }
        this._headerEscCode = aEscapeCode;
        this._rowEscCode = aEscapeCode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderEscapeCode(aEscapeCode);
            eRecord.setRowEscapeCode(aEscapeCode);
        }
        return this;
    }

    public TableBuilder withTextFormatMode(TextFormatMode aTextFormatMode) {
        this._headerFormatMode = aTextFormatMode;
        this._rowTextFormatMode = aTextFormatMode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderTextFormatMode(aTextFormatMode);
            eRecord.setRowTextFormatMode(aTextFormatMode);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeader(String ... aColumns) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeader(aColumns));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeaderBegin() {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeaderBegin());
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeaderContinue(String ... aColumns) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeaderContinue(aColumns));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeaderEnd() {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeaderEnd());
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeaderEnd(TableBuilder aTablePrinter) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeaderEnd(aTablePrinter));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printRow(String ... aColumns) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toRow(aColumns));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printRowBegin() {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toRowBegin());
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printRowContinue(String ... aColumns) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toRowContinue(aColumns));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printRowEnd(TableBuilder aTablePrinter) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toRowEnd(aTablePrinter));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printTail() {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toTail());
            this.getPrintStream().flush();
        }
    }

    public TableBuilder withEscapeCodesEnabled(boolean isEscCodesEnabled) {
        this.setEscapeCodesEnabled(isEscCodesEnabled);
        return this;
    }

    public TableBuilder withPrintStream(PrintStream aPrintStream) {
        this.setPrintStream(aPrintStream);
        return this;
    }

    static TableBuilder build() {
        return new TableBuilder();
    }

    private void appendEscapeBorder(StringBuilder aBuilder) {
        if (this._isEscCodesEnabled && this._borderEscCode != null) {
            aBuilder.append(this._borderEscCode);
        }
    }

    private void appendEscapeReset(StringBuilder aBuilder) {
        if (this._isEscCodesEnabled && this._borderEscCode != null) {
            aBuilder.append(this._resetEscCode);
        }
    }

    private void buildBottomBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        TextBoxGrid theTableStyle;
        TextBoxGrid textBoxGrid = theTableStyle = aTableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getTail();
        if (this._hasLeftBorder) {
            aBuilder.append(theTableStyle.getBottomLeftEdge());
        }
        for (int i = 0; i < aColumnWidths.length; ++i) {
            if (i > 0) {
                aBuilder.append(theTableStyle.getBottomDividerEdge());
            }
            aBuilder.append(new TextLineBuilder().withColumnWidth(aColumnWidths[i]).withLineChar(((Character)theTableStyle.getBottomLine()).charValue()).toString());
        }
        if (this._hasRightBorder) {
            aBuilder.append(theTableStyle.getBottomRightEdge());
        }
    }

    private void buildTopBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        TextBoxGrid theLineStyle;
        TextBoxGrid textBoxGrid = theLineStyle = aTableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getBody();
        if (this._hasLeftBorder) {
            if (this._tableStatus == TableStatus.NONE || this._tableStatus == TableStatus.ROW_END) {
                aBuilder.append(theLineStyle.getTopLeftEdge());
            } else {
                aBuilder.append(theLineStyle.getLeftEdge());
            }
        }
        for (int i = 0; i < aColumnWidths.length; ++i) {
            if (i > 0) {
                if (this._tableStatus == TableStatus.NONE || this._tableStatus == TableStatus.ROW_END) {
                    aBuilder.append(theLineStyle.getTopDividerEdge());
                } else {
                    aBuilder.append(theLineStyle.getDividerEdge());
                }
            }
            aBuilder.append(new TextLineBuilder().withColumnWidth(aColumnWidths[i]).withLineChar(((Character)theLineStyle.getTopLine()).charValue()).toString());
        }
        if (this._hasRightBorder) {
            if (this._tableStatus == TableStatus.NONE || this._tableStatus == TableStatus.ROW_END) {
                aBuilder.append(theLineStyle.getTopRightEdge());
            } else {
                aBuilder.append(theLineStyle.getRightEdge());
            }
        }
    }

    private ColumnRecord currentColumnRecord() {
        int columnSize = this._columnRecords.size();
        if (columnSize == 0) {
            this.addColumn();
            ++columnSize;
        }
        ColumnRecord theColumnRecord = this._columnRecords.get(columnSize - 1);
        return theColumnRecord;
    }

    private void joinRow(TableBuilder aTablePrinter, TableSection aTableSection, StringBuilder aBuilder) {
        int i;
        StringBuilder theShortBuilder;
        StringBuilder theLongBuilder;
        this._tableStatus = TableStatus.ROW_END;
        TextBoxGrid theTableStyle = aTableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getBody();
        StringBuilder theTopBuilder = new StringBuilder();
        this.buildTopBorder(this.toColumnWidths(), aTableSection, theTopBuilder);
        StringBuilder theBottomBuilder = new StringBuilder();
        this.buildTopBorder(aTablePrinter.toColumnWidths(), aTableSection, theBottomBuilder);
        if (theBottomBuilder.length() < theTopBuilder.length()) {
            theLongBuilder = theTopBuilder;
            theShortBuilder = theBottomBuilder;
        } else {
            theShortBuilder = theTopBuilder;
            theLongBuilder = theBottomBuilder;
        }
        if (this._hasLeftBorder) {
            theLongBuilder.replace(0, 1, String.valueOf(theTableStyle.getLeftEdge()));
        }
        for (i = 1; i < theShortBuilder.length() - 1; ++i) {
            if (theShortBuilder.charAt(i) != theLongBuilder.charAt(i)) {
                if (theBottomBuilder.charAt(i) == ((Character)theTableStyle.getTopLine()).charValue()) {
                    theLongBuilder.replace(i, i + 1, "" + theTopBuilder.charAt(i));
                    continue;
                }
                if (theTopBuilder.charAt(i) != ((Character)theTableStyle.getTopLine()).charValue()) continue;
                theLongBuilder.replace(i, i + 1, String.valueOf(theTableStyle.getBottomDividerEdge()));
                continue;
            }
            if (theTopBuilder.charAt(i) == ((Character)theTableStyle.getTopLine()).charValue()) continue;
            theLongBuilder.replace(i, i + 1, String.valueOf(theTableStyle.getDividerEdge()));
        }
        if (theShortBuilder.length() != theLongBuilder.length()) {
            if (theShortBuilder.charAt(theShortBuilder.length() - 1) != theLongBuilder.charAt(theShortBuilder.length() - 1)) {
                if (theShortBuilder == theTopBuilder) {
                    if (theLongBuilder.charAt(theShortBuilder.length() - 1) == ((Character)theTableStyle.getTopDividerEdge()).charValue()) {
                        theLongBuilder.replace(theShortBuilder.length() - 1, theShortBuilder.length(), String.valueOf(theTableStyle.getDividerEdge()));
                    } else {
                        theLongBuilder.replace(theShortBuilder.length() - 1, theShortBuilder.length(), String.valueOf(theTableStyle.getTopDividerEdge()));
                    }
                    if (this._hasRightBorder) {
                        theLongBuilder.replace(theLongBuilder.length() - 1, theLongBuilder.length(), String.valueOf(theTableStyle.getBottomRightEdge()));
                    }
                } else if (theLongBuilder.charAt(theShortBuilder.length() - 1) == ((Character)theTableStyle.getTopDividerEdge()).charValue()) {
                    theLongBuilder.replace(theShortBuilder.length() - 1, theShortBuilder.length(), String.valueOf(theTableStyle.getDividerEdge()));
                } else {
                    theLongBuilder.replace(theShortBuilder.length() - 1, theShortBuilder.length(), String.valueOf(theTableStyle.getBottomDividerEdge()));
                }
            }
            if (theLongBuilder == theBottomBuilder) {
                for (i = theShortBuilder.length(); i < theLongBuilder.length() - 1; ++i) {
                    if (theLongBuilder.charAt(i) != ((Character)theTableStyle.getTopDividerEdge()).charValue()) continue;
                    theLongBuilder.replace(i, i + 1, String.valueOf(theTableStyle.getBottomDividerEdge()));
                }
            }
        } else if (this._hasRightBorder) {
            theLongBuilder.replace(theLongBuilder.length() - 1, theLongBuilder.length(), String.valueOf(theTableStyle.getRightEdge()));
        }
        this.appendEscapeBorder(aBuilder);
        aBuilder.append(theLongBuilder.toString());
        this.appendEscapeReset(aBuilder);
        aBuilder.append(this._lineBreak);
    }

    private void printBottomBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        this.appendEscapeBorder(aBuilder);
        this.buildBottomBorder(aColumnWidths, aTableSection, aBuilder);
        this.appendEscapeReset(aBuilder);
    }

    private void printlnBottomBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        this.printBottomBorder(aColumnWidths, aTableSection, aBuilder);
        aBuilder.append(this._lineBreak);
    }

    private void printlnLine(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder, String ... aColumns) {
        int j;
        int i;
        if (this._columnRecords.size() != aColumns.length) {
            throw new IllegalStateException("You have passed <" + aColumns.length + "> column text arguments, you have added <" + this._columnRecords.size() + "> columns, though you must pass as many column text arguments as you have added columns. Hint: Maybe you modified a column's layout without adding a column beforehand; in such a case a column is added automatically which results in an unintended number of columns.");
        }
        TextBoxGrid theLineStyle = aTableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getBody();
        String[][] theColumns = new String[aColumns.length][];
        for (i = 0; i < aColumns.length; ++i) {
            aColumns[i] = MoreTextBuilder.asMoreText(aColumns[i], aColumnWidths[i], "" + MoreText.MORE_TEXT_BEFORE.getChar(), this._columnRecords.get(i).getMoreTextMode(aTableSection), this._isEscCodesEnabled);
            theColumns[i] = TextBlockBuilder.asTextBlock(aColumns[i], aColumnWidths[i], this._columnRecords.get(i).getHorizAlignTextMode(aTableSection), this._columnRecords.get(i).getSplitTextMode(aTableSection), ' ', this._isEscCodesEnabled);
            if (theColumns[i] == null) {
                theColumns[i] = new String[]{""};
            }
            for (j = 0; j < theColumns[i].length; ++j) {
                theColumns[i][j] = HorizAlignTextBuilder.asAligned(theColumns[i][j], aColumnWidths[i], ' ', this._columnRecords.get(i).getHorizAlignTextMode(aTableSection), this._isEscCodesEnabled);
            }
        }
        theColumns = this.toColumns(theColumns, VertAlignTextMode.TOP);
        for (i = 0; i < theColumns.length; ++i) {
            theColumns[i] = this.toEscapeColumn(this._columnRecords.get(i), aTableSection, theColumns[i], aColumns[i]);
        }
        for (i = 0; i < theColumns[0].length; ++i) {
            if (this._hasLeftBorder) {
                this.appendEscapeBorder(aBuilder);
                aBuilder.append(theLineStyle.getLeftLine());
            }
            this.appendEscapeReset(aBuilder);
            for (j = 0; j < theColumns.length; ++j) {
                if (j > 0) {
                    if (this._hasDividerLine) {
                        this.appendEscapeBorder(aBuilder);
                        aBuilder.append(theLineStyle.getDividerLine());
                    }
                    this.appendEscapeReset(aBuilder);
                }
                aBuilder.append(theColumns[j][i]);
            }
            if (this._hasRightBorder) {
                this.appendEscapeBorder(aBuilder);
                aBuilder.append(theLineStyle.getRightLine());
            }
            this.appendEscapeReset(aBuilder);
            aBuilder.append(this._lineBreak);
        }
    }

    private void printlnTopBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        this.printTopBorder(aColumnWidths, aTableSection, aBuilder);
        aBuilder.append(this._lineBreak);
    }

    private void printTopBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        this.appendEscapeBorder(aBuilder);
        this.buildTopBorder(aColumnWidths, aTableSection, aBuilder);
        this.appendEscapeReset(aBuilder);
    }

    private String[] toEscapeColumn(ColumnRecord aColumnRecord, TableSection aTableSection, String[] aColumns, String aIdentifier) {
        String theEscCode;
        if (this._isEscCodesEnabled && (theEscCode = aColumnRecord.toEscapeCode(aTableSection, aIdentifier)) != null) {
            block0: for (int i = 0; i < aColumns.length; ++i) {
                if (aColumnRecord.getTextFormatMode(aTableSection) == TextFormatMode.TEXT) {
                    int j;
                    if (aColumns[i].length() > 0) {
                        if (aColumns[i].charAt(0) != ' ') {
                            aColumns[i] = theEscCode + aColumns[i];
                        } else {
                            for (j = 0; j < aColumns[i].length(); ++j) {
                                if (aColumns[i].charAt(j) == ' ') continue;
                                aColumns[i] = aColumns[i].substring(0, j) + theEscCode + aColumns[i].substring(j);
                                break;
                            }
                        }
                    }
                    if (aColumns[i].charAt(aColumns[i].length() - 1) != ' ') {
                        aColumns[i] = aColumns[i] + this._resetEscCode;
                        continue;
                    }
                    for (j = aColumns[i].length() - 1; j >= 0; --j) {
                        if (aColumns[i].charAt(j) == ' ') continue;
                        aColumns[i] = aColumns[i].substring(0, j + 1) + this._resetEscCode + aColumns[i].substring(j + 1);
                        continue block0;
                    }
                    continue;
                }
                if (aColumnRecord.getTextFormatMode(aTableSection) != TextFormatMode.CELL) continue;
                aColumns[i] = theEscCode + aColumns[i] + this._resetEscCode;
            }
        }
        return aColumns;
    }

    @SafeVarargs
    private static <T> int toMaxLength(T[] ... aObjects) {
        int theMaxLength = -1;
        for (T[] eArray : aObjects) {
            if (eArray == null || eArray.length <= theMaxLength) continue;
            theMaxLength = eArray.length;
        }
        return theMaxLength;
    }

    private void updateColumnWidths() {
        int theWidth;
        if (this._columnRecords.isEmpty()) {
            return;
        }
        if (this._rowWidth <= 0) {
            theWidth = -1;
        } else {
            theWidth = this._rowWidth - (this._columnRecords.size() + 1);
            if (!this._hasLeftBorder) {
                ++theWidth;
            }
            if (!this._hasRightBorder) {
                ++theWidth;
            }
            if (!this._hasDividerLine) {
                theWidth += this._columnRecords.size() - 1;
            }
        }
        this._columnWidths = TableBuilder.toColumnWidths(theWidth, this._columnRecords.toArray(new ColumnRecord[this._columnRecords.size()]));
    }

    private class ColumnRecord
    extends ColumnFormatMetricsImpl {
        public ColumnRecord() {
            super(1, ColumnWidthType.RELATIVE);
            this.setHeaderHorizAlignTextMode(TableBuilder.this._headerAlignMode);
            this.setRowHorizAlignTextMode(TableBuilder.this._rowHorizAlignTextMode);
            this.setHeaderSplitTextMode(TableBuilder.this._headerSplitMode);
            this.setRowSplitTextMode(TableBuilder.this._rowSplitTextMode);
            this.setHeaderEscapeCode(TableBuilder.this._headerEscCode);
            this.setRowEscapeCode(TableBuilder.this._rowEscCode);
            this.setHeaderTextFormatMode(TableBuilder.this._headerFormatMode);
            this.setRowTextFormatMode(TableBuilder.this._rowTextFormatMode);
            this.setHeaderMoreTextMode(TableBuilder.this._headerMoreMode);
            this.setRowMoreTextMode(TableBuilder.this._rowMoreTextMode);
        }

        private HorizAlignTextMode getHorizAlignTextMode(TableSection aTableSection) {
            if (aTableSection == TableSection.HEADER) {
                return this.getHeaderHorizAlignTextMode();
            }
            if (aTableSection == TableSection.BODY) {
                return this.getRowHorizAlignTextMode();
            }
            throw new RuntimeException("Unknown table section <" + String.valueOf((Object)aTableSection) + ">, allowed values are <" + String.valueOf((Object)TableSection.HEADER) + "> and <" + String.valueOf((Object)TableSection.BODY) + ">.");
        }

        private MoreTextMode getMoreTextMode(TableSection aTableSection) {
            if (aTableSection == TableSection.HEADER) {
                return this.getHeaderMoreTextMode();
            }
            if (aTableSection == TableSection.BODY) {
                return this.getRowMoreTextMode();
            }
            throw new RuntimeException("Unknown table section <" + String.valueOf((Object)aTableSection) + ">, allowed values are <" + String.valueOf((Object)TableSection.HEADER) + "> and <" + String.valueOf((Object)TableSection.BODY) + ">.");
        }

        private SplitTextMode getSplitTextMode(TableSection aTableSection) {
            if (aTableSection == TableSection.HEADER) {
                return this.getHeaderSplitTextMode();
            }
            if (aTableSection == TableSection.BODY) {
                return this.getRowSplitTextMode();
            }
            throw new RuntimeException("Unknown table section <" + String.valueOf((Object)aTableSection) + ">, allowed values are <" + String.valueOf((Object)TableSection.HEADER) + "> and <" + String.valueOf((Object)TableSection.BODY) + ">.");
        }

        private TextFormatMode getTextFormatMode(TableSection aTableSection) {
            if (aTableSection == TableSection.HEADER) {
                return this.getHeaderTextFormatMode();
            }
            if (aTableSection == TableSection.BODY) {
                return this.getRowTextFormatMode();
            }
            throw new RuntimeException("Unknown table section <" + String.valueOf((Object)aTableSection) + ">, allowed values are <" + String.valueOf((Object)TableSection.HEADER) + "> and <" + String.valueOf((Object)TableSection.BODY) + ">.");
        }

        private String toEscapeCode(TableSection aTableSection, String aIdentifier) {
            if (aTableSection == TableSection.HEADER) {
                return this.toHeaderEscapeCode(aIdentifier);
            }
            if (aTableSection == TableSection.BODY) {
                return this.toRowEscapeCode(aIdentifier);
            }
            throw new RuntimeException("Unknown table section <" + String.valueOf((Object)aTableSection) + ">, allowed values are <" + String.valueOf((Object)TableSection.HEADER) + "> and <" + String.valueOf((Object)TableSection.BODY) + ">.");
        }
    }

    private static enum TableSection {
        HEADER,
        BODY,
        TAIL;

    }

    public static enum RowWidthMode {
        COLUMNS,
        TERMINAL;

    }
}

