/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.CharSet;
import org.refcodes.mixin.CharSetAccessor;

public enum RandomTextMode implements CharSetAccessor
{
    ASCII(CharSet.ASCII.getCharSet()),
    ALPHABETIC(CharSet.ALPHABETIC.getCharSet()),
    UPPER_CASE(CharSet.UPPER_CASE.getCharSet()),
    LOWER_CASE(CharSet.LOWER_CASE.getCharSet()),
    ALPHANUMERIC(CharSet.ALPHANUMERIC.getCharSet()),
    UPPER_CASE_ALPHANUMERIC(RandomTextMode.asConcat(CharSet.UPPER_CASE.getCharSet(), CharSet.NUMERIC.getCharSet())),
    LOWER_CASE_ALPHANUMERIC(RandomTextMode.asConcat(CharSet.LOWER_CASE.getCharSet(), CharSet.NUMERIC.getCharSet())),
    NUMERIC(CharSet.NUMERIC.getCharSet()),
    BINARY(CharSet.BINARY.getCharSet()),
    HEXADECIMAL(CharSet.HEXADECIMAL.getCharSet());

    private char[] _charSet;

    private RandomTextMode(char[] aCharSet) {
        this._charSet = aCharSet;
    }

    public char[] getCharSet() {
        return this._charSet;
    }

    private static char[] asConcat(char[] aHead, char[] aTail) {
        char[] theResult = new char[aHead.length + aTail.length];
        System.arraycopy(aHead, 0, theResult, 0, aHead.length);
        System.arraycopy(aTail, 0, theResult, aHead.length, aTail.length);
        return theResult;
    }
}

