/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.refcodes.data.Delimiter;
import org.refcodes.textual.CsvEscapeMode;
import org.refcodes.textual.CsvMixin;

public class CsvBuilder
implements CsvMixin {
    private String _record = null;
    private Collection<Object> _fields = null;
    private char _delimiterChar = Delimiter.CSV.getChar();
    private CsvEscapeMode _csvEscapeMode = CsvEscapeMode.ESCAPED;
    private boolean _isTrim = true;
    private String[] _commentPrefixes = null;

    public void setTrim(boolean bl) {
        this._isTrim = bl;
    }

    public boolean isTrim() {
        return this._isTrim;
    }

    @Override
    public CsvEscapeMode getCsvEscapeMode() {
        return this._csvEscapeMode;
    }

    @Override
    public void setCsvEscapeMode(CsvEscapeMode csvEscapeMode) {
        this._csvEscapeMode = csvEscapeMode;
    }

    public void setRecord(String string) {
        this._record = string;
    }

    public String getRecord() {
        return this._record;
    }

    public void setFields(Object ... objectArray) {
        this._fields = CsvBuilder.toCollection(objectArray);
    }

    public Collection<Object> getFields() {
        return this._fields;
    }

    public void setFields(Collection<Object> collection) {
        this._fields = collection;
    }

    public char getDelimiter() {
        return this._delimiterChar;
    }

    public void setDelimiter(char c) {
        this._delimiterChar = c;
    }

    public List<String> toFields() throws IllegalStateException {
        if (!this.isComment(this._record)) {
            return CsvBuilder.asFields(this._record, this._delimiterChar, this._csvEscapeMode, this._isTrim);
        }
        return null;
    }

    public String toRecord() throws IllegalStateException {
        return CsvBuilder.asRecord(this._fields, this._delimiterChar, this._csvEscapeMode);
    }

    public String toRecord(Object ... objectArray) {
        return CsvBuilder.asRecord(CsvBuilder.toCollection(objectArray), this._delimiterChar, this._csvEscapeMode);
    }

    public String toRecord(Collection<Object> collection) {
        return CsvBuilder.asRecord(collection, this._delimiterChar, this._csvEscapeMode);
    }

    public String[] toStrings() throws IllegalStateException {
        List<String> list = this.toFields();
        if (list != null) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public String toRecord(String ... stringArray) throws IllegalStateException {
        return CsvBuilder.asRecord(CsvBuilder.toCollection(stringArray), this._delimiterChar, this._csvEscapeMode);
    }

    public String[] toStrings(String string) {
        return CsvBuilder.asStrings(string, this._delimiterChar, this._csvEscapeMode, this._isTrim, this.getCommentPrefixes());
    }

    public String toString() throws IllegalStateException {
        return this.toRecord();
    }

    @Override
    public void setCommentPrefixes(String ... stringArray) {
        this._commentPrefixes = stringArray;
    }

    @Override
    public String[] getCommentPrefixes() {
        return this._commentPrefixes;
    }

    @Override
    public void clearCommentPrefixes() {
        this._commentPrefixes = null;
    }

    public CsvBuilder withTrim(boolean bl) {
        this.setTrim(bl);
        return this;
    }

    @Override
    public CsvBuilder withCsvEscapeMode(CsvEscapeMode csvEscapeMode) {
        this.setCsvEscapeMode(csvEscapeMode);
        return this;
    }

    public CsvBuilder withDelimiter(char c) {
        this.setDelimiter(c);
        return this;
    }

    @Override
    public CsvBuilder withCommentPrefixes(String ... stringArray) {
        this.setCommentPrefixes(stringArray);
        return this;
    }

    public CsvBuilder withRecord(String string) {
        this.setRecord(string);
        return this;
    }

    public void setFields(boolean ... blArray) {
        Boolean[] booleanArray = new Boolean[blArray.length];
        for (int i = 0; i < booleanArray.length; ++i) {
            booleanArray[i] = blArray[i];
        }
        this.setFields((Object[])booleanArray);
    }

    public void setFields(byte ... byArray) {
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        this.setFields((Object[])byteArray);
    }

    public void setFields(short ... sArray) {
        Short[] shortArray = new Short[sArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            shortArray[i] = sArray[i];
        }
        this.setFields((Object[])shortArray);
    }

    public void setFields(int ... nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        this.setFields((Object[])integerArray);
    }

    public void setFields(long ... lArray) {
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            longArray[i] = lArray[i];
        }
        this.setFields((Object[])longArray);
    }

    public void setFields(float ... fArray) {
        Float[] floatArray = new Float[fArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            floatArray[i] = Float.valueOf(fArray[i]);
        }
        this.setFields((Object[])floatArray);
    }

    public void setFields(double ... dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        this.setFields((Object[])doubleArray);
    }

    public void setFields(char ... cArray) {
        Character[] characterArray = new Character[cArray.length];
        for (int i = 0; i < characterArray.length; ++i) {
            characterArray[i] = Character.valueOf(cArray[i]);
        }
        this.setFields((Object[])characterArray);
    }

    public CsvBuilder withFields(boolean ... blArray) {
        this.setFields(blArray);
        return this;
    }

    public CsvBuilder withFields(byte ... byArray) {
        this.setFields(byArray);
        return this;
    }

    public CsvBuilder withFields(short ... sArray) {
        this.setFields(sArray);
        return this;
    }

    public CsvBuilder withFields(int ... nArray) {
        this.setFields(nArray);
        return this;
    }

    public CsvBuilder withFields(long ... lArray) {
        this.setFields(lArray);
        return this;
    }

    public CsvBuilder withFields(float ... fArray) {
        this.setFields(fArray);
        return this;
    }

    public CsvBuilder withFields(double ... dArray) {
        this.setFields(dArray);
        return this;
    }

    public CsvBuilder withFields(char ... cArray) {
        this.setFields(cArray);
        return this;
    }

    public void setFields(Boolean ... booleanArray) {
        this.setFields((Object[])booleanArray);
    }

    public void setFields(Byte ... byteArray) {
        this.setFields((Object[])byteArray);
    }

    public void setFields(Short ... shortArray) {
        this.setFields((Object[])shortArray);
    }

    public void setFields(Integer ... integerArray) {
        this.setFields((Object[])integerArray);
    }

    public void setFields(Long ... longArray) {
        this.setFields((Object[])longArray);
    }

    public void setFields(Float ... floatArray) {
        this.setFields((Object[])floatArray);
    }

    public void setFields(Double ... doubleArray) {
        this.setFields((Object[])doubleArray);
    }

    public void setFields(Character ... characterArray) {
        this.setFields((Object[])characterArray);
    }

    public void setFields(String ... stringArray) {
        this.setFields((Object[])stringArray);
    }

    public CsvBuilder withFields(Object ... objectArray) {
        this.setFields(objectArray);
        return this;
    }

    public CsvBuilder withFields(Boolean ... booleanArray) {
        this.setFields((Object[])booleanArray);
        return this;
    }

    public CsvBuilder withFields(Byte ... byteArray) {
        this.setFields((Object[])byteArray);
        return this;
    }

    public CsvBuilder withFields(Short ... shortArray) {
        this.setFields((Object[])shortArray);
        return this;
    }

    public CsvBuilder withFields(Integer ... integerArray) {
        this.setFields((Object[])integerArray);
        return this;
    }

    public CsvBuilder withFields(Long ... longArray) {
        this.setFields((Object[])longArray);
        return this;
    }

    public CsvBuilder withFields(Float ... floatArray) {
        this.setFields((Object[])floatArray);
        return this;
    }

    public CsvBuilder withFields(Double ... doubleArray) {
        this.setFields((Object[])doubleArray);
        return this;
    }

    public CsvBuilder withFields(Character ... characterArray) {
        this.setFields((Object[])characterArray);
        return this;
    }

    public CsvBuilder withFields(String ... stringArray) {
        this.setFields((Object[])stringArray);
        return this;
    }

    public CsvBuilder withFields(Collection<Object> collection) {
        this.setFields(collection);
        return this;
    }

    public String toRecord(boolean ... blArray) {
        Boolean[] booleanArray = new Boolean[blArray.length];
        Arrays.setAll(booleanArray, n -> blArray[n]);
        return this.toRecord(booleanArray);
    }

    public String toRecord(byte ... byArray) {
        Byte[] byteArray = new Byte[byArray.length];
        Arrays.setAll(byteArray, n -> byArray[n]);
        return this.toRecord(byteArray);
    }

    public String toRecord(short ... sArray) {
        Short[] shortArray = new Short[sArray.length];
        Arrays.setAll(shortArray, n -> sArray[n]);
        return this.toRecord(shortArray);
    }

    public String toRecord(int ... nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        Arrays.setAll(integerArray, n -> nArray[n]);
        return this.toRecord(integerArray);
    }

    public String toRecord(long ... lArray) {
        Long[] longArray = new Long[lArray.length];
        Arrays.setAll(longArray, n -> lArray[n]);
        return this.toRecord(longArray);
    }

    public String toRecord(float ... fArray) {
        Float[] floatArray = new Float[fArray.length];
        Arrays.setAll(floatArray, n -> Float.valueOf(fArray[n]));
        return this.toRecord(floatArray);
    }

    public String toRecord(double ... dArray) {
        Double[] doubleArray = new Double[dArray.length];
        Arrays.setAll(doubleArray, n -> dArray[n]);
        return this.toRecord(doubleArray);
    }

    public String toRecord(char ... cArray) {
        Character[] characterArray = new Character[cArray.length];
        Arrays.setAll(characterArray, n -> Character.valueOf(cArray[n]));
        return this.toRecord(characterArray);
    }

    public String toString(Object ... objectArray) {
        return this.toRecord(objectArray);
    }

    public String toRecord(Boolean ... booleanArray) {
        return this.toRecord((Object[])booleanArray);
    }

    public String toRecord(Byte ... byteArray) {
        return this.toRecord((Object[])byteArray);
    }

    public String toRecord(Short ... shortArray) {
        return this.toRecord((Object[])shortArray);
    }

    public String toRecord(Integer ... integerArray) {
        return this.toRecord((Object[])integerArray);
    }

    public String toRecord(Long ... longArray) {
        return this.toRecord((Object[])longArray);
    }

    public String toRecord(Float ... floatArray) {
        return this.toRecord((Object[])floatArray);
    }

    public String toRecord(Double ... doubleArray) {
        return this.toRecord((Object[])doubleArray);
    }

    public String toRecord(Character ... characterArray) {
        return this.toRecord((Object[])characterArray);
    }

    public String toString(String ... stringArray) {
        return this.toRecord((Object[])stringArray);
    }

    public String toString(Collection<Object> collection) {
        return this.toRecord(collection.toArray(new Object[collection.size()]));
    }

    public String[] toFields(String string) {
        return this.toStrings(string);
    }

    static CsvBuilder build() {
        return new CsvBuilder();
    }

    public static List<String> asFields(String string, char c, CsvEscapeMode csvEscapeMode, boolean bl) {
        if (bl && string != null && string.length() != 0) {
            string = string.trim();
        }
        switch (csvEscapeMode) {
            case ESCAPED: {
                List<String> list = CsvBuilder.fromSeparatedValues(string, c);
                if (!bl) {
                    return list;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string2 : list) {
                    if (string2 != null) {
                        string2 = string2.trim();
                    }
                    arrayList.add(string2);
                }
                return arrayList;
            }
            case NONE: {
                List<String> list = CsvBuilder.fromSplitValues(string, c);
                if (!bl) {
                    return list;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string3 : list) {
                    if (string3 != null) {
                        string3 = string3.trim();
                    }
                    arrayList.add(string3);
                }
                return arrayList;
            }
        }
        throw new IllegalArgumentException("You must pass a valid text overwrite mode, though you actually passed <" + csvEscapeMode + ">!");
    }

    public static String asRecord(Collection<Object> collection, char c, CsvEscapeMode csvEscapeMode) {
        switch (csvEscapeMode) {
            case ESCAPED: {
                return CsvBuilder.toSeparatedValues(collection, c);
            }
            case NONE: {
                return CsvBuilder.toSplitValues(collection, c);
            }
        }
        throw new IllegalArgumentException("You must pass a valid text overwrite mode, though you actually passed <" + csvEscapeMode + ">!");
    }

    public static String[] asStrings(String string, char c, CsvEscapeMode csvEscapeMode, boolean bl, String[] stringArray) {
        if (!CsvBuilder.isComment(string, stringArray)) {
            List<String> list = CsvBuilder.asFields(string, c, csvEscapeMode, bl);
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    private static String toEscapedRegexp(char c) {
        return ("" + c).replaceAll("\\.", "\\\\.").replaceAll("\\|", "\\\\|");
    }

    private static boolean isComment(String string, String[] stringArray) {
        if (stringArray != null && string != null) {
            for (String string2 : stringArray) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> fromSeparatedValues(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() != 0) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            String[] stringArray = string.split(CsvBuilder.toEscapedRegexp(c));
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("\"\"")) {
                    arrayList3.add("");
                    continue;
                }
                arrayList3.add(stringArray[i].replaceAll("\"\"", "\""));
            }
            while (string.endsWith("" + c)) {
                arrayList3.add("");
                string = string.substring(0, string.length() - 1);
            }
            String string2 = null;
            for (String string3 : arrayList3) {
                if (!arrayList2.isEmpty()) {
                    string2 = (String)arrayList2.get(arrayList2.size() - 1);
                    if (string2.startsWith("\"") && !string2.endsWith("\"")) {
                        arrayList2.remove(arrayList2.size() - 1);
                        arrayList2.add(string2 + c + string3);
                        continue;
                    }
                    arrayList2.add(string3);
                    continue;
                }
                arrayList2.add(string3);
            }
            for (String string3 : arrayList2) {
                void var8_13;
                if (string3.length() > 1 && string3.startsWith("\"") && string3.endsWith("\"")) {
                    String string4 = string3.substring(1, string3.length() - 1);
                }
                var8_13.replaceAll("\"\"", "\"");
                arrayList.add((String)(var8_13.length() == 0 ? null : var8_13));
            }
        }
        return arrayList;
    }

    private static String toSeparatedValues(Object[] objectArray, char c) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, objectArray);
        return CsvBuilder.toSeparatedValues(arrayList, c);
    }

    private static String toSplitValue(Object object, char c) {
        char c2 = c != Delimiter.ARRAY.getChar() ? Delimiter.ARRAY.getChar() : Delimiter.LIST.getChar();
        if (object instanceof String[]) {
            object = CsvBuilder.toSplitValues((String[])object, c2);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] != null ? objectArray[i].toString() : null;
            }
            object = CsvBuilder.toSplitValues(objectArray2, c2);
        }
        return object.toString();
    }

    private static List<String> fromSplitValues(String string, char c) {
        return Arrays.asList(string.split(CsvBuilder.toEscapedRegexp(c)));
    }

    private static String toSplitValues(Object[] objectArray, char c) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, objectArray);
        return CsvBuilder.toSplitValues(arrayList, c);
    }

    private static String toSplitValues(Collection<?> collection, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        Object var4_4 = null;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            var4_4 = iterator.next();
            if (var4_4 != null) {
                string = CsvBuilder.toSplitValue(var4_4, c);
                stringBuffer.append(string);
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String toSeparatedValues(Collection<?> collection, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        Object var4_4 = null;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            var4_4 = iterator.next();
            if (var4_4 != null) {
                string = CsvBuilder.toSeparatedValue(var4_4, c);
                stringBuffer.append(string);
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String toSeparatedValue(Object object, char c) {
        char c2 = c != Delimiter.ARRAY.getChar() ? Delimiter.ARRAY.getChar() : Delimiter.LIST.getChar();
        if (object instanceof String[]) {
            object = CsvBuilder.toSeparatedValues((String[])object, c2);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] != null ? objectArray[i].toString() : null;
            }
            object = CsvBuilder.toSeparatedValues(objectArray2, c2);
        }
        Object object2 = object.toString();
        if (((String)object2).indexOf(c) != -1 || ((String)object2).indexOf("\"") != -1) {
            object2 = ((String)object2).replaceAll("\"", "\"\"");
            object2 = "\"" + (String)object2 + "\"";
        }
        return object2;
    }

    private static Collection<Object> toCollection(Object[] objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof Collection) {
            return (Collection)objectArray[0];
        }
        return Arrays.asList(objectArray);
    }
}

