/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.ext.factory.AbstractCanonicalMapFactory;
import org.refcodes.struct.ext.factory.CanonicalMapFactory;

public class JsonCanonicalMapFactory
extends AbstractCanonicalMapFactory
implements CanonicalMapFactory {
    private static final String JSON_TEXT_VALUE = "#text";

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation) throws UnmarshalException {
        return this.fromMarshaled(aExternalRepresentation, null);
    }

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation, Map<String, String> aProperties) throws UnmarshalException {
        char theDelimiter = this.toDelimiter(aProperties, PathMap.DELIMITER);
        ObjectMapper theMapper = new ObjectMapper();
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Map theProperties = (Map)theMapper.readValue(aExternalRepresentation, (TypeReference)new TypeReference<Map<Object, Object>>(){});
            CanonicalMapBuilderImpl theResult = new CanonicalMapBuilderImpl((Object)theProperties, theDelimiter);
            this.postProcess((CanonicalMap.CanonicalMapBuilder)theResult);
            return theResult;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new UnmarshalException("A problem occurred unmarshaling the external representation \"" + aExternalRepresentation + "\" to type  <" + CanonicalMap.CanonicalMapBuilder.class.getName() + "> at column <" + e.getLocation().getColumnNr() + ">: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new UnmarshalException("A problem occurred unmarshaling the external representation \"" + aExternalRepresentation + "\" to type  <" + CanonicalMap.CanonicalMapBuilder.class.getName() + ">: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure) throws MarshalException {
        ObjectMapper theMapper = new ObjectMapper();
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object theDataStructure = aDataStructure.toDataStructure();
        try {
            String theJson = theMapper.writerWithDefaultPrettyPrinter().writeValueAsString(theDataStructure);
            return theJson + System.lineSeparator();
        }
        catch (IOException e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + CanonicalMap.class.getName() + ">.", (Throwable)e);
        }
    }

    public InputStream fromUnmarshaled(CanonicalMap aDataStructure) throws MarshalException {
        ObjectMapper theMapper = new ObjectMapper();
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object theDataStructure = aDataStructure.toDataStructure();
        try {
            PipedOutputStream theOut = new PipedOutputStream();
            PipedInputStream theIn = new PipedInputStream(theOut);
            theMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)theOut, theDataStructure);
            return theIn;
        }
        catch (Exception e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + CanonicalMap.class.getName() + ">.", (Throwable)e);
        }
    }

    @Override
    protected void postProcess(CanonicalMap.CanonicalMapBuilder aProperties) {
        String theSuffix = aProperties.getDelimiter() + JSON_TEXT_VALUE;
        for (String eKey : new ArrayList(aProperties.keySet())) {
            String eValue;
            String eToPath;
            if (!eKey.endsWith(theSuffix) || aProperties.isLeaf(eToPath = eKey.substring(0, eKey.length() - theSuffix.length())) || (eValue = (String)aProperties.remove((Object)eKey)) == null) continue;
            aProperties.put((Object)eToPath, (Object)eValue);
        }
        super.postProcess(aProperties);
    }
}

