/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.mixin.Disposable;
import org.refcodes.security.Encrypter;
import org.refcodes.security.EncryptionException;

public class EncryptionOutputStream
extends OutputStream
implements Disposable {
    private OutputStream _outputStream;
    private Encrypter<byte[], byte[], EncryptionException> _encrypter;

    public EncryptionOutputStream(OutputStream aOutputStream, Encrypter<byte[], byte[], EncryptionException> aEncrypter) {
        this._outputStream = aOutputStream;
        this._encrypter = aEncrypter;
    }

    public boolean equals(Object aObj) {
        return this._outputStream.equals(aObj);
    }

    @Override
    public void flush() throws IOException {
        this._outputStream.flush();
    }

    public int hashCode() {
        return this._outputStream.hashCode();
    }

    @Override
    public void write(int value) throws IOException {
        try {
            this._outputStream.write(Byte.toUnsignedInt(this._encrypter.toEncrypted(new byte[]{(byte)value})[0]));
        }
        catch (EncryptionException e) {
            throw new IllegalStateException("Encountered a bug while encrypting!", (Throwable)((Object)e));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this._outputStream.write(this._encrypter.toEncrypted(b));
        }
        catch (EncryptionException e) {
            throw new IllegalStateException("Encountered an illegal state while encrypting!", (Throwable)((Object)e));
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off == 0 && len == b.length) {
            this.write(b);
        } else {
            try {
                byte[] theBuffer = new byte[len];
                this._encrypter.toEncrypted(b, off, len, theBuffer, 0);
                this._outputStream.write(theBuffer);
            }
            catch (EncryptionException e) {
                throw new IllegalStateException("Encountered an illegal state while encrypting!", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void close() throws IOException {
        OutputStream theOutputStream;
        Encrypter<byte[], byte[], EncryptionException> theEncrypter = this._encrypter;
        if (theEncrypter != null) {
            try {
                theEncrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._encrypter = null;
        }
        if ((theOutputStream = this._outputStream) != null) {
            try {
                theOutputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            theOutputStream.close();
            this._outputStream = null;
        }
    }

    public void dispose() {
        OutputStream theOutputStream;
        Encrypter<byte[], byte[], EncryptionException> theEncrypter = this._encrypter;
        if (theEncrypter != null) {
            try {
                theEncrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._encrypter = null;
        }
        if ((theOutputStream = this._outputStream) != null) {
            try {
                theOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._outputStream = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [outputStream=" + String.valueOf(this._outputStream) + ", encrypter=" + String.valueOf(this._encrypter) + "]";
    }
}

