/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.jasypt.util.text.BasicTextEncryptor;
import org.refcodes.data.License;
import org.refcodes.data.Prefix;
import org.refcodes.mixin.Loggable;

public final class SecurityUtility
implements Loggable {
    public static final int CIPHER_UID_TIMESTAMP_LENGTH = 14;
    public static final int CIPHER_UID_LENGTH = 24;
    public static final int CIPHER_LENGTH = 48;
    public static final int MESSAGE_LENGTH = 256;
    private static BasicTextEncryptor TEXT_ENCRYPTOR;

    private SecurityUtility() {
    }

    public static String toDecryptedText(String string) {
        if (string.toLowerCase().startsWith(Prefix.ENCRYPTED.getPrefix())) {
            String string2 = string.substring(Prefix.ENCRYPTED.getPrefix().length());
            return TEXT_ENCRYPTOR.decrypt(string2);
        }
        Object object = "";
        if (string.length() > 12) {
            object = "and starting with first three characters \"" + string.substring(0, 3) + "...\" ";
        }
        new SecurityUtility().warn("A text with length <" + string.length() + "> " + (String)object + "has been provided which is not encrypted. An encrypted text must start with \"" + Prefix.ENCRYPTED.getPrefix() + "\"!");
        return string;
    }

    public static String toDecryptedText(String string, String string2) {
        if (string.toLowerCase().startsWith(Prefix.ENCRYPTED.getPrefix())) {
            BasicTextEncryptor basicTextEncryptor = new BasicTextEncryptor();
            basicTextEncryptor.setPassword(string2);
            String string3 = string.substring(Prefix.ENCRYPTED.getPrefix().length());
            return basicTextEncryptor.decrypt(string3);
        }
        Object object = "";
        if (string.length() > 12) {
            object = "and starting with first three characters \"" + string.substring(0, 3) + "...\" ";
        }
        new SecurityUtility().warn("A text with length <" + string.length() + "> " + (String)object + "has been provided which is not encrypted. An encrypted text must start with \"" + Prefix.ENCRYPTED.getPrefix() + "\"!");
        return string;
    }

    public static String toEncryptedText(String string) {
        return Prefix.ENCRYPTED.getPrefix() + TEXT_ENCRYPTOR.encrypt(string);
    }

    public static String toEncryptedText(String string, String string2) {
        BasicTextEncryptor basicTextEncryptor = new BasicTextEncryptor();
        basicTextEncryptor.setPassword(string2);
        return Prefix.ENCRYPTED.getPrefix() + basicTextEncryptor.encrypt(string);
    }

    static {
        Object object = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                try {
                    byte[] byArray = networkInterface.getHardwareAddress();
                    if (byArray == null) continue;
                    object = "";
                    for (int i = 0; i < byArray.length; ++i) {
                        object = (String)object + (byArray[i] < 0 ? "" + (byArray[i] & 0xFF) : "" + byArray[i]);
                        if (i >= byArray.length - 1) continue;
                        object = (String)object + ".";
                    }
                    break;
                }
                catch (SocketException socketException) {
                    new SecurityUtility().warn("Unable to acquire network interfaces's (\"" + networkInterface.getDisplayName() + "\") hardware address, trying next network interface.", socketException);
                }
            }
        }
        catch (SocketException socketException) {
            new SecurityUtility().warn("Unable to acquire machine's network interfaces (using alternate cipher).", socketException);
        }
        if (object == null) {
            object = License.REFCODES_LICENSE.getText();
        }
        TEXT_ENCRYPTOR = new BasicTextEncryptor();
        TEXT_ENCRYPTOR.setPassword((String)object);
    }
}

