/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.InputStream;
import java.net.InetSocketAddress;
import org.refcodes.mixin.Dumpable;
import org.refcodes.mixin.WildcardSubstitutes;
import org.refcodes.observer.ActionEvent;
import org.refcodes.rest.RestfulServer;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpServerRequest;
import org.refcodes.web.LocalAddressAccessor;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.RealmAccessor;
import org.refcodes.web.RemoteAddressAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;

public class RestRequestEvent
extends HttpServerRequest
implements ActionEvent<HttpMethod, RestfulServer>,
WildcardSubstitutes,
RemoteAddressAccessor,
LocalAddressAccessor,
RealmAccessor,
Dumpable {
    private final InetSocketAddress _remoteAddress;
    private final InetSocketAddress _localAddress;
    private final WildcardSubstitutes _wildcardSubstitutes;
    private final String _realm;

    public RestRequestEvent(InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, Url aUrl, WildcardSubstitutes aWildcardSubstitutes, RequestHeaderFields aHeaderFields, InputStream aHttpInputStream, RestfulServer aRestfulServer) {
        super(aHttpMethod, aUrl, aHeaderFields, aHttpInputStream, (MediaTypeFactoryLookup)aRestfulServer);
        this._wildcardSubstitutes = aWildcardSubstitutes;
        this._remoteAddress = aRemoteAddress;
        this._localAddress = aLocalAddress;
        this._realm = aRestfulServer.getRealm();
    }

    public HttpMethod getAction() {
        return this.getHttpMethod();
    }

    public RestfulServer getSource() {
        return (RestfulServer)this._mediaTypeFactoryLookup;
    }

    public String[] getWildcardReplacements() {
        return this._wildcardSubstitutes.getWildcardReplacements();
    }

    public String getWildcardReplacementAt(int aIndex) {
        return this._wildcardSubstitutes.getWildcardReplacementAt(aIndex);
    }

    public String getWildcardReplacement(String aWildcardName) {
        return this._wildcardSubstitutes.getWildcardReplacement(aWildcardName);
    }

    public String[] getWildcardReplacements(String ... aWildcardNames) {
        return this._wildcardSubstitutes.getWildcardReplacements(aWildcardNames);
    }

    public String[] getWildcardReplacementsAt(int ... aIndexes) {
        return this._wildcardSubstitutes.getWildcardReplacementsAt(aIndexes);
    }

    public InetSocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    public String getRealm() {
        return this._realm;
    }

    public String[] getWildcardNames() {
        return this._wildcardSubstitutes.getWildcardNames();
    }
}

