/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.net.InetSocketAddress;
import org.refcodes.mixin.WildcardSubstitutes;
import org.refcodes.observer.ActionEvent;
import org.refcodes.rest.RestfulServer;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.BasicAuthRequest;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.LocalAddressAccessor;
import org.refcodes.web.RealmAccessor;
import org.refcodes.web.RemoteAddressAccessor;
import org.refcodes.web.Url;

public class BasicAuthEvent
extends BasicAuthRequest
implements ActionEvent<HttpMethod, RestfulServer>,
WildcardSubstitutes,
RealmAccessor,
LocalAddressAccessor,
RemoteAddressAccessor {
    private final InetSocketAddress _localAddress;
    private final InetSocketAddress _remoteAddress;
    private final RestfulServer _restfulServer;
    private final WildcardSubstitutes _wildcardSubstitutes;
    private final String _realm;

    public BasicAuthEvent(InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, Url aUrl, WildcardSubstitutes aWildcardSubstitutes, BasicAuthCredentials aCredentials, String aRealm, RestfulServer aRestfulServer) {
        super(aHttpMethod, aUrl, aCredentials);
        this._restfulServer = aRestfulServer;
        this._localAddress = aLocalAddress;
        this._remoteAddress = aRemoteAddress;
        this._wildcardSubstitutes = aWildcardSubstitutes;
        this._realm = aRealm;
    }

    public HttpMethod getAction() {
        return this.getHttpMethod();
    }

    public String[] getWildcardReplacements() {
        return this._wildcardSubstitutes.getWildcardReplacements();
    }

    public String getWildcardReplacementAt(int aIndex) {
        return this._wildcardSubstitutes.getWildcardReplacementAt(aIndex);
    }

    public String getWildcardReplacement(String aWildcardName) {
        return this._wildcardSubstitutes.getWildcardReplacement(aWildcardName);
    }

    public String[] getWildcardReplacements(String ... aWildcardNames) {
        return this._wildcardSubstitutes.getWildcardReplacements(aWildcardNames);
    }

    public String[] getWildcardReplacementsAt(int ... aIndexes) {
        return this._wildcardSubstitutes.getWildcardReplacementsAt(aIndexes);
    }

    public InetSocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    public String getRealm() {
        return this._realm;
    }

    public RestfulServer getSource() {
        return this._restfulServer;
    }

    public String[] getWildcardNames() {
        return this._wildcardSubstitutes.getWildcardNames();
    }
}

