/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.InputStream;
import java.net.InetSocketAddress;
import org.refcodes.matcher.WildcardSubstitutes;
import org.refcodes.mixin.Dumpable;
import org.refcodes.observer.GenericActionEvent;
import org.refcodes.rest.RestServer;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpServerRequest;
import org.refcodes.web.LocalAddressAccessor;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.RealmAccessor;
import org.refcodes.web.RemoteAddressAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;

public class RestRequestEvent
extends HttpServerRequest
implements GenericActionEvent<HttpMethod, RestServer>,
WildcardSubstitutes,
RemoteAddressAccessor,
LocalAddressAccessor,
RealmAccessor,
Dumpable {
    private InetSocketAddress _remoteAddress;
    private InetSocketAddress _localAddress;
    private WildcardSubstitutes _wildcardSubstitutes;
    private String _realm;

    public RestRequestEvent(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpMethod httpMethod, Url url, WildcardSubstitutes wildcardSubstitutes, RequestHeaderFields requestHeaderFields, InputStream inputStream, RestServer restServer) {
        super(httpMethod, url, requestHeaderFields, inputStream, (MediaTypeFactoryLookup)restServer);
        this._wildcardSubstitutes = wildcardSubstitutes;
        this._remoteAddress = inetSocketAddress2;
        this._localAddress = inetSocketAddress;
        this._realm = restServer.getRealm();
    }

    public HttpMethod getAction() {
        return this.getHttpMethod();
    }

    public RestServer getSource() {
        return (RestServer)this._mediaTypeFactoryLookup;
    }

    public String[] getWildcardReplacements() {
        return this._wildcardSubstitutes.getWildcardReplacements();
    }

    public String getWildcardReplacementAt(int n) {
        return this._wildcardSubstitutes.getWildcardReplacementAt(n);
    }

    public String getWildcardReplacement(String string) {
        return this._wildcardSubstitutes.getWildcardReplacement(string);
    }

    public String[] getWildcardReplacements(String ... stringArray) {
        return this._wildcardSubstitutes.getWildcardReplacements(stringArray);
    }

    public String[] getWildcardReplacementsAt(int ... nArray) {
        return this._wildcardSubstitutes.getWildcardReplacementsAt(nArray);
    }

    public InetSocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    public String getRealm() {
        return this._realm;
    }

    public String[] getWildcardNames() {
        return this._wildcardSubstitutes.getWildcardNames();
    }
}

