/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import org.refcodes.component.Configurable;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleComponent;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.data.Scheme;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.InstanceIdAccessor;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.rest.HttpRegistryContext;
import org.refcodes.rest.HttpRegistryUrlAccessor;
import org.refcodes.rest.HttpServerDescriptor;
import org.refcodes.rest.HttpServerDescriptorAccessor;
import org.refcodes.rest.HttpServerDescriptorFactory;
import org.refcodes.rest.PingPathAccessor;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;
import org.refcodes.web.HostAccessor;
import org.refcodes.web.Url;
import org.refcodes.web.VirtualHostAccessor;

public interface HttpRegistry<DESC extends HttpServerDescriptor, B extends HttpRegistry<DESC, B>>
extends Configurable<HttpRegistryContext<DESC>>,
HttpServerDescriptorAccessor.HttpServerDescriptorProperty<DESC>,
HttpServerDescriptorAccessor.HttpServerDescriptorBuilder<DESC, B>,
PingPathAccessor.PingPathProperty,
PingPathAccessor.PingPathBuilder<B>,
HostAccessor.HostProperty,
HostAccessor.HostBuilder<B>,
VirtualHostAccessor.VirtualHostProperty,
VirtualHostAccessor.VirtualHostBuilder<B>,
IpAddressAccessor.IpAddressProperty,
IpAddressAccessor.IpAddressBuilder<B>,
InstanceIdAccessor.InstanceIdProperty,
InstanceIdAccessor.InstanceIdBuilder<B>,
AliasAccessor.AliasProperty,
AliasAccessor.AliasBuilder<B>,
LifecycleComponent.LifecycleAutomaton,
HttpRegistryUrlAccessor.HttpRegistryUrlProperty,
HttpRegistryUrlAccessor.HttpRegistryUrlBuilder<B>,
TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty,
TrustStoreDescriptorAccessor.TrustStoreDescriptorBuilder<B>,
HttpServerDescriptorFactory<DESC> {
    default public B withAlias(String string) {
        this.setAlias(string);
        return (B)this;
    }

    @Override
    default public B withPingPath(String string) {
        this.setPingPath(string);
        return (B)this;
    }

    @Override
    default public B withHttpRegistryUrl(Url url) {
        this.setHttpRegistryUrl(url);
        return (B)this;
    }

    @Override
    default public B withHttpServerDescriptor(DESC DESC) {
        this.setHttpServerDescriptor((HttpServerDescriptor)DESC);
        return (B)this;
    }

    default public B withHost(String string) {
        this.setHost(string);
        return (B)this;
    }

    default public B withVirtualHost(String string) {
        this.setVirtualHost(string);
        return (B)this;
    }

    default public B withIpAddress(int[] nArray) {
        this.setIpAddress(nArray);
        return (B)this;
    }

    default public B withCidrNotation(String string) {
        this.fromCidrNotation(string);
        return (B)this;
    }

    default public B withTrustStoreDescriptor(TrustStoreDescriptor trustStoreDescriptor) {
        this.setTrustStoreDescriptor(trustStoreDescriptor);
        return (B)this;
    }

    default public B withInstanceId(String string) {
        this.setInstanceId(string);
        return (B)this;
    }

    default public void initialize() throws InitializeException {
        this.initialize(null, null, null);
    }

    default public void initialize(HttpRegistryContext<DESC> httpRegistryContext) throws InitializeException {
        this.initialize(httpRegistryContext.getHttpServerDescriptor(), httpRegistryContext.getHttpRegistryUrl(), httpRegistryContext.getTrustStoreDescriptor());
    }

    default public void initialize(DESC DESC, Url url) throws InitializeException {
        this.initialize(DESC, url, null);
    }

    public void initialize(DESC var1, Url var2, TrustStoreDescriptor var3) throws InitializeException;

    default public void initialize(String string, String string2, Scheme scheme, int n, Url url) throws InitializeException {
        this.initialize(string, string2, scheme, null, null, null, n, null, url);
    }

    default public void initialize(String string, Scheme scheme, String string2, int n, Url url) throws InitializeException {
        this.initialize(string, null, scheme, string2, null, null, n, null, url);
    }

    default public void initialize(String string, Scheme scheme, String string2, String string3, int[] nArray, int n, String string4, Url url) throws InitializeException {
        this.initialize(this.toHttpServerDescriptor(string, scheme, string2, string3, nArray, n, string4), url);
    }

    default public void initialize(String string, String string2, Scheme scheme, String string3, String string4, int[] nArray, int n, String string5, Url url) throws InitializeException {
        this.initialize(this.toHttpServerDescriptor(string, string2, scheme, string3, string4, nArray, n, string5), url);
    }

    public void start() throws StartException;

    public void pause() throws PauseException;

    public void resume() throws ResumeException;

    public void stop() throws StopException;

    public void destroy();
}

