/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.data.Delimiter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.VetoException;
import org.refcodes.matcher.PathMatcherImpl;
import org.refcodes.matcher.RegExpMatcherImpl;
import org.refcodes.matcher.WildcardMatcher;
import org.refcodes.matcher.WildcardSubstitutes;
import org.refcodes.observer.AbstractObservable;
import org.refcodes.rest.HttpExceptionHandler;
import org.refcodes.rest.HttpExceptionHandling;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.rest.RestServer;
import org.refcodes.runtime.Correlation;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.BasicAuthRequiredException;
import org.refcodes.web.ContentType;
import org.refcodes.web.FormMediaTypeFactory;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpRequest;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.InternalServerErrorException;
import org.refcodes.web.JsonMediaTypeFactory;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.NotFoundException;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.ResponseHeaderFields;
import org.refcodes.web.TextMediaTypeFactory;
import org.refcodes.web.UnsupportedMediaTypeException;
import org.refcodes.web.Url;
import org.refcodes.web.XmlMediaTypeFactory;

public abstract class AbstractRestServer
extends AbstractObservable<RestEndpoint, HttpRequest>
implements RestServer {
    private static Logger LOGGER = Logger.getLogger(AbstractRestServer.class.getName());
    private Map<MediaType, MediaTypeFactory> _mediaTypeFacotries = new LinkedHashMap<MediaType, MediaTypeFactory>();
    private Map<WildcardMatcher, List<RestEndpoint>> _matcherEndpoints = new LinkedHashMap<WildcardMatcher, List<RestEndpoint>>();
    private String _realm = SystemUtility.getComputerName();
    private String _baseLocator = null;
    protected boolean _hasRequestCorrelation = true;
    protected boolean _hasSessionCorrelation = true;
    protected HttpExceptionHandling _httpExceptionHandling = HttpExceptionHandling.REPLACE;
    protected HttpExceptionHandler _httpExceptionHandler = null;

    public AbstractRestServer() {
        this.initMedaTypeFactories();
    }

    public AbstractRestServer(ExecutorService executorService) {
        super(executorService);
        this.initMedaTypeFactories();
    }

    protected void initMedaTypeFactories() {
        this.addMediaTypeFactory((MediaTypeFactory)new JsonMediaTypeFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new XmlMediaTypeFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new FormMediaTypeFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new TextMediaTypeFactory());
    }

    @Override
    public HttpExceptionHandler getHttpExceptionHandler() {
        return this._httpExceptionHandler;
    }

    @Override
    public void setHttpExceptionHandler(HttpExceptionHandler httpExceptionHandler) {
        this._httpExceptionHandler = httpExceptionHandler;
    }

    @Override
    public HttpExceptionHandling getHttpExceptionHandling() {
        return this._httpExceptionHandling;
    }

    @Override
    public void setHttpExceptionHandling(HttpExceptionHandling httpExceptionHandling) {
        this._httpExceptionHandling = httpExceptionHandling;
    }

    public void setObserversActive(boolean bl) {
        super.setObserversActive(bl);
    }

    public boolean isObserversActive() {
        return super.isObserversActive();
    }

    public Iterator<RestEndpoint> observers() {
        return super.observers();
    }

    public void setRequestCorrelation(boolean bl) {
        this._hasRequestCorrelation = bl;
    }

    public boolean hasRequestCorrelation() {
        return this._hasRequestCorrelation;
    }

    public void setSessionCorrelation(boolean bl) {
        this._hasSessionCorrelation = bl;
    }

    public boolean hasSessionCorrelation() {
        return this._hasSessionCorrelation;
    }

    public String getRealm() {
        return this._realm;
    }

    public void setRealm(String string) {
        this._realm = string;
    }

    public String getBaseLocator() {
        return this._baseLocator;
    }

    public void setBaseLocator(String string) {
        if (!string.startsWith("" + Delimiter.PATH.getChar())) {
            throw new IllegalArgumentException("Your provided base locator <" + string + "> is not an absolute locator, it has to start with a slash (\"" + Delimiter.PATH.getChar() + "\") character to be an absolute locator.");
        }
        this._baseLocator = string;
    }

    public synchronized boolean subscribeObserver(RestEndpoint restEndpoint) {
        if (super.subscribeObserver((Object)restEndpoint)) {
            PathMatcherImpl pathMatcherImpl;
            if (restEndpoint.getLocatorPathPattern() != null) {
                pathMatcherImpl = new PathMatcherImpl(restEndpoint.getLocatorPathPattern());
            } else if (restEndpoint.getLocatorRegExp() != null) {
                pathMatcherImpl = new RegExpMatcherImpl(restEndpoint.getLocatorRegExp());
            } else {
                return false;
            }
            List<RestEndpoint> list = this._matcherEndpoints.get(pathMatcherImpl);
            if (list == null) {
                list = new ArrayList<RestEndpoint>();
                this._matcherEndpoints.put((WildcardMatcher)pathMatcherImpl, list);
            }
            list.add(restEndpoint);
            return true;
        }
        return false;
    }

    public synchronized boolean unsubscribeObserver(RestEndpoint restEndpoint) {
        if (super.unsubscribeObserver((Object)restEndpoint)) {
            Iterator<WildcardMatcher> iterator = this._matcherEndpoints.keySet().iterator();
            while (iterator.hasNext()) {
                List<RestEndpoint> list = this._matcherEndpoints.get(iterator.next());
                Iterator<RestEndpoint> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    if (restEndpoint != iterator2.next()) continue;
                    iterator2.remove();
                }
                if (!list.isEmpty()) continue;
                iterator.remove();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean addMediaTypeFactory(MediaTypeFactory mediaTypeFactory) {
        boolean bl = false;
        for (MediaType mediaType : mediaTypeFactory.getMediaTypes()) {
            if (this._mediaTypeFacotries.containsKey(mediaType)) continue;
            this._mediaTypeFacotries.put(mediaType, mediaTypeFactory);
            bl = true;
        }
        return bl;
    }

    public MediaTypeFactory toMediaTypeFactory(MediaType mediaType) {
        return this._mediaTypeFacotries.get(mediaType);
    }

    public MediaType[] getFactoryMediaTypes() {
        return this._mediaTypeFacotries.keySet().toArray(new MediaType[this._mediaTypeFacotries.size()]);
    }

    public void dispose() {
        this._matcherEndpoints.clear();
        this._matcherEndpoints.clear();
        super.dispose();
    }

    protected void onHttpRequest(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, InputStream inputStream, HttpServerResponse httpServerResponse) throws HttpStatusException {
        String string = url.getPath();
        RestEndpoint restEndpoint = null;
        ContentType contentType = this.toNegotiatedContenType(requestHeaderFields);
        if (contentType != null) {
            httpServerResponse.getHeaderFields().putContentType((HttpMediaType)contentType);
        }
        if (this._baseLocator == null || string.toLowerCase().startsWith(this._baseLocator.toLowerCase())) {
            if (this._baseLocator != null) {
                string = string.substring(this._baseLocator.length());
            }
            Object object = null;
            for (WildcardMatcher wildcardMatcher : this._matcherEndpoints.keySet()) {
                WildcardSubstitutes wildcardSubstitutes = wildcardMatcher.toWildcardSubstitutes(string);
                if (wildcardSubstitutes == null) continue;
                List<RestEndpoint> list = this._matcherEndpoints.get(wildcardMatcher);
                for (RestEndpoint restEndpoint2 : list) {
                    if (restEndpoint2.getHttpMethod() != null && restEndpoint2.getHttpMethod() != httpMethod) continue;
                    if (restEndpoint == null) {
                        restEndpoint = restEndpoint2;
                    }
                    RestRequestEvent restRequestEvent = new RestRequestEvent(inetSocketAddress, inetSocketAddress2, httpMethod, url, wildcardSubstitutes, requestHeaderFields, inputStream, this);
                    this.doRequestCorrelation(requestHeaderFields, httpServerResponse);
                    this.doSessionCorrelation(requestHeaderFields, httpServerResponse);
                    try {
                        restEndpoint2.onRequest(restRequestEvent, httpServerResponse);
                    }
                    catch (BasicAuthRequiredException basicAuthRequiredException) {
                        httpServerResponse.getHeaderFields().putBasicAuthRequired(this.getRealm());
                        throw basicAuthRequiredException;
                    }
                    if (object == null) {
                        object = httpServerResponse.getResponse();
                        continue;
                    }
                    if (object == null) continue;
                    LOGGER.log(Level.WARNING, "An endpoint of type <" + restEndpoint2.getClass().getName() + "> (" + restEndpoint2 + ") would overwrite the response already produced by an endpoint of type <" + restEndpoint.getClass().getName() + "> (" + restEndpoint + " )");
                    throw new InternalServerErrorException("Unambiguous responsibility detected for handling resource locator <" + string + "> with HTTP-Method <" + httpMethod + ">.");
                }
            }
        }
        if (restEndpoint == null) {
            throw new NotFoundException("There is none endpoint for handling resource locator <" + string + "> with HTTP-Method <" + httpMethod + ">.");
        }
    }

    protected ContentType toNegotiatedContenType(RequestHeaderFields requestHeaderFields) {
        ContentType contentType;
        Object object;
        ContentType contentType2 = null;
        List list = requestHeaderFields.getAcceptTypes();
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                contentType = (ContentType)object.next();
                if (!this.hasMediaTypeFactory(contentType.getMediaType())) continue;
                contentType2 = contentType;
                break;
            }
        } else {
            List list2;
            if ((object = requestHeaderFields.getUnknownAcceptTypes()) != null && object.size() != 0) {
                LOGGER.log(Level.WARNING, "Unable to resolve unknown request's Header-Field <" + HeaderField.ACCEPT.getName() + ">: " + new VerboseTextBuilder().withElements((Collection)object).toString());
            }
            if ((contentType = requestHeaderFields.getContentType()) != null && this.hasMediaTypeFactory(contentType.getMediaType())) {
                contentType2 = contentType;
            }
            if ((list2 = requestHeaderFields.getUnknownContentTypes()) != null && list2.size() != 0) {
                LOGGER.log(Level.WARNING, "Unable to resolve unknown request's Header-Field <" + HeaderField.CONTENT_TYPE.getName() + ">: " + new VerboseTextBuilder().withElements((Collection)list2).toString());
            }
        }
        return contentType2;
    }

    protected byte[] toResponseBody(Object object, RequestHeaderFields requestHeaderFields, ResponseHeaderFields responseHeaderFields) throws MarshalException, UnsupportedMediaTypeException {
        if (object == null) {
            return new byte[0];
        }
        String string = this.toMarshaled(object, responseHeaderFields.getContentType(), responseHeaderFields);
        if (string != null) {
            LOGGER.log(Level.INFO, "Auto-determined Response-Header's <" + HeaderField.CONTENT_TYPE.getName() + "> Media-Type <" + responseHeaderFields.getContentType().toHttpMediaType() + "> for the response.");
            return string.getBytes();
        }
        List list = requestHeaderFields.getAcceptTypes();
        if (list != null) {
            for (ContentType contentType : list) {
                string = this.toMarshaled(object, contentType, responseHeaderFields);
                if (string == null) continue;
                LOGGER.log(Level.INFO, "Auto-determined Request-Header's <" + HeaderField.ACCEPT.getName() + "> Media-Type <" + contentType.toHttpMediaType() + "> for the response.");
                return string.getBytes();
            }
        }
        if ((string = this.toMarshaled(object, requestHeaderFields.getContentType(), responseHeaderFields)) != null) {
            LOGGER.log(Level.INFO, "Auto-determined Request-Header's <" + HeaderField.CONTENT_TYPE.getName() + "> Media-Type <" + requestHeaderFields.getContentType().toHttpMediaType() + "> for the response.");
            return string.getBytes();
        }
        if (responseHeaderFields.getContentType() != null || requestHeaderFields.getContentType() != null || requestHeaderFields.getAcceptTypes() != null && requestHeaderFields.getAcceptTypes().size() != 0) {
            throw new UnsupportedMediaTypeException("No Media-Type factory found for request ACCEPT types <" + new VerboseTextBuilder().withElements((Collection)requestHeaderFields.getAcceptTypes()) + "> or response CONTENT-TYPE <" + responseHeaderFields.getContentType() + "> or request CONTENT type <" + requestHeaderFields.getContentType() + ">.");
        }
        throw new UnsupportedMediaTypeException("No Media-Type in HTTP-Request detected.");
    }

    protected boolean fireEvent(HttpRequest httpRequest, RestEndpoint restEndpoint, ExecutionStrategy executionStrategy) throws VetoException {
        throw new UnsupportedOperationException("As the #onHttpRequest method takes care of observer invocation.");
    }

    protected void doRequestCorrelation(RequestHeaderFields requestHeaderFields, HttpServerResponse httpServerResponse) {
        if (this._hasRequestCorrelation) {
            String string = requestHeaderFields.getRequestId() != null ? requestHeaderFields.getRequestId() : Correlation.REQUEST.nextId();
            httpServerResponse.getHeaderFields().putRequestId(string);
        }
    }

    protected void doSessionCorrelation(RequestHeaderFields requestHeaderFields, HttpServerResponse httpServerResponse) {
        if (this._hasSessionCorrelation) {
            String string = requestHeaderFields.getSessionId() != null ? requestHeaderFields.getSessionId() : Correlation.SESSION.nextId();
            httpServerResponse.getHeaderFields().putSessionId(string);
        }
    }

    private String toMarshaled(Object object, MediaType mediaType, Map<String, String> map, ResponseHeaderFields responseHeaderFields) {
        MediaTypeFactory mediaTypeFactory;
        if (map != null && map.isEmpty()) {
            map = null;
        }
        if ((mediaTypeFactory = this.toMediaTypeFactory(mediaType)) != null) {
            try {
                String string = (String)mediaTypeFactory.toMarshaled(object, map);
                ContentType contentType = new ContentType(mediaType, map);
                responseHeaderFields.putContentType((HttpMediaType)contentType);
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String toMarshaled(Object object, ContentType contentType, ResponseHeaderFields responseHeaderFields) {
        return this.toMarshaled(object, contentType != null ? contentType.getMediaType() : null, (Map<String, String>)contentType, responseHeaderFields);
    }
}

