/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.refcodes.exception.IntegrityException;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.PropertiesPrecedence;

public class PropertiesPrecedenceComposite
implements PropertiesPrecedence {
    protected List<Properties> _properties;

    public PropertiesPrecedenceComposite(List<Properties> aProperties) {
        this._properties = aProperties;
    }

    public PropertiesPrecedenceComposite(Properties ... aProperties) {
        this._properties = new ArrayList<Properties>(Arrays.asList(aProperties));
    }

    public boolean containsKey(Object aKey) {
        for (Properties _propertie : this._properties) {
            if (!_propertie.containsKey(aKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsProperties(Properties aProperties) {
        return this._properties.contains(aProperties);
    }

    public String get(Object aKey) {
        for (Properties _propertie : this._properties) {
            Properties eProperties = _propertie;
            if (!eProperties.containsKey(aKey)) continue;
            return (String)eProperties.get(aKey);
        }
        return null;
    }

    @Override
    public char getDelimiter() {
        Character theDelimiter = null;
        for (Properties _propertie : this._properties) {
            char eDelimiter = _propertie.getDelimiter();
            if (theDelimiter != null && !theDelimiter.equals(Character.valueOf(eDelimiter))) {
                throw new IntegrityException("The encapsulated properties define different ambiguous delimiter <" + theDelimiter + "> and <" + eDelimiter + "> definitions.");
            }
            theDelimiter = Character.valueOf(eDelimiter);
        }
        return theDelimiter.charValue();
    }

    public boolean isEmpty() {
        for (Properties _propertie : this._properties) {
            if (_propertie.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Set<String> keySet() {
        LinkedHashSet<String> theSet = new LinkedHashSet<String>();
        for (Properties _propertie : this._properties) {
            theSet.addAll(_propertie.keySet());
        }
        return theSet;
    }

    @Override
    public Properties retrieveFrom(String aFromPath) {
        PropertiesBuilderImpl theBuilder = new PropertiesBuilderImpl();
        for (int i = this._properties.size() - 1; i >= 0; --i) {
            theBuilder.insert(this._properties.get(i).retrieveFrom(aFromPath));
        }
        return theBuilder;
    }

    @Override
    public Properties retrieveTo(String aToPath) {
        PropertiesBuilderImpl theBuilder = new PropertiesBuilderImpl();
        for (int i = this._properties.size() - 1; i >= 0; --i) {
            theBuilder.insert(this._properties.get(i).retrieveTo(aToPath));
        }
        return theBuilder;
    }

    public int size() {
        int size = 0;
        for (Properties _propertie : this._properties) {
            size += _propertie.size();
        }
        return size;
    }

    public Object toDataStructure(String aFromPath) {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        for (int i = this._properties.size() - 1; i >= 0; --i) {
            theProperties.insert(this._properties.get(i).retrieveFrom(aFromPath));
        }
        return theProperties.toDataStructure();
    }

    public Collection<String> values() {
        ArrayList<String> theCollection = new ArrayList<String>();
        for (Properties _propertie : this._properties) {
            theCollection.addAll(_propertie.values());
        }
        return theCollection;
    }
}

