/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.VetoException;
import org.refcodes.mixin.Disposable;
import org.refcodes.mixin.Loggable;
import org.refcodes.observer.Observable;

public abstract class AbstractObservable<O, EV>
implements Observable<O>,
Disposable,
Loggable {
    private List<O> _observers = new ArrayList<O>();
    private int _threadPriority = 5;
    private ExecutorService _executorService;
    private boolean _isDisposed = false;
    private boolean _isActive = true;

    public AbstractObservable() {
        this(null);
    }

    public AbstractObservable(ExecutorService executorService) {
        this._executorService = executorService == null ? ControlFlowUtility.createCachedExecutorService((boolean)true) : ControlFlowUtility.toManagedExecutorService((ExecutorService)executorService);
    }

    protected boolean fireEvent(EV EV, ExecutionStrategy executionStrategy) throws VetoException {
        if (this._isActive) {
            ControlFlowUtility.throwIllegalStateException((boolean)this._isDisposed);
            if (!this._observers.isEmpty()) {
                switch (executionStrategy) {
                    case PARALLEL: {
                        this.fireParallelEvent(EV);
                        return true;
                    }
                    case JOIN: {
                        return this.fireJoinEvent(EV);
                    }
                    case SEQUENTIAL: {
                        return this.fireSequentialEvent(EV);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasObserverSubscription(O o) {
        ControlFlowUtility.throwIllegalStateException((boolean)this._isDisposed);
        return this._observers.contains(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subscribeObserver(O o) {
        ControlFlowUtility.throwIllegalStateException((boolean)this._isDisposed);
        if (!this._observers.contains(o)) {
            AbstractObservable abstractObservable = this;
            synchronized (abstractObservable) {
                if (!this._observers.contains(o)) {
                    return this._observers.add(o);
                }
            }
        }
        return false;
    }

    @Override
    public boolean unsubscribeObserver(O o) {
        ControlFlowUtility.throwIllegalStateException((boolean)this._isDisposed);
        return this._observers.remove(o);
    }

    protected void setObserversActive(boolean bl) {
        this._isActive = bl;
    }

    protected boolean isObserversActive() {
        return this._isActive;
    }

    protected Iterator<O> observers() {
        return this._observers.iterator();
    }

    protected abstract boolean fireEvent(EV var1, O var2, ExecutionStrategy var3) throws Exception;

    protected void doHandleEventListenerException(Exception exception, O o, EV EV, ExecutionStrategy executionStrategy) {
        this.warn("Caught an unexpected exception while invoking event observer instances with strategy \"" + executionStrategy + "\" with message: " + ExceptionUtility.toMessage((Throwable)exception), exception);
    }

    protected int size() {
        return this._observers.size();
    }

    protected boolean isEmpty() {
        return this._observers.isEmpty();
    }

    protected void clear() {
        this._observers.clear();
    }

    public int getThreadPriority() {
        return this._threadPriority;
    }

    public void setThreadPriority(int n) {
        this._threadPriority = n;
    }

    public void dispose() {
        ControlFlowUtility.shutdownGracefully((ExecutorService)this._executorService);
        this._executorService = null;
        this.clear();
        this._isDisposed = true;
    }

    private boolean fireSequentialEvent(EV EV) throws VetoException {
        if (!this._observers.isEmpty()) {
            for (O o : this._observers) {
                try {
                    if (this.fireEvent(EV, o, ExecutionStrategy.SEQUENTIAL)) continue;
                    return false;
                }
                catch (Exception exception) {
                    if (exception instanceof VetoException) {
                        throw (VetoException)exception;
                    }
                    if (exception instanceof VetoException.VetoRuntimeException) {
                        throw (VetoException.VetoRuntimeException)exception;
                    }
                    this.doHandleEventListenerException(exception, o, EV, ExecutionStrategy.SEQUENTIAL);
                }
            }
        }
        return true;
    }

    private void fireParallelEvent(final EV EV) {
        if (!this._observers.isEmpty()) {
            for (final O o : this._observers) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractObservable.this.fireEvent(EV, o, ExecutionStrategy.PARALLEL);
                        }
                        catch (Exception exception) {
                            AbstractObservable.this.doHandleEventListenerException(exception, o, EV, ExecutionStrategy.PARALLEL);
                        }
                    }
                };
                this._executorService.execute(runnable);
            }
        }
    }

    private boolean fireJoinEvent(final EV EV) throws VetoException {
        boolean bl = true;
        if (!this._observers.isEmpty()) {
            ArrayList<Future<Boolean>> arrayList = new ArrayList<Future<Boolean>>();
            for (final Object object : this._observers) {
                Callable<Boolean> callable = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        try {
                            return AbstractObservable.this.fireEvent(EV, object, ExecutionStrategy.JOIN);
                        }
                        catch (Exception exception) {
                            AbstractObservable.this.doHandleEventListenerException(exception, object, EV, ExecutionStrategy.JOIN);
                            throw exception;
                        }
                    }
                };
                arrayList.add(this._executorService.submit(callable));
            }
            VetoException vetoException = null;
            for (Future future : arrayList) {
                try {
                    if (((Boolean)future.get()).booleanValue()) continue;
                    bl = false;
                }
                catch (Exception exception) {
                    if (exception instanceof VetoException) {
                        vetoException = (VetoException)exception;
                        continue;
                    }
                    this.warn("Caught an unexpected exception while invoking and joining event observer instances with message: " + ExceptionUtility.toMessage((Throwable)exception), exception);
                }
            }
            if (vetoException != null) {
                throw vetoException;
            }
        }
        return bl;
    }
}

