/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.CharSet;
import org.refcodes.data.Encoding;

public final class NumericalUtility {
    private static final int BYTE_MASK = 255;
    private static final int BYTES_PER_INT = 4;
    private static final int BYTES_PER_LONG = 8;
    private static final long BITS_PER_BYTE = 8L;
    private static final BigInteger UNSIGNED_LONG_MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);

    private NumericalUtility() {
    }

    public static String toNumberBase(long l, int n) {
        int[] nArray = NumericalUtility.toDigits(l, n);
        StringBuilder stringBuilder = new StringBuilder();
        for (int n2 : nArray) {
            stringBuilder.append(CharSet.ARABIC_BASE64.getCharSet()[n2]);
        }
        return stringBuilder.toString();
    }

    public static long fromNumberBase(int n, String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = NumericalUtility.toIndex(string.charAt(i), CharSet.ARABIC_BASE64.getCharSet());
        }
        return NumericalUtility.fromDigits(n, nArray);
    }

    public static String convertNumberBase(int n, String string, int n2) {
        return NumericalUtility.toNumberBase(NumericalUtility.fromNumberBase(n, CharSet.ARABIC_BASE64.getCharSet(), string), n2, CharSet.ARABIC_BASE64.getCharSet());
    }

    public static String toNumberBase(long l, int n, char[] cArray) {
        int[] nArray = NumericalUtility.toDigits(l, n);
        StringBuilder stringBuilder = new StringBuilder();
        for (int n2 : nArray) {
            stringBuilder.append(cArray[n2]);
        }
        return stringBuilder.toString();
    }

    public static long fromNumberBase(int n, char[] cArray, String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = NumericalUtility.toIndex(string.charAt(i), cArray);
        }
        return NumericalUtility.fromDigits(n, nArray);
    }

    public static String convertNumberBase(int n, char[] cArray, String string, int n2, char[] cArray2) {
        return NumericalUtility.toNumberBase(NumericalUtility.fromNumberBase(n, cArray, string), n2, cArray2);
    }

    public static int[] toDigits(long l, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (l > 0L) {
            arrayList.add(0, (int)(l % (long)n));
            l /= (long)n;
        }
        return NumericalUtility.toPrimitiveArray(arrayList);
    }

    public static long fromDigits(int n, int[] nArray) {
        long l = 0L;
        for (int n2 : nArray) {
            l = (long)n * l + (long)n2;
        }
        return l;
    }

    public static int[] convertDigits(int n, int[] nArray, int n2) {
        return NumericalUtility.toDigits(NumericalUtility.fromDigits(n, nArray), n2);
    }

    private static int[] toPrimitiveArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = list.get(i);
        }
        return nArray;
    }

    private static int toIndex(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        throw new IllegalArgumentException("The character <" + c + "> is not contained withon the char set <" + Arrays.toString(cArray) + ">!");
    }

    public static boolean isBitSetAt(long l, int n) {
        return (l >> n & 1L) == 1L;
    }

    public static byte setBitAt(byte by, int n, boolean bl) {
        return (byte)(bl ? by | 1 << n : by & ~(1 << n));
    }

    public static byte[] toBytes(String string) throws IllegalArgumentException, NumberFormatException {
        return NumericalUtility.toBytes(string, false);
    }

    public static byte[] toBytes(String string, boolean bl) throws IllegalArgumentException, NumberFormatException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'x' || c == 'X' || Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c == '-') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ',' || c == ' ') {
                stringBuffer.append(',');
                continue;
            }
            if (c == '{' || c == '}' || c == '[' || c == ']' || c == '(' || c == ')') continue;
            throw new IllegalArgumentException("Invalid character '" + c + "' at index <" + i + " of String \"" + string + "\"!");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            try {
                if (bl || string2.startsWith("0x") || string2.startsWith("0X")) {
                    if (string2.startsWith("0x") || string2.startsWith("0X")) {
                        string2 = string2.substring(2);
                    }
                    n = Integer.valueOf(string2, 16);
                } else {
                    n = Integer.valueOf(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Value \"" + string2 + "\" of string \"" + string + "\" cannot be parsed: " + numberFormatException.getMessage());
            }
            if (n <= 255 && n >= -128) {
                arrayList.add((byte)n);
                continue;
            }
            throw new NumberFormatException("Value <" + n + "> (\"" + string2 + "\") of string \"" + string + "\" out of range!");
        }
        byte[] byArray = new byte[arrayList.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (Byte)arrayList.get(i);
        }
        return byArray;
    }

    public static byte[] toBytes(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[7 - i] = (byte)(l >>> (int)((long)i * 8L));
        }
        return byArray;
    }

    public static byte[] toBytes(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[3 - i] = (byte)(n >>> (int)((long)i * 8L));
        }
        return byArray;
    }

    public static byte[] toBytes(boolean[] blArray) {
        byte[] byArray = new byte[blArray.length / 8 + (blArray.length % 8 == 0 ? 0 : 1)];
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            for (int j = 0; j < 8 && (n = i * 8 + j) < blArray.length; ++j) {
                if (!blArray[n]) continue;
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] | 128 >> j);
            }
        }
        return byArray;
    }

    public static boolean[] toBooleans(byte[] byArray) {
        return NumericalUtility.toBooleans(byArray, 0, byArray.length * 8);
    }

    public static boolean[] toBooleans(byte[] byArray, int n) {
        return NumericalUtility.toBooleans(byArray, 0, n);
    }

    public static boolean[] toBooleans(byte[] byArray, int n, int n2) {
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            for (int j = 0; j < 8 && (n3 = i * 8 + j) < blArray.length && i + n < byArray.length; ++j) {
                blArray[n3] = (byArray[i + n] & (byte)(128.0 / Math.pow(2.0, j))) != 0;
            }
        }
        return blArray;
    }

    public static long toLong(byte[] byArray) {
        return NumericalUtility.toLong(byArray, 0);
    }

    public static long toLong(byte[] byArray, int n) throws IllegalArgumentException {
        long l = 0L;
        for (int i = 0; i < 8 && i + n < byArray.length; ++i) {
            l <<= 8;
            if (i >= byArray.length) continue;
            l |= (long)byArray[i + n] & 0xFFL;
        }
        return l;
    }

    public static int toInt(byte[] byArray) {
        return NumericalUtility.toInt(byArray, 0);
    }

    public static int toInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4 && i + n < byArray.length; ++i) {
            n2 <<= 8;
            if (i >= byArray.length) continue;
            n2 |= byArray[i + n] & 0xFF;
        }
        return n2;
    }

    public static short[] toShorts(byte[] byArray) {
        if (byArray != null) {
            short[] sArray = new short[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                sArray[i] = byArray[i];
            }
            return sArray;
        }
        return null;
    }

    public static byte[] toBytes(Double d) {
        if (d != null) {
            byte[] byArray = new byte[8];
            long l = Double.doubleToLongBits(d);
            for (int i = 0; i < 8; ++i) {
                byArray[i] = (byte)(l >> (7 - i) * 8 & 0xFFL);
            }
            return byArray;
        }
        return null;
    }

    public static long toLong(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes(Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l = (l << 8) + (long)(byArray[i] & 0xFF);
        }
        return l;
    }

    public static double toDouble(String string) {
        long l = NumericalUtility.toLong(string);
        double d = l >= 0L ? (double)l / 9.223372036854776E18 : 1.0 - (double)l / -9.223372036854776E18;
        return d;
    }

    public static double[] toDoubles(String string, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The provided count <" + n + "> must be greatet than one!");
        }
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        int n2 = string.length() / n;
        if (n2 == 0) {
            n2 = 1;
        }
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "";
            int n3 = n2 * i;
            for (int j = 0; j < string.length(); ++j) {
                if (n3 >= string.length()) {
                    n3 = 0;
                }
                stringArray[i] = stringArray[i] + string.charAt(n3);
                ++n3;
            }
            dArray[i] = NumericalUtility.toDouble(stringArray[i]);
        }
        return dArray;
    }

    public static int toHashCode(Object ... objectArray) {
        int n = 1;
        for (Object object : objectArray) {
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public static long toUnsignedLong(int n) {
        if (n >= 0) {
            return n;
        }
        long l = n;
        return l & 0xFFFFFFFFL;
    }

    public static byte[] toLittleEndianBytes(long l, int n) {
        byte[] byArray = NumericalUtility.toBigEndianBytes(l, n);
        for (int i = 0; i < byArray.length / 2; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[byArray.length - i - 1];
            byArray[byArray.length - i - 1] = by;
        }
        return byArray;
    }

    public static byte[] toLittleEndianBytes(long l) {
        return NumericalUtility.toLittleEndianBytes(l, 8);
    }

    public static byte[] toLittleEndianBytes(int n) {
        return NumericalUtility.toLittleEndianBytes(n, 4);
    }

    public static byte[] toLittleEndianBytes(short s) {
        return NumericalUtility.toLittleEndianBytes(s, 2);
    }

    public static byte[] toBigEndianBytes(long l, int n) {
        BigInteger bigInteger = BigInteger.valueOf(l);
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[byArray2.length - i - 1] = byArray.length > i ? byArray[byArray.length - i - 1] : (l < 0L ? -1 : 0);
        }
        return byArray2;
    }

    public static byte[] toBigEndianBytes(long l) {
        return NumericalUtility.toBigEndianBytes(l, 8);
    }

    public static byte[] toBigEndianBytes(int n) {
        return NumericalUtility.toBigEndianBytes(n, 4);
    }

    public static byte[] toBigEndianBytes(short s) {
        return NumericalUtility.toBigEndianBytes(s, 2);
    }

    public static byte[] toUnsignedLittleEndianBytes(long l, int n) {
        byte[] byArray = new byte[n];
        BigInteger bigInteger = BigInteger.valueOf(l).and(UNSIGNED_LONG_MASK);
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byArray2.length > i ? byArray2[byArray2.length - 1 - i] : (byte)0;
        }
        return byArray;
    }

    public static byte[] toUnsignedLittleEndianBytes(long l) {
        return NumericalUtility.toUnsignedLittleEndianBytes(l, 8);
    }

    public static byte[] toUnsignedLittleEndianBytes(int n) {
        return NumericalUtility.toUnsignedLittleEndianBytes(n, 4);
    }

    public static byte[] toUnsignedLittleEndianBytes(short s) {
        return NumericalUtility.toUnsignedLittleEndianBytes(s, 2);
    }

    public static byte[] toUnsignedBigEndianBytes(long l, int n) {
        byte[] byArray = new byte[n];
        BigInteger bigInteger = BigInteger.valueOf(l).and(UNSIGNED_LONG_MASK);
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[byArray.length - i - 1] = byArray2.length > i ? byArray2[byArray2.length - i - 1] : (byte)0;
        }
        return byArray;
    }

    public static byte[] toUnsignedBigEndianBytes(long l) {
        return NumericalUtility.toUnsignedBigEndianBytes(l, 8);
    }

    public static byte[] toUnsignedBigEndianBytes(int n) {
        return NumericalUtility.toUnsignedBigEndianBytes(n, 4);
    }

    public static byte[] toUnsignedBigEndianBytes(short s) {
        return NumericalUtility.toUnsignedBigEndianBytes(s, 2);
    }

    public static long toLongFromLittleEndianBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        BigInteger bigInteger = new BigInteger(byArray2);
        return bigInteger.longValue();
    }

    public static long toUnsignedLongFromLittleEndianBytes(byte[] byArray) {
        return NumericalUtility.toLongFromLittleEndianBytes(NumericalUtility.toUnsignedLittleEndianBytes(byArray));
    }

    public static long toLongFromBigEndianBytes(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger.longValue();
    }

    public static long toUnsignedLongFromBigEndianBytes(byte[] byArray) {
        return NumericalUtility.toLongFromBigEndianBytes(NumericalUtility.toUnsignedBigEndianBytes(byArray));
    }

    public static int toIntFromLittleEndianBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        BigInteger bigInteger = new BigInteger(byArray2);
        return bigInteger.intValue();
    }

    public static int toUnsignedIntFromLittleEndianBytes(byte[] byArray) {
        return NumericalUtility.toIntFromLittleEndianBytes(NumericalUtility.toUnsignedLittleEndianBytes(byArray));
    }

    public static int toIntFromBigEndianBytes(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger.intValue();
    }

    public static int toUnsignedIntFromBigEndianBytes(byte[] byArray) {
        return NumericalUtility.toIntFromBigEndianBytes(NumericalUtility.toUnsignedBigEndianBytes(byArray));
    }

    public static short toShortFromLittleEndianBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int n = 0; n < byArray.length; n = (int)((short)(n + 1))) {
            byArray2[n] = byArray[byArray.length - n - 1];
        }
        BigInteger bigInteger = new BigInteger(byArray2);
        return bigInteger.shortValue();
    }

    public static short toUnsignedShortFromLittleEndianBytes(byte[] byArray) {
        return NumericalUtility.toShortFromLittleEndianBytes(NumericalUtility.toUnsignedLittleEndianBytes(byArray));
    }

    public static short toShortFromBigEndianBytes(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger.shortValue();
    }

    public static short toUnsignedShortFromBigEndianBytes(byte[] byArray) {
        return NumericalUtility.toShortFromBigEndianBytes(NumericalUtility.toUnsignedBigEndianBytes(byArray));
    }

    public static byte[] toUnsignedLittleEndianBytes(byte[] byArray) {
        if (byArray[byArray.length - 1] == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[i];
        }
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    public static byte[] toUnsignedBigEndianBytes(byte[] byArray) {
        if (byArray[0] == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i + 1] = byArray[i];
        }
        byArray2[0] = 0;
        return byArray2;
    }

    public static float toFloatFromBigEndianBytes(byte[] byArray) {
        return ByteBuffer.wrap(byArray).getFloat();
    }

    public static float toFloatFromLittleEndianBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        return ByteBuffer.wrap(byArray2).getFloat();
    }

    public static byte[] toBigEndianBytes(float f) {
        byte[] byArray = new byte[4];
        ByteBuffer.wrap(byArray).putFloat(f);
        return byArray;
    }

    public static byte[] toLittleEndianBytes(float f) {
        byte[] byArray = new byte[4];
        ByteBuffer.wrap(byArray).putFloat(f);
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray.length > i ? byArray[byArray.length - 1 - i] : (byte)0;
        }
        return byArray2;
    }

    public static double toDoubleFromBigEndianBytes(byte[] byArray) {
        return ByteBuffer.wrap(byArray).getDouble();
    }

    public static double toDoubleFromLittleEndianBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        return ByteBuffer.wrap(byArray2).getDouble();
    }

    public static byte[] toBigEndianBytes(double d) {
        byte[] byArray = new byte[8];
        ByteBuffer.wrap(byArray).putDouble(d);
        return byArray;
    }

    public static byte[] toLittleEndianBytes(double d) {
        byte[] byArray = new byte[8];
        ByteBuffer.wrap(byArray).putDouble(d);
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray.length > i ? byArray[byArray.length - 1 - i] : (byte)0;
        }
        return byArray2;
    }

    public static String toHexString(byte ... byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(NumericalUtility.toHexString(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toHexString(int n, byte ... byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            stringBuffer.append(NumericalUtility.toHexString(byArray[i]));
            boolean bl2 = bl = (i + 1) % n == 0 && i != byArray.length - 1;
            if (!bl) continue;
            stringBuffer.append(System.lineSeparator());
        }
        return stringBuffer.toString();
    }

    public static String toHexString(String string, byte ... byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(NumericalUtility.toHexString(byArray[i]));
            if (string == null || i >= byArray.length - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String toHexString(String string, int n, byte ... byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            stringBuffer.append(NumericalUtility.toHexString(byArray[i]));
            boolean bl2 = bl = (i + 1) % n == 0 && i != byArray.length - 1;
            if (i < byArray.length - 1 && !bl) {
                stringBuffer.append(string);
            }
            if (!bl) continue;
            stringBuffer.append(System.lineSeparator());
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(NumericalUtility.toHexString(byArray[i]));
            if (string == null || i >= byArray.length - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            stringBuffer.append(NumericalUtility.toHexString(byArray[i]));
            boolean bl2 = bl = (i + 1) % n == 0 && i != byArray.length - 1;
            if (!bl) continue;
            stringBuffer.append(System.lineSeparator());
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            stringBuffer.append(NumericalUtility.toHexString(byArray[i]));
            boolean bl2 = bl = (i + 1) % n == 0 && i != byArray.length - 1;
            if (i < byArray.length - 1 && !bl) {
                stringBuffer.append(string);
            }
            if (!bl) continue;
            stringBuffer.append(System.lineSeparator());
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        stringBuffer.append(Character.forDigit(by >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(by & 0xF, 16));
        return stringBuffer.toString();
    }

    public static boolean toBoolean(String string) throws IllegalArgumentException {
        for (String string2 : BooleanLiterals.TRUE.getNames()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : BooleanLiterals.FALSE.getNames()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return false;
        }
        throw new IllegalArgumentException("Unable to determine neither <true> nor <false> for the provided string \"" + string + "\".");
    }

    public static String toMd5Hash(String string) throws NoSuchAlgorithmException {
        byte[] byArray = string.getBytes();
        MessageDigest messageDigest = MessageDigest.getInstance(Encoding.MD5.getCode());
        messageDigest.update(byArray, 0, byArray.length);
        String string2 = new BigInteger(1, messageDigest.digest()).toString(32);
        return string2;
    }

    public static double toScaled(double d, double d2, double d3) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The provided value <" + d + "> must be between 0 and 1!");
        }
        double d4 = d3 - d2;
        double d5 = d * d4;
        double d6 = d5 + d2;
        return d6;
    }

    static long toReversedLong(long l) {
        long l2 = 0L;
        for (int i = 63; i >= 0; --i) {
            l2 |= (l & 1L) << i;
            l >>= 1;
        }
        return l2;
    }

    static long toReversedLong(long l, int n) {
        long l2 = 0L;
        for (int i = n - 1; i >= 0; --i) {
            l2 |= (l & 1L) << i;
            l >>= 1;
        }
        return l2;
    }

    static int toReversedInt(int n) {
        int n2 = 0;
        for (int i = 31; i >= 0; --i) {
            n2 |= (n & 1) << i;
            n >>= 1;
        }
        return n2;
    }

    static int toReversedInt(int n, int n2) {
        int n3 = 0;
        for (int i = n2 - 1; i >= 0; --i) {
            n3 |= (n & 1) << i;
            n >>= 1;
        }
        return n3;
    }

    public static int sum(int ... nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    public static double toDouble(int n, double d, double d2) {
        double d3 = d2 - d;
        long l = Integer.toUnsignedLong(n);
        long l2 = 0xFFFFFFFFL;
        double d4 = (double)l / (double)l2 * d3;
        return d4 + d;
    }

    public static double toDouble(long l, double d, double d2) {
        BigDecimal bigDecimal = BigDecimal.valueOf(d2).subtract(BigDecimal.valueOf(d));
        BigDecimal bigDecimal2 = BigDecimal.valueOf(l);
        bigDecimal2 = bigDecimal2.add(BigDecimal.valueOf(Long.MAX_VALUE)).add(BigDecimal.ONE);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(Long.MIN_VALUE).abs().add(BigDecimal.valueOf(Long.MAX_VALUE));
        BigDecimal bigDecimal4 = bigDecimal2.divide(bigDecimal3, 16, RoundingMode.HALF_DOWN);
        BigDecimal bigDecimal5 = bigDecimal4.multiply(bigDecimal);
        return bigDecimal5.add(BigDecimal.valueOf(d)).doubleValue();
    }

    public static int toHashCode(String string) {
        int n = 0;
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            n = 31 * n + byArray[i];
        }
        return n;
    }

    public static int[] toHashCodes(String string, int n) {
        int n2;
        int n3;
        StringBuilder[] stringBuilderArray = new StringBuilder[n];
        for (n3 = 0; n3 < stringBuilderArray.length; ++n3) {
            stringBuilderArray[n3] = new StringBuilder();
        }
        n3 = string.length() / n + n;
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < stringBuilderArray.length; ++n2) {
                int n4 = (n2 * n3 + i) % string.length();
                stringBuilderArray[n2].append(string.charAt(n4));
            }
        }
        int[] nArray = new int[n];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = NumericalUtility.toHashCode(stringBuilderArray[n2].toString());
        }
        return nArray;
    }

    public static int[] toHashCodes(char[] cArray, int n) {
        int n2;
        int n3;
        StringBuilder[] stringBuilderArray = new StringBuilder[n];
        for (n3 = 0; n3 < stringBuilderArray.length; ++n3) {
            stringBuilderArray[n3] = new StringBuilder();
        }
        n3 = cArray.length / n + n;
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < stringBuilderArray.length; ++n2) {
                int n4 = (n2 * n3 + i) % cArray.length;
                stringBuilderArray[n2].append(cArray[n4]);
            }
        }
        int[] nArray = new int[n];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = NumericalUtility.toHashCode(stringBuilderArray[n2].toString());
        }
        return nArray;
    }
}

