/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcMixin;
import org.refcodes.numerical.Endianess;

public abstract class AbstractCrcMixin
implements CrcMixin {
    protected CrcAlgorithm _crcAlgorithm;
    protected ChecksumValidationMode _checksumValidationMode;
    protected ConcatenateMode _crcChecksumConcatenateMode;
    protected Endianess _endianess;

    public AbstractCrcMixin(CrcAlgorithm crcAlgorithm, ConcatenateMode concatenateMode, ChecksumValidationMode checksumValidationMode, Endianess endianess) {
        this._crcAlgorithm = crcAlgorithm;
        this._checksumValidationMode = checksumValidationMode;
        this._crcChecksumConcatenateMode = concatenateMode;
        this._endianess = endianess;
    }

    @Override
    public ConcatenateMode getCrcChecksumConcatenateMode() {
        return this._crcChecksumConcatenateMode;
    }

    @Override
    public ChecksumValidationMode getChecksumValidationMode() {
        return this._checksumValidationMode;
    }

    @Override
    public CrcAlgorithm getCrcAlgorithm() {
        return this._crcAlgorithm;
    }

    @Override
    public Endianess getEndianess() {
        return this._endianess;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._crcChecksumConcatenateMode == null ? 0 : this._crcChecksumConcatenateMode.hashCode());
        n = 31 * n + (this._crcAlgorithm == null ? 0 : this._crcAlgorithm.hashCode());
        n = 31 * n + (this._checksumValidationMode == null ? 0 : this._checksumValidationMode.hashCode());
        n = 31 * n + (this._endianess == null ? 0 : this._endianess.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractCrcMixin abstractCrcMixin = (AbstractCrcMixin)object;
        if (this._crcChecksumConcatenateMode != abstractCrcMixin._crcChecksumConcatenateMode) {
            return false;
        }
        if (this._crcAlgorithm == null ? abstractCrcMixin._crcAlgorithm != null : !this._crcAlgorithm.equals(abstractCrcMixin._crcAlgorithm)) {
            return false;
        }
        if (this._checksumValidationMode != abstractCrcMixin._checksumValidationMode) {
            return false;
        }
        return this._endianess == abstractCrcMixin._endianess;
    }
}

