/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.net;

import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Set;
import org.refcodes.net.PortAlreadyBoundException;
import org.refcodes.net.PortNotFoundRuntimeException;
import org.refcodes.net.PortRange;

public class PortManager {
    private Set<Integer> _ports = new HashSet<Integer>();

    public synchronized boolean isPortBound(int aPortNumber) {
        return this._ports.contains(aPortNumber) || !this.isPortAvaialble(aPortNumber);
    }

    public synchronized Integer bindAnyPort() throws PortNotFoundRuntimeException {
        return this.bindNextPort(PortRange.DYNAMIC_PORTS);
    }

    public synchronized Integer bindPort(int aPortNumber) throws PortAlreadyBoundException {
        if (this.isPortBound(aPortNumber)) {
            throw new PortAlreadyBoundException(aPortNumber, "The port with number <" + aPortNumber + "> is already bound, please try later or another port.");
        }
        this._ports.add(aPortNumber);
        return aPortNumber;
    }

    public synchronized boolean unbindPort(Integer aPortNumber) throws IllegalArgumentException {
        return this._ports.remove(aPortNumber);
    }

    public synchronized Integer bindNextPort(int aBeginPortIndex, int aEndPortIndex) throws PortNotFoundRuntimeException {
        for (int i = aBeginPortIndex; i < aEndPortIndex; ++i) {
            if (this.isPortBound(i)) continue;
            this._ports.add(i);
            return i;
        }
        throw new PortNotFoundRuntimeException("No port found ");
    }

    public boolean isPortAvaialble(int aPortNumber) {
        boolean bl;
        ServerSocket theSocket = new ServerSocket(aPortNumber);
        try {
            theSocket.close();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    theSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this._ports.add(aPortNumber);
                return false;
            }
        }
        theSocket.close();
        return bl;
    }

    public Integer bindNextPort(int aBeginPortIndex) throws PortNotFoundRuntimeException {
        return this.bindNextPort(aBeginPortIndex, PortRange.DYNAMIC_PORTS.getMaxValue());
    }

    public Integer bindNextPort(PortRange aPortRange) {
        return this.bindNextPort(aPortRange.getMinValue(), aPortRange.getMaxValue());
    }
}

