/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import org.refcodes.io.AbstractShortsTransmitter;
import org.refcodes.io.ConnectionShortsTransmitter;
import org.refcodes.io.LoopbackShortsReceiver;

public class LoopbackShortsTransmitter
extends AbstractShortsTransmitter
implements ConnectionShortsTransmitter<LoopbackShortsReceiver> {
    private LoopbackShortsReceiver _loopbackReceiver;

    public boolean isOpenable(LoopbackShortsReceiver aLoopbackReceiver) {
        return !this.isOpened() && aLoopbackReceiver != null;
    }

    public synchronized void open(LoopbackShortsReceiver aLoopbackReceiver) throws IOException {
        if (this.isOpened()) {
            if (this._loopbackReceiver == aLoopbackReceiver && this._loopbackReceiver.isOpened()) {
                return;
            }
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        super.open();
        this._loopbackReceiver = aLoopbackReceiver;
        if (this._loopbackReceiver.isOpenable(this)) {
            this._loopbackReceiver.open(this);
        }
    }

    @Override
    public synchronized void transmitShort(short aShort) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aShort + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagram(aShort);
    }

    @Override
    public void transmitShorts(short[] aShorts, int aOffset, int aLength) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aShorts + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagrams(aShorts, aOffset, aLength);
    }

    @Override
    public void transmitAllShorts(short[] aShorts) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aShorts + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagrams(aShorts);
    }

    @Override
    public void flush() throws IOException {
    }

    public void close() throws IOException {
        super.close();
        if (this._loopbackReceiver != null && !this._loopbackReceiver.isClosed()) {
            this._loopbackReceiver.close();
            this._loopbackReceiver = null;
        }
    }
}

