/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.IoSleepLoopTime;
import org.refcodes.data.IoTimeout;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.io.ByteReceiver;
import org.refcodes.io.BytesDestination;
import org.refcodes.io.Skippable;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.io.TimeoutInputStreamAccessor;

public interface BytesReceiver
extends BytesDestination,
ByteReceiver,
TimeoutInputStreamAccessor,
Skippable {
    @Override
    default public long skip(long aLength) throws IOException {
        int count = 0;
        int i = 0;
        while ((long)i < aLength && (long)this.available() >= aLength - (long)i) {
            this.receiveByte();
            ++count;
            ++i;
        }
        return count;
    }

    default public InputStream getInputStream() {
        return new ReceiverInputStream(this);
    }

    @Override
    default public TimeoutInputStream getInputStream(long aTimeoutInMs) {
        return new TimeoutInputStream(new ReceiverInputStream(this), aTimeoutInMs, this);
    }

    @Override
    default public byte[] receiveAllBytes() throws IOException {
        ArrayList<Byte> theData = new ArrayList<Byte>();
        while (this.hasAvailable()) {
            theData.add(this.receiveByte());
        }
        byte[] theBytes = new byte[theData.size()];
        for (int i = 0; i < theBytes.length; ++i) {
            theBytes[i] = (Byte)theData.get(i);
        }
        return theBytes;
    }

    @Override
    default public byte[] receiveBytes(int aMaxLength) throws IOException {
        int i;
        byte[] theBlock = new byte[aMaxLength];
        for (i = 0; this.hasAvailable() && i < aMaxLength; ++i) {
            theBlock[i] = this.receiveByte();
        }
        if (i == 0) {
            while (!this.hasAvailable()) {
                try {
                    Thread.sleep(SleepLoopTime.NORM.getTimeInMs());
                }
                catch (InterruptedException interruptedException) {}
            }
            while (this.hasAvailable() && i < aMaxLength) {
                theBlock[i] = this.receiveByte();
                ++i;
            }
        }
        if (i == aMaxLength) {
            return theBlock;
        }
        return Arrays.copyOfRange(theBlock, 0, i);
    }

    default public byte receiveByteWithin(long aTimeoutInMs) throws IOException {
        this.waitForBytesAvailableWithin(aTimeoutInMs, 1);
        return this.receiveByte();
    }

    default public byte[] receiveBytesWithin(long aTimeoutInMs, int aLength) throws IOException {
        this.waitForBytesAvailableWithin(aTimeoutInMs, aLength);
        return this.receiveBytes(aLength);
    }

    default public void receiveBytesWithin(long aTimeoutInMs, byte[] aBuffer, int aOffset, int aLength) throws IOException {
        this.waitForBytesAvailableWithin(aTimeoutInMs, aLength);
        this.receiveBytes(aBuffer, aOffset, aLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBytesAvailableWithin(long aTimeoutInMs, int aNumberOfBytes) throws IOException {
        if (this.isClosed()) {
            throw new IOException("The receiver connection is already closed!");
        }
        long thePollTimeInMs = IoTimeout.toTimeoutSleepLoopTimeInMs((long)aTimeoutInMs);
        if (aTimeoutInMs != -1L) {
            long theStartTimeMs = System.currentTimeMillis();
            while (this.isOpened() && this.available() < aNumberOfBytes && System.currentTimeMillis() - theStartTimeMs < aTimeoutInMs) {
                BytesReceiver bytesReceiver = this;
                synchronized (bytesReceiver) {
                    try {
                        this.wait(thePollTimeInMs);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted while trying to read <" + aNumberOfBytes + "> number of bytes after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutInMs + "> milliseconds) as of: " + e.getMessage(), e);
                    }
                }
            }
            if (this.isClosed()) {
                throw new IOException("Connection was closed after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutInMs + "> milliseconds) while trying to read <" + aNumberOfBytes + "> number of bytes.");
            }
        } else {
            while (this.isOpened() && this.available() < aNumberOfBytes) {
                BytesReceiver bytesReceiver = this;
                synchronized (bytesReceiver) {
                    try {
                        this.wait(thePollTimeInMs);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted while trying to read <" + aNumberOfBytes + "> number of bytes (in blocking mode) as of: " + e.getMessage(), e);
                    }
                }
            }
            if (this.isClosed()) {
                throw new IOException("Connection was closed while trying to read <" + aNumberOfBytes + "> number of bytes (ib blocking mode).");
            }
        }
        if (this.available() < aNumberOfBytes) {
            throw new IOException("Operation timed out after <" + aTimeoutInMs + "> milliseconds while trying to read <" + aNumberOfBytes + "> number of bytes.");
        }
    }

    public static class ReceiverInputStream
    extends InputStream {
        private BytesReceiver _receiver;
        private boolean _isClosed = false;

        public ReceiverInputStream(BytesReceiver aBytesReceiver) {
            this._receiver = aBytesReceiver;
        }

        @Override
        public int available() throws IOException {
            if (this._isClosed) {
                throw new IOException("The stream has already been closed!");
            }
            return this._receiver.available();
        }

        @Override
        public int read() throws IOException {
            if (this._receiver.isClosed() || this._isClosed) {
                return -1;
            }
            return this._receiver.receiveByte();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this._isClosed) {
                throw new IOException("The stream has already been closed!");
            }
            Integer theRetries = IoRetryCount.NORM.getValue();
            for (int i = 0; i < theRetries && this.available() < len; ++i) {
                ReceiverInputStream receiverInputStream = this;
                synchronized (receiverInputStream) {
                    try {
                        this.wait(IoSleepLoopTime.NORM.getTimeInMs());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            int theAvailable = this.available();
            len = theAvailable <= len ? theAvailable : len;
            this._receiver.receiveBytes(b, off, len);
            return len;
        }

        @Override
        public void close() throws IOException {
            this._isClosed = true;
            super.close();
        }
    }
}

