/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.io.DatagramsReceiver;
import org.refcodes.mixin.Loggable;

public abstract class AbstractDatagramsReceiver<DATA extends Serializable>
extends AbstractConnectableAutomaton
implements DatagramsReceiver<DATA>,
Loggable {
    public static final int DATAGRAM_QUEUE_SIZE = 1024;
    private LinkedBlockingQueue<DATA> _datagramQueue;

    public AbstractDatagramsReceiver() {
        this._datagramQueue = new LinkedBlockingQueue(1024);
    }

    public AbstractDatagramsReceiver(int aCapacity) {
        this._datagramQueue = new LinkedBlockingQueue(aCapacity);
    }

    @Override
    public DATA receive() throws IOException {
        if (this._datagramQueue.isEmpty() && this.isClosed()) {
            throw new EOFException("Connection is closed and no (more) data is available (connection status is <" + this.getConnectionStatus() + ">).");
        }
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN (connection status is " + this.getConnectionStatus() + ").");
        }
        try {
            return (DATA)((Serializable)this._datagramQueue.take());
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public DATA[] receiveAll() throws IOException, EOFException {
        if (this._datagramQueue.isEmpty() && this.isClosed()) {
            throw new EOFException("Connection is closed and no (more) data is available (connection status is <" + this.getConnectionStatus() + ">).");
        }
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN (connection status is " + this.getConnectionStatus() + ").");
        }
        ArrayList theBytes = new ArrayList();
        this._datagramQueue.drainTo(theBytes);
        return theBytes.toArray((Serializable[])new Object[theBytes.size()]);
    }

    @Override
    public int available() throws IOException {
        return this._datagramQueue.size();
    }

    public void close() throws IOException {
        if (this.isOpened()) {
            super.close();
        }
    }

    protected void pushDatagram(DATA aDatagram) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to push datagram <" + aDatagram.getClass().getName() + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        RetryCounter theRetryCounter = new RetryCounter(IoRetryCount.MAX.getValue().intValue());
        try {
            while (!this._datagramQueue.offer(aDatagram, SleepLoopTime.MAX.getTimeInMs(), TimeUnit.MILLISECONDS) && theRetryCounter.nextRetry()) {
                this.warn("Trying to offer (add) a datagram to the datagram queue, though the queue is full, this is retry # <" + theRetryCounter.getRetryCount() + ">, aborting after <" + theRetryCounter.getRetryNumber() + "> retries. Retrying now after a delay of <" + SleepLoopTime.MAX.getTimeInMs() / 1000 + "> seconds...");
                if (theRetryCounter.hasNextRetry()) continue;
                throw new IOException("Unable to process the datagram after <" + theRetryCounter.getRetryNumber() + "> retries, aborting retries, dismissing datagram \"" + aDatagram.toString() + "\"!");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void pushDatagrams(DATA[] aDatagrams) throws IOException {
        for (DATA eData : aDatagrams) {
            this.pushDatagram(eData);
        }
    }

    protected void pushDatagrams(DATA[] aDatagrams, int aOffset, int aLength) throws IOException {
        for (int i = aOffset; i < aOffset + aLength; ++i) {
            this.pushDatagram(aDatagrams[i]);
        }
    }
}

