/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.Color;
import org.refcodes.graphical.HeightAccessor;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.WidthAccessor;

public interface Pixmap<PX>
extends WidthAccessor,
HeightAccessor {
    public PX[][] getPixels();

    @Override
    public int getWidth();

    @Override
    public int getHeight();

    public PX getPixelAt(int var1, int var2) throws IndexOutOfBoundsException;

    default public boolean hasPixelAt(int n, int n2) throws IndexOutOfBoundsException {
        return this.getPixelAt(n, n2) != null;
    }

    public static interface PixmapProperty<PX>
    extends Pixmap<PX>,
    PixmapMutator<PX> {
        default public PX[][] letPixels(PX[][] PXArray) {
            this.setPixels(PXArray);
            return PXArray;
        }

        default public PX letRgbAt(PX PX, int n, int n2) {
            this.setPixelAt(PX, n, n2);
            return PX;
        }
    }

    public static interface PixmapBuilder<PX, B extends PixmapBuilder<PX, B>>
    extends PixmapProperty<PX> {
        default public void mergeWith(B b, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6) {
            this.mergeWith(b, n, n2, bl, bl2, n3, n4, n5, n6, null);
        }

        default public void mergeWith(B b, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, Color color) {
            block0: for (int i = 0; i < n5; ++i) {
                int n7;
                if (bl) {
                    for (n7 = i + n; n7 >= b.getWidth(); n7 -= b.getWidth()) {
                    }
                }
                if (n7 >= b.getWidth() || i + n3 >= this.getWidth()) break;
                for (int j = 0; j < n6; ++j) {
                    int n8;
                    if (bl2) {
                        for (n8 = j + n2; n8 >= b.getHeight(); n8 -= b.getHeight()) {
                        }
                    }
                    if (n8 >= b.getHeight() || j + n4 >= this.getHeight()) continue block0;
                    Object PX = b.getPixelAt(n7, n8);
                    Color color2 = null;
                    if (PX instanceof Color) {
                        color2 = (Color)PX;
                    }
                    if (PX instanceof RgbPixel) {
                        color2 = ((RgbPixel)PX).toColor();
                    }
                    if (color != null && color2 != null && color2.equals(color)) continue;
                    this.setPixelAt(b.getPixelAt(n7, n8), i + n3, j + n4);
                }
            }
        }

        default public void mergeColorArrays(Pixmap<PX> pixmap) {
            int n = this.getWidth();
            for (int i = 0; i < n && pixmap.getWidth() > i; ++i) {
                for (int j = 0; j < this.getHeight() && pixmap.getHeight() > j; ++j) {
                    this.setPixelAt(pixmap.getPixelAt(i, j), i, j);
                }
            }
        }

        public B withPixelAt(PX var1, int var2, int var3) throws IndexOutOfBoundsException;

        public B withPixels(PX[][] var1);
    }

    public static interface PixmapMutator<PX> {
        public void setPixelAt(PX var1, int var2, int var3) throws IndexOutOfBoundsException;

        public void setPixels(PX[][] var1);
    }
}

