/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

public enum ColorDepth {
    MONOCHROME_1_BIT(1, 1, 1, 1, 1, 0, true),
    GRAYSCALE_8_BIT(8, 1, 8, 8, 8, 0, true),
    MSX_8_BIT(8, 1, 3, 3, 2, 0, false),
    HIGH_COLOR_16_BIT(16, 2, 5, 6, 5, 0, false),
    TRUE_COLOR_24_BIT(24, 3, 8, 8, 8, 0, false),
    AWT_COLOR_24_BIT(24, 3, 8, 8, 8, 0, false),
    TRUE_COLOR_32_BIT(32, 4, 8, 8, 8, 8, false);

    private int _bits;
    private int _bytes;
    private int _redBits;
    private int _greenBits;
    private int _blueBits;
    private int _alphaBits;
    private int _maxValue;
    private int _maxRedValue;
    private int _maxGreenValue;
    private int _maxBlueValue;
    private int _maxAlphaValue;
    private boolean _isMonochrome;

    private ColorDepth(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this._bits = n2;
        this._bytes = n3;
        this._redBits = n4;
        this._greenBits = n5;
        this._blueBits = n6;
        this._alphaBits = n7;
        this._maxValue = (int)(Math.pow(2.0, n2) - 1.0);
        this._maxRedValue = (int)(Math.pow(2.0, n4) - 1.0);
        this._maxGreenValue = (int)(Math.pow(2.0, n5) - 1.0);
        this._maxBlueValue = (int)(Math.pow(2.0, n6) - 1.0);
        this._maxAlphaValue = (int)(Math.pow(2.0, n7) - 1.0);
        this._isMonochrome = bl;
    }

    public int getBits() {
        return this._bits;
    }

    public int getBytes() {
        return this._bytes;
    }

    public int getRedBits() {
        return this._redBits;
    }

    public int getGreenBits() {
        return this._greenBits;
    }

    public int getBlueBits() {
        return this._blueBits;
    }

    public int getAlphaBits() {
        return this._alphaBits;
    }

    public int getMaxValue() {
        return this._maxValue;
    }

    public int getMaxRedValue() {
        return this._maxRedValue;
    }

    public int getMaxGreenValue() {
        return this._maxGreenValue;
    }

    public int getMaxBlueValue() {
        return this._maxBlueValue;
    }

    public int getMaxAlphaValue() {
        return this._maxAlphaValue;
    }

    public boolean isMonochrome() {
        return this._isMonochrome;
    }

    public int toAlphaValue(int n) {
        if (this.isMonochrome()) {
            return this.getMaxAlphaValue();
        }
        int n2 = this.getGreenBits() + this.getGreenBits() + this.getBlueBits();
        return n >> n2 & this.getMaxAlphaValue();
    }

    public int toRedValue(int n) {
        if (this.isMonochrome()) {
            return n;
        }
        int n2 = this.getGreenBits() + this.getBlueBits();
        int n3 = n >> n2;
        return n3 & this.getMaxRedValue();
    }

    public int toGreenValue(int n) {
        if (this.isMonochrome()) {
            return n;
        }
        int n2 = this.getBlueBits();
        return n >> n2 & this.getMaxGreenValue();
    }

    public int toBlueValue(int n) {
        if (this.isMonochrome()) {
            return n;
        }
        return n & this.getMaxBlueValue();
    }

    public int toColor(int n, ColorDepth colorDepth) {
        if (colorDepth == this) {
            return n;
        }
        float f = colorDepth.getMaxAlphaValue() != 0 ? (float)colorDepth.toAlphaValue(n) / (float)colorDepth.getMaxAlphaValue() * (float)this.getMaxAlphaValue() : 0.0f;
        float f2 = colorDepth.getMaxRedValue() != 0 ? (float)colorDepth.toRedValue(n) / (float)colorDepth.getMaxRedValue() * (float)this.getMaxRedValue() : 0.0f;
        float f3 = colorDepth.getMaxGreenValue() != 0 ? (float)colorDepth.toGreenValue(n) / (float)colorDepth.getMaxGreenValue() * (float)this.getMaxGreenValue() : 0.0f;
        float f4 = colorDepth.getMaxBlueValue() != 0 ? (float)colorDepth.toBlueValue(n) / (float)colorDepth.getMaxBlueValue() * (float)this.getMaxBlueValue() : 0.0f;
        int n2 = (int)f;
        n2 = n2 << this.getRedBits() | (int)f2;
        n2 = n2 << this.getGreenBits() | (int)f3;
        n2 = n2 << this.getBlueBits() | (int)f4;
        return n2;
    }
}

