/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard.alt.javafx;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.refcodes.checkerboard.ChangePlayerPositionEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardEvent;
import org.refcodes.checkerboard.CheckerboardObserver;
import org.refcodes.checkerboard.CheckerboardViewer;
import org.refcodes.checkerboard.GraphicalCheckerboardViewer;
import org.refcodes.checkerboard.GridDimensionChangedEvent;
import org.refcodes.checkerboard.GridModeChangedEvent;
import org.refcodes.checkerboard.GridPositionClickedEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerAddedEvent;
import org.refcodes.checkerboard.PlayerDraggabilityChangedEvent;
import org.refcodes.checkerboard.PlayerEvent;
import org.refcodes.checkerboard.PlayerPositionChangedEvent;
import org.refcodes.checkerboard.PlayerRemovedEvent;
import org.refcodes.checkerboard.PlayerStateChangedEvent;
import org.refcodes.checkerboard.PlayerVisibilityChangedEvent;
import org.refcodes.checkerboard.ViewportDimensionChangedEvent;
import org.refcodes.checkerboard.ViewportOffsetChangedEvent;
import org.refcodes.checkerboard.alt.javafx.FxBackgroundFactory;
import org.refcodes.checkerboard.alt.javafx.FxSpriteFactory;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.VetoException;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.Offset;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.ScaleMode;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportDimensionPropertyBuilder;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ext.javafx.AbstractFxGridViewportPane;
import org.refcodes.mixin.Disposable;
import org.refcodes.observer.SubscribeEvent;
import org.refcodes.observer.UnsubscribeEvent;

public class FxCheckerboardViewer<P extends Player<P, S>, S>
extends AbstractFxGridViewportPane<FxCheckerboardViewer<P, S>>
implements GraphicalCheckerboardViewer<P, S, Node, FxSpriteFactory<S>, FxBackgroundFactory, FxCheckerboardViewer<P, S>>,
CheckerboardObserver<P, S> {
    static Logger LOGGER = Logger.getLogger(FxCheckerboardViewer.class.getName());
    private static final int DEFAULT_MOVE_PLAYER_DURATION_MILLIS = 150;
    private static final int DEFAULT_CHANGE_PLAYER_STATE_DURATION_MILLIS = 100;
    private static final int DEFAULT_CHANGE_PLAYER_VISIBILITY_DURATION_MILLIS = 250;
    private static final int DEFAULT_REMOVE_PLAYER_DURATION_MILLIS = 250;
    private static final int DEFAULT_ADD_PLAYER_DURATION_MILLIS = 750;
    double _bordersH = Double.NaN;
    double _bordersV = Double.NaN;
    private Checkerboard<P, S> _checkerboard;
    private int _addPlayerDurationMillis = 750;
    private int _changePlayerStateDurationMillis = 100;
    private int _movePlayerDurationMillis = 150;
    private int _changePlayerVisibilityDurationMillis = 250;
    private int _removePlayerDurationMillis = 250;
    private Map<P, ClickPlayerEventHandler> _playerToClickEventHandler = new HashMap<P, ClickPlayerEventHandler>();
    private Map<P, DragPlayerEventHandler> _playerToDragEventHandler = new HashMap<P, DragPlayerEventHandler>();
    protected Map<P, Node> _playerToSprite = new HashMap<P, Node>();
    double _windowDecorationH = Double.NaN;
    double _windowDecorationV = Double.NaN;
    private ViewportDimensionPropertyBuilder _minViewportDimension = new ViewportDimensionPropertyBuilder(-1, -1);
    private ScaleMode _scaleMode = ScaleMode.GRID;
    private FxSpriteFactory<S> _spriteFactory = null;
    protected Node _backgroundNode = null;
    protected Group _checkers = new Group();
    protected FxBackgroundFactory _backgroundFactory = null;

    public FxCheckerboardViewer(Checkerboard<P, S> aCheckerboard) {
        this._checkerboard = aCheckerboard;
        aCheckerboard.subscribeObserver((Object)this);
        this.onMouseClicked((x, y) -> this.onGridPositionClickedEvent(new GridPositionClickedEvent(x.intValue(), y.intValue(), aCheckerboard)));
    }

    public void destroy() {
        this._checkerboard.destroy();
    }

    public int getAddPlayerDurationMillis() {
        return this._addPlayerDurationMillis;
    }

    public void setAddPlayerDurationMillis(int aAddPlayerDurationMillis) {
        this._addPlayerDurationMillis = aAddPlayerDurationMillis;
    }

    public FxCheckerboardViewer<P, S> withAddPlayerDurationMillis(int aAddPlayerDurationMillis) {
        this.setAddPlayerDurationMillis(aAddPlayerDurationMillis);
        return this;
    }

    public FxBackgroundFactory getBackgroundFactory() {
        return this._backgroundFactory;
    }

    public int getChangePlayerStateMillis() {
        return this._changePlayerStateDurationMillis;
    }

    public void setChangePlayerStateMillis(int aChangePlayerStateMillis) {
        this._changePlayerStateDurationMillis = aChangePlayerStateMillis;
    }

    public FxCheckerboardViewer<P, S> withChangePlayerStateMillis(int aChangePlayerStateMillis) {
        this.setChangePlayerStateMillis(aChangePlayerStateMillis);
        return this;
    }

    public int getContainerHeight() {
        return this.getFieldHeight() * this.getViewportHeight() + this.getFieldGap() * (this.getViewportHeight() - 1) + (this._checkerboard.getGridMode() == GridMode.CLOSED ? this.getFieldGap() * 2 : 0);
    }

    public int getContainerWidth() {
        return this.getFieldWidth() * this.getViewportWidth() + this.getFieldGap() * (this.getViewportWidth() - 1) + (this._checkerboard.getGridMode() == GridMode.CLOSED ? this.getFieldGap() * 2 : 0);
    }

    public int getGridHeight() {
        return this._checkerboard.getGridHeight();
    }

    public GridMode getGridMode() {
        return this._checkerboard.getGridMode();
    }

    public int getGridWidth() {
        return this._checkerboard.getGridWidth();
    }

    public ViewportDimension getMinViewportDimension() {
        return this._minViewportDimension;
    }

    public int getMovePlayerDurationMillis() {
        return this._movePlayerDurationMillis;
    }

    public void setMovePlayerDurationMillis(int aMovePlayerDurationMillis) {
        this._movePlayerDurationMillis = aMovePlayerDurationMillis;
    }

    public FxCheckerboardViewer<P, S> withMovePlayerDurationMillis(int aMovePlayerDurationMillis) {
        this.setMovePlayerDurationMillis(aMovePlayerDurationMillis);
        return this;
    }

    public int getChangePlayerVisibilityDurationMillis() {
        return this._changePlayerVisibilityDurationMillis;
    }

    public void setChangePlayerVisibilityDurationMillis(int aChangePlayerVisibilityDurationMillis) {
        this._changePlayerVisibilityDurationMillis = aChangePlayerVisibilityDurationMillis;
    }

    public FxCheckerboardViewer<P, S> withChangePlayerVisibilityDurationMillis(int aChangePlayerVisibilityDurationMillis) {
        this.setChangePlayerVisibilityDurationMillis(aChangePlayerVisibilityDurationMillis);
        return this;
    }

    public int getRemovePlayerDurationMillis() {
        return this._removePlayerDurationMillis;
    }

    public void setRemovePlayerDurationMillis(int aRemovePlayerDurationMillis) {
        this._removePlayerDurationMillis = aRemovePlayerDurationMillis;
    }

    public FxCheckerboardViewer<P, S> withRemovePlayerDurationMillis(int aRemovePlayerDurationMillis) {
        this.setRemovePlayerDurationMillis(aRemovePlayerDurationMillis);
        return this;
    }

    public ScaleMode getScaleMode() {
        return this._scaleMode;
    }

    public FxSpriteFactory<S> getSpriteFactory() {
        return this._spriteFactory;
    }

    public synchronized void initialize() {
        for (Player ePlayer : this._checkerboard.getPlayers()) {
            if (this._playerToSprite.containsKey(ePlayer)) continue;
            this.fxAddPlayer(ePlayer, this.getAddPlayerDurationMillis());
        }
        if (Platform.isFxApplicationThread()) {
            this.fxInitialize();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FxCheckerboardViewer.this.fxInitialize();
                }
            });
        }
    }

    public void onChangePlayerPositionEvent(ChangePlayerPositionEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) throws VetoException {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onCheckerboardEvent(CheckerboardEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onPlayerDraggabilityChangedEvent(PlayerDraggabilityChangedEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxPlayerDraggability(aEvent.getSource());
    }

    public void onGridDimensionChangedEvent(GridDimensionChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onGridModeChangedEvent(GridModeChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.setGridMode(aEvent.getGridMode());
        this.initMinStageWidth();
        this.initMinStageHeight();
    }

    public void onPlayerAddedEvent(PlayerAddedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxAddPlayer(aEvent.getPlayer(), this._addPlayerDurationMillis);
    }

    public void onPlayerEvent(PlayerEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onPlayerRemovedEvent(PlayerRemovedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxRemovePlayer(aEvent.getPlayer(), this._removePlayerDurationMillis);
    }

    public void onPlayerPositionChangedEvent(PlayerPositionChangedEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxMovePlayer(aEvent.getSource(), aEvent.getPrecedingPosition(), this._movePlayerDurationMillis);
    }

    public void onPlayerStateChangedEvent(PlayerStateChangedEvent<P, S> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
        Node theSprite = this._spriteFactory.createInstance(aEvent.getSource().getStatus(), this);
        Node prevSprite = this._playerToSprite.get(aEvent.getSource());
        if (theSprite != prevSprite) {
            this.fxRemovePlayer(aEvent.getSource(), this._changePlayerStateDurationMillis / 2);
            this.fxAddPlayer(aEvent.getSource(), this._changePlayerStateDurationMillis / 2);
        }
    }

    public void onSubscribe(SubscribeEvent<Checkerboard<P, S>> aSubscribeEvent) {
        this._checkerboard = (Checkerboard)aSubscribeEvent.getSource();
    }

    public void onUnsubscribe(UnsubscribeEvent<Checkerboard<P, S>> aUnsubscribeEvent) {
        if (this._checkerboard == aUnsubscribeEvent.getSource()) {
            this._checkerboard = null;
        }
    }

    public void onViewportDimensionChangedEvent(ViewportDimensionChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onGridPositionClickedEvent(GridPositionClickedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onViewportOffsetChangedEvent(ViewportOffsetChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onPlayerVisibilityChangedEvent(PlayerVisibilityChangedEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxChangePlayerVisibility(aEvent.getSource(), this._changePlayerVisibilityDurationMillis);
    }

    public void setBackgroundFactory(FxBackgroundFactory aBackgroundFactory) {
        this._backgroundFactory = aBackgroundFactory;
    }

    public void setFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    public void setFieldDimension(FieldDimension aField) {
        this.setFieldDimension(aField.getFieldWidth(), aField.getFieldHeight());
    }

    public void setMinViewportDimension(Dimension aDimension) {
        this._minViewportDimension.setViewportDimension(aDimension);
    }

    public void setMinViewportDimension(int aWidth, int aHeight) {
        this._minViewportDimension.setViewportDimension(aWidth, aHeight);
    }

    public void setMinViewportDimension(ViewportDimension aDimension) {
        this._minViewportDimension.setViewportDimension(aDimension);
    }

    public void setScaleMode(ScaleMode aMode) {
        this._scaleMode = aMode;
    }

    public void setSpriteFactory(FxSpriteFactory<S> aSpriteFactory) {
        this._spriteFactory = aSpriteFactory;
    }

    public void setViewportDimension(Dimension aDimension) {
        this.setViewportDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    public void setViewportOffset(int aPosX, int aPosY) {
        if (aPosX != this.getViewportOffsetX() || aPosY != this.getViewportOffsetY()) {
            ViewportOffsetChangedEvent theEvent = new ViewportOffsetChangedEvent(aPosX, aPosY, this.getViewportOffsetX(), this.getViewportOffsetY(), (CheckerboardViewer)this);
            super.setViewportOffset(aPosX, aPosY);
            this.onViewportOffsetChangedEvent(theEvent);
        }
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public int toTotalHeight() {
        int theTotalHeight = this.getFieldHeight() * this.getViewportHeight() + this.getFieldGap() * (this.getViewportHeight() - 1);
        if (this.getGridMode() == GridMode.CLOSED) {
            theTotalHeight += this.getFieldGap() * 2;
        }
        return theTotalHeight;
    }

    public int toTotalWidth() {
        int theTotalWidth = this.getFieldWidth() * this.getViewportWidth() + this.getFieldGap() * (this.getViewportWidth() - 1);
        if (this.getGridMode() == GridMode.CLOSED) {
            theTotalWidth += this.getFieldGap() * 2;
        }
        return theTotalWidth;
    }

    public FxCheckerboardViewer<P, S> withBackgroundFactory(FxBackgroundFactory aBackgroundFactory) {
        this.setBackgroundFactory(aBackgroundFactory);
        return this;
    }

    public FxCheckerboardViewer<P, S> withDragOpacity(double aOpacity) {
        this.setDragOpacity(aOpacity);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldDimension(FieldDimension aField) {
        this.setFieldDimension(aField);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldDimension(int aFieldWidth, int aFieldHeight) {
        this.setFieldDimension(aFieldWidth, aFieldHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldDimension(int aFieldWidth, int aFieldHeight, int aGap) {
        this.setFieldDimension(aFieldWidth, aFieldHeight, aGap);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldGap(int aFieldGap) {
        this.setFieldGap(aFieldGap);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldHeight(int aHeight) {
        this.setFieldHeight(aHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldWidth(int aWidth) {
        this.setFieldWidth(aWidth);
        return this;
    }

    public FxCheckerboardViewer<P, S> withGridMode(GridMode aGridMode) {
        this.setGridMode(aGridMode);
        return this;
    }

    public FxCheckerboardViewer<P, S> withHide() {
        this.hide();
        return this;
    }

    public FxCheckerboardViewer<P, S> withInitialize() {
        this.initialize();
        return this;
    }

    public FxCheckerboardViewer<P, S> withMinViewportDimension(Dimension aDimension) {
        this.setMinViewportDimension(aDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withMinViewportDimension(int aWidth, int aHeight) {
        this.setMinViewportDimension(aWidth, aHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withMinViewportDimension(ViewportDimension aDimension) {
        this.setMinViewportDimension(aDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withMoveMode(MoveMode aMode) {
        this.setMoveMode(aMode);
        return this;
    }

    public FxCheckerboardViewer<P, S> withScaleMode(ScaleMode aMode) {
        this.setScaleMode(aMode);
        return this;
    }

    public FxCheckerboardViewer<P, S> withShow() {
        this.show();
        return this;
    }

    public FxCheckerboardViewer<P, S> withSpriteFactory(FxSpriteFactory<S> aSpriteFactory) {
        this.setSpriteFactory(aSpriteFactory);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportDimension(Dimension aDimension) {
        this.setViewportDimension(aDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportDimension(int aWidth, int aHeight) {
        this.setViewportDimension(aWidth, aHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportDimension(ViewportDimension aGridDimension) {
        this.setViewportDimension(aGridDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportHeight(int aGridHeight) {
        this.setViewportHeight(aGridHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffset(int aPosX, int aPosY) {
        this.setViewportOffset(aPosX, aPosY);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffset(Offset aOffset) {
        this.setViewportOffset(aOffset);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffset(Position aOffset) {
        this.setViewportOffset(aOffset);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffset(ViewportOffset aOffset) {
        this.setViewportOffset(aOffset);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffsetX(int aPosX) {
        this.setViewportOffsetX(aPosX);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffsetY(int aPosY) {
        this.setViewportOffsetY(aPosY);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportWidth(int aGridWidth) {
        this.setViewportWidth(aGridWidth);
        return this;
    }

    public FxCheckerboardViewer<P, S> withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return this;
    }

    public FxCheckerboardViewer<P, S> withMoveViewportDurationMillis(int aMoveViewportDurationMillis) {
        this.setMoveViewportDurationMillis(aMoveViewportDurationMillis);
        return this;
    }

    public FxCheckerboardViewer<P, S> withDragViewportDurationMillis(int aDragViewportDurationMillis) {
        this.setDragViewportDurationMillis(aDragViewportDurationMillis);
        return this;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [bordersH=" + this._bordersH + ", bordersV=" + this._bordersV + ", checkerboard=" + this._checkerboard + ", containerHeight=" + this.getContainerHeight() + ", containerWidth=" + this.getContainerWidth() + "]";
    }

    protected void hidePlayers(int aDurationMillis) {
        for (Player ePlayer : this._checkerboard.getPlayers()) {
            this.fxHidePlayer(ePlayer, aDurationMillis);
        }
    }

    protected void resetPlayers(int aDurationMillis) {
        for (Player ePlayer : this._checkerboard.getPlayers()) {
            this.fxResetPlayer(ePlayer, aDurationMillis);
        }
    }

    protected void scalePlayers(FieldDimension aFieldDimension, FieldDimension aPrecedingFieldDimension) {
        for (Player ePlayer : this._checkerboard.getPlayers()) {
            this.fxScalePlayer(ePlayer, aFieldDimension, aPrecedingFieldDimension);
        }
    }

    private void fxAddPlayer(P aPlayer, int aDurationMillis) {
        Node theSprite = this._spriteFactory.createInstance(aPlayer.getStatus(), this);
        this.fxAddPlayer(aPlayer, aDurationMillis, theSprite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxAddPlayer(P aPlayer, int aDurationMillis, Node aSprite) {
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            this._playerToSprite.put(aPlayer, aSprite);
        }
        if (aPlayer.isDraggable()) {
            DragPlayerEventHandler theDragEventHandler = new DragPlayerEventHandler(this, aPlayer, aSprite);
            this._playerToDragEventHandler.put(aPlayer, theDragEventHandler);
        }
        ClickPlayerEventHandler theClickEventHandler = new ClickPlayerEventHandler(this, aPlayer, aSprite);
        this._playerToClickEventHandler.put(aPlayer, theClickEventHandler);
        Point2D thePoint = aSprite.localToParent(0.0, 0.0);
        aSprite.setLayoutX(-thePoint.getX());
        aSprite.setLayoutY(-thePoint.getY());
        aSprite.setTranslateX((double)this.toPixelPositionX((Position)aPlayer));
        aSprite.setTranslateY((double)this.toPixelPositionY((Position)aPlayer));
        Runnable theRunner = new Runnable(){
            final /* synthetic */ Player val$aPlayer;
            final /* synthetic */ Node val$aSprite;
            final /* synthetic */ int val$aDurationMillis;
            {
                this.val$aPlayer = player;
                this.val$aSprite = node;
                this.val$aDurationMillis = n;
            }

            @Override
            public void run() {
                if (FxCheckerboardViewer.this.isViewport((Position)this.val$aPlayer)) {
                    FxCheckerboardViewer.this._checkers.getChildren().add((Object)this.val$aSprite);
                    if (this.val$aPlayer.isVisible()) {
                        if (this.val$aDurationMillis > 0) {
                            this.val$aSprite.setOpacity(0.0);
                            FadeTransition theTransition = new FadeTransition(Duration.millis((double)this.val$aDurationMillis), this.val$aSprite);
                            theTransition.setFromValue(0.0);
                            theTransition.setToValue(1.0);
                            theTransition.setCycleCount(1);
                            theTransition.setAutoReverse(false);
                            theTransition.play();
                        } else {
                            this.val$aSprite.setOpacity(1.0);
                            this.val$aSprite.setVisible(true);
                        }
                    }
                } else {
                    this.val$aSprite.setVisible(true);
                    FxCheckerboardViewer.this._checkers.getChildren().add((Object)this.val$aSprite);
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxHidePlayer(P aPlayer, final int aDurationMillis) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        if (theSprite != null) {
            if (aDurationMillis == 0) {
                theSprite.setOpacity(0.0);
            } else if (theSprite.getOpacity() != 0.0) {
                Runnable theRunner = new Runnable(){

                    @Override
                    public void run() {
                        FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationMillis), theSprite);
                        theTransition.setFromValue(theSprite.getOpacity());
                        theTransition.setToValue(0.0);
                        theTransition.setCycleCount(1);
                        theTransition.setAutoReverse(false);
                        theTransition.play();
                    }
                };
                if (Platform.isFxApplicationThread()) {
                    theRunner.run();
                } else {
                    Platform.runLater((Runnable)theRunner);
                }
            }
        }
    }

    private void fxInitialize() {
        LOGGER.log(Level.FINE, "Initializing ...");
        if (this.getViewportWidth() == -1) {
            this.setViewportWidth(this.getGridWidth());
        }
        if (this.getViewportHeight() == -1) {
            this.setViewportHeight(this.getGridHeight());
        }
        if (this.getViewportWidth() == -1 || this.getViewportHeight() == -1) {
            throw new IllegalStateException("The viewport dimension for the checkerboard must be set!");
        }
        if (this._backgroundFactory != null) {
            this._backgroundNode = (Node)this._backgroundFactory.createInstance((Object)this);
            this._checkers.getChildren().add(0, (Object)this._backgroundNode);
        }
        switch (this.getScaleMode()) {
            case NONE: {
                StackPane thePane = new StackPane();
                thePane.getChildren().add((Object)this._checkers);
                StackPane.setAlignment((Node)this._checkers, (Pos)Pos.CENTER);
                this.setRoot((Node)thePane);
                break;
            }
            case GRID: 
            case FIELDS: {
                this.setRoot((Node)this._checkers);
                this.setViewportOffset((ViewportOffset)this);
                this.setFieldDimension((FieldDimension)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxMovePlayer(P aPlayer, Position aPrecedingPosition, final int aDurationMillis) {
        Node theSprite;
        FxCheckerboardViewer fxCheckerboardViewer = this;
        synchronized (fxCheckerboardViewer) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        Runnable theRunner = new Runnable(){
            final /* synthetic */ Player val$aPlayer;
            {
                this.val$aPlayer = player;
            }

            @Override
            public void run() {
                if (FxCheckerboardViewer.this._checkers.getChildren().remove((Object)theSprite)) {
                    FxCheckerboardViewer.this._checkers.getChildren().add((Object)theSprite);
                    if (FxCheckerboardViewer.this.getMoveMode() == MoveMode.SMOOTH && aDurationMillis != 0) {
                        TranslateTransition theTransition = new TranslateTransition(Duration.millis((double)aDurationMillis), theSprite);
                        theTransition.setByX((double)FxCheckerboardViewer.this.toPixelPositionX((Position)this.val$aPlayer) - theSprite.getTranslateX());
                        theTransition.setByY((double)FxCheckerboardViewer.this.toPixelPositionY((Position)this.val$aPlayer) - theSprite.getTranslateY());
                        theTransition.setCycleCount(1);
                        theTransition.setAutoReverse(false);
                        theTransition.play();
                    } else {
                        theSprite.setTranslateX((double)FxCheckerboardViewer.this.toPixelPositionX((Position)this.val$aPlayer));
                        theSprite.setTranslateY((double)FxCheckerboardViewer.this.toPixelPositionY((Position)this.val$aPlayer));
                    }
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxPlayerDraggability(P aPlayer) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        if (theSprite != null) {
            if (aPlayer.isDraggable() && !this._playerToDragEventHandler.containsKey(aPlayer)) {
                theDragEventHandler = new DragPlayerEventHandler(this, aPlayer, theSprite);
                this._playerToDragEventHandler.put(aPlayer, theDragEventHandler);
            } else {
                theDragEventHandler = this._playerToDragEventHandler.remove(aPlayer);
                if (theDragEventHandler != null) {
                    theDragEventHandler.dispose();
                }
            }
        } else {
            throw new IllegalStateException("The player <" + aPlayer + "> is unknwon by this checkerboard.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxChangePlayerVisibility(P aPlayer, int aDurationMillis) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        if (theSprite != null) {
            FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationMillis), theSprite);
            theTransition.setFromValue(aPlayer.isVisible() ? 0.0 : 1.0);
            theTransition.setToValue(aPlayer.isVisible() ? 1.0 : 0.0);
            theTransition.setCycleCount(1);
            theTransition.setAutoReverse(false);
            theTransition.play();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxRemovePlayer(P aPlayer, int aDurationMillis) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.remove(aPlayer);
        }
        this.fxRemovePlayer(aPlayer, theSprite, aDurationMillis);
    }

    private void fxRemovePlayer(P aPlayer, final Node aSprite, int aDurationMillis) {
        ClickPlayerEventHandler theClickEventHandler;
        DragPlayerEventHandler theDragEventHandler = this._playerToDragEventHandler.remove(aPlayer);
        if (theDragEventHandler != null) {
            theDragEventHandler.dispose();
        }
        if ((theClickEventHandler = this._playerToClickEventHandler.remove(aPlayer)) != null) {
            theClickEventHandler.dispose();
        }
        if (aSprite != null) {
            FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationMillis), aSprite);
            theTransition.setFromValue(1.0);
            theTransition.setToValue(0.0);
            theTransition.setCycleCount(1);
            theTransition.setAutoReverse(false);
            theTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (Platform.isFxApplicationThread()) {
                        FxCheckerboardViewer.this._checkers.getChildren().remove((Object)aSprite);
                    } else {
                        Platform.runLater(() -> FxCheckerboardViewer.this._checkers.getChildren().remove((Object)aSprite));
                    }
                }
            });
            theTransition.play();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxResetPlayer(P aPlayer, int aDurationMillis) {
        Node thePrevSprite;
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._spriteFactory.createInstance(aPlayer.getStatus(), this);
            thePrevSprite = this._playerToSprite.put(aPlayer, theSprite);
        }
        if (aPlayer.isDraggable()) {
            DragPlayerEventHandler theDragEventHandler = new DragPlayerEventHandler(this, aPlayer, theSprite);
            this._playerToDragEventHandler.put(aPlayer, theDragEventHandler);
        }
        ClickPlayerEventHandler theClickEventHandler = new ClickPlayerEventHandler(this, aPlayer, theSprite);
        this._playerToClickEventHandler.put(aPlayer, theClickEventHandler);
        theSprite.setOpacity(0.0);
        Point2D thePoint = theSprite.localToParent(0.0, 0.0);
        theSprite.setLayoutX(-thePoint.getX());
        theSprite.setLayoutY(-thePoint.getY());
        theSprite.setTranslateX((double)this.toPixelPositionX((Position)aPlayer));
        theSprite.setTranslateY((double)this.toPixelPositionY((Position)aPlayer));
        this._checkers.getChildren().add((Object)theSprite);
        if (thePrevSprite != null) {
            this._checkers.getChildren().remove((Object)thePrevSprite);
        }
        Runnable theRunner = new Runnable(){
            final /* synthetic */ Player val$aPlayer;
            final /* synthetic */ Node val$theSprite;
            final /* synthetic */ int val$aDurationMillis;
            {
                this.val$aPlayer = player;
                this.val$theSprite = node;
                this.val$aDurationMillis = n;
            }

            @Override
            public void run() {
                if (this.val$aPlayer.isVisible() && this.val$theSprite.getOpacity() == 0.0) {
                    FadeTransition theTransition = new FadeTransition(Duration.millis((double)this.val$aDurationMillis), this.val$theSprite);
                    theTransition.setFromValue(0.0);
                    theTransition.setToValue(1.0);
                    theTransition.setCycleCount(1);
                    theTransition.setAutoReverse(false);
                    theTransition.play();
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxScalePlayer(P aPlayer, FieldDimension aFieldDimension, FieldDimension aPrecedingFieldDimension) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        theSprite.setScaleX((double)aFieldDimension.getFieldWidth() / theSprite.getBoundsInLocal().getWidth());
        theSprite.setScaleY((double)aFieldDimension.getFieldHeight() / theSprite.getBoundsInLocal().getHeight());
        double theLayoutX = ((double)aFieldDimension.getFieldWidth() - theSprite.getBoundsInLocal().getWidth()) / 2.0;
        double theLayoutY = ((double)aFieldDimension.getFieldHeight() - theSprite.getBoundsInLocal().getHeight()) / 2.0;
        theSprite.setLayoutX(theLayoutX);
        theSprite.setLayoutY(theLayoutY);
        theSprite.setTranslateX((double)this.toPixelPositionX((Position)aPlayer));
        theSprite.setTranslateY((double)this.toPixelPositionY((Position)aPlayer));
    }

    void initBordersH(double aWindowWidth) {
        if (Double.isNaN(this._bordersH)) {
            double theBoardersH = aWindowWidth - (double)((this.getViewportWidth() - 1) * this.getFieldGap());
            if (this._checkerboard.getGridMode() == GridMode.CLOSED) {
                theBoardersH -= (double)(this.getFieldGap() * 2);
            }
            theBoardersH -= (double)(this.getViewportWidth() * this.getFieldWidth());
            theBoardersH = this._checkerboard.getGridMode() == GridMode.CLOSED ? (theBoardersH += (double)this.getFieldGap()) : (theBoardersH -= (double)this.getFieldGap());
            LOGGER.log(Level.FINE, "Horizontal (left and right) [phantom] borders from width <" + aWindowWidth + "> := " + theBoardersH);
            this._bordersH = theBoardersH;
        }
    }

    void initBordersV(double aWindowHeight) {
        if (Double.isNaN(this._bordersV)) {
            double theBoardersV = aWindowHeight - (double)((this.getViewportHeight() - 1) * this.getFieldGap());
            if (this._checkerboard.getGridMode() == GridMode.CLOSED) {
                theBoardersV -= (double)(this.getFieldGap() * 2);
            }
            theBoardersV -= (double)(this.getViewportHeight() * this.getFieldHeight());
            theBoardersV = this._checkerboard.getGridMode() == GridMode.CLOSED ? (theBoardersV += (double)this.getFieldGap()) : (theBoardersV -= (double)this.getFieldGap());
            LOGGER.log(Level.FINE, "Vertical (top and bottom) [phantom] borders from height <" + aWindowHeight + "> := " + theBoardersV);
            this._bordersV = theBoardersV;
        }
    }

    void initMinStageHeight() {
        if (Double.isNaN(this._bordersV)) {
            this.initBordersV(this.getHeight());
        } else {
            int theHeight = (int)this._bordersV;
            this.setMinHeight((double)(theHeight += this.getViewportHeight() * this.getFieldHeight() + this.getViewportHeight() * this.getFieldGap()) + this._windowDecorationV);
        }
    }

    void initMinStageWidth() {
        if (Double.isNaN(this._bordersH)) {
            this.initBordersH(this.getWidth());
        } else {
            int theWidth = (int)this._bordersH;
            this.setMinWidth((double)(theWidth += this.getViewportWidth() * this.getFieldWidth() + this.getViewportWidth() * this.getFieldGap()) + this._windowDecorationH);
        }
    }

    private boolean isViewport(Position aPosition) {
        return this.isViewportPosX(aPosition.getPositionX()) && this.isViewportPosY(aPosition.getPositionY());
    }

    private boolean isViewportPosX(int aPositionX) {
        return aPositionX >= this.getViewportOffsetX() && aPositionX < this.getViewportWidth() + this.getViewportOffsetX();
    }

    private boolean isViewportPosY(int aPositionY) {
        return aPositionY >= this.getViewportOffsetY() && aPositionY < this.getViewportHeight() + this.getViewportOffsetY();
    }

    private int toPixelPositionX(Position aPosition) {
        return (this.getFieldWidth() + this.getFieldGap()) * aPosition.getPositionX() + (this.getGridMode() == GridMode.CLOSED ? this.getFieldGap() : 0);
    }

    private int toPixelPositionY(Position aPosition) {
        return (this.getFieldHeight() + this.getFieldGap()) * aPosition.getPositionY() + (this.getGridMode() == GridMode.CLOSED ? this.getFieldGap() : 0);
    }

    int toScaledFieldDimension(double aNewWindowDim, int aViewportDim, int aFieldDim, int aFieldGap, double aBordersDim) {
        if (!Double.isNaN(aBordersDim) && aNewWindowDim != 1.0) {
            double theCheckerboardDim = aNewWindowDim - aBordersDim;
            int theFieldDim = (int)Math.round(((theCheckerboardDim -= (double)aFieldGap) - (double)((aViewportDim - 1) * aFieldGap)) / (double)aViewportDim);
            if (theFieldDim != aFieldDim) {
                try {
                    return theFieldDim;
                }
                catch (VetoException.VetoRuntimeException vetoRuntimeException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    int toScaledViewportDimension(double aNewWindowDim, int aViewportDim, int aFieldDim, int aFieldGap, double aBordersDim) {
        if (!Double.isNaN(aBordersDim) && aNewWindowDim != 1.0) {
            double theCheckerboardDim = aNewWindowDim - aBordersDim;
            int theViewportDim = (int)Math.round((theCheckerboardDim -= (double)aFieldGap) / (double)(aFieldDim + aFieldGap));
            if (theViewportDim != aViewportDim) {
                try {
                    return theViewportDim;
                }
                catch (VetoException.VetoRuntimeException vetoRuntimeException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    private static class DragPlayerEventHandler
    implements Disposable {
        private P _player;
        private double _sceneX;
        private double _sceneY;
        private Node _sprite;
        private double _translateX;
        private double _translateY;
        private EventHandler<MouseEvent> _onMouseDraggedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                if (DragPlayerEventHandler.this._player.isVisible()) {
                    Node theSprite = (Node)aEvent.getSource();
                    double theSceneOffsetX = aEvent.getSceneX() - DragPlayerEventHandler.this._sceneX;
                    double theSceneOffsetY = aEvent.getSceneY() - DragPlayerEventHandler.this._sceneY;
                    double theTranslateX = DragPlayerEventHandler.this._translateX + theSceneOffsetX;
                    double theTranslateY = DragPlayerEventHandler.this._translateY + theSceneOffsetY;
                    int theBorderWidth = (int)DragPlayerEventHandler.this.this$0._bordersH / 2;
                    int theBorderHeight = (int)DragPlayerEventHandler.this.this$0._bordersV / 2;
                    if (theTranslateX >= (double)(-theBorderWidth) && theTranslateX <= (double)((DragPlayerEventHandler.this.this$0.getFieldWidth() + DragPlayerEventHandler.this.this$0.getFieldGap()) * (DragPlayerEventHandler.this.this$0.getGridWidth() - 1) + theBorderWidth)) {
                        theSprite.setTranslateX(theTranslateX);
                    }
                    if (theTranslateY >= (double)(-theBorderHeight) && theTranslateY <= (double)((DragPlayerEventHandler.this.this$0.getFieldHeight() + DragPlayerEventHandler.this.this$0.getFieldGap()) * (DragPlayerEventHandler.this.this$0.getGridHeight() - 1) + theBorderHeight)) {
                        theSprite.setTranslateY(theTranslateY);
                    }
                    aEvent.consume();
                }
            }
        };
        private EventHandler<MouseEvent> _onMousePressedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                if (DragPlayerEventHandler.this._player.isVisible()) {
                    Node theSprite = (Node)aEvent.getSource();
                    theSprite.setOpacity(0.5);
                    DragPlayerEventHandler.this._sceneX = aEvent.getSceneX();
                    DragPlayerEventHandler.this._sceneY = aEvent.getSceneY();
                    DragPlayerEventHandler.this._translateX = theSprite.getTranslateX();
                    DragPlayerEventHandler.this._translateY = theSprite.getTranslateY();
                    LOGGER.log(Level.FINE, "Player mouse press X := " + aEvent.getSceneX());
                    LOGGER.log(Level.FINE, "Player mouse press Y := " + aEvent.getSceneY());
                    aEvent.consume();
                }
            }
        };
        private EventHandler<MouseEvent> _onMouseReleasedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                Node theSprite = (Node)aEvent.getSource();
                if (DragPlayerEventHandler.this._player.isVisible()) {
                    double theSceneOffsetX = aEvent.getSceneX() - DragPlayerEventHandler.this._sceneX;
                    double theSceneOffsetY = aEvent.getSceneY() - DragPlayerEventHandler.this._sceneY;
                    double theStepX = Math.round(theSceneOffsetX / (double)(DragPlayerEventHandler.this.this$0.getFieldWidth() + DragPlayerEventHandler.this.this$0.getFieldGap()));
                    double theStepY = Math.round(theSceneOffsetY / (double)(DragPlayerEventHandler.this.this$0.getFieldHeight() + DragPlayerEventHandler.this.this$0.getFieldGap()));
                    int thePosX = (int)((double)DragPlayerEventHandler.this._player.getPositionX() + theStepX);
                    int thePosY = (int)((double)DragPlayerEventHandler.this._player.getPositionY() + theStepY);
                    if (thePosX >= DragPlayerEventHandler.this.this$0.getGridWidth() || thePosX < 0 || thePosY >= DragPlayerEventHandler.this.this$0.getGridHeight() || thePosY < 0) {
                        theStepY = 0.0;
                        theStepX = 0.0;
                        thePosY = (int)((double)DragPlayerEventHandler.this._player.getPositionY() + theStepY);
                        thePosX = (int)((double)DragPlayerEventHandler.this._player.getPositionX() + theStepX);
                    }
                    try {
                        DragPlayerEventHandler.this._player.setPosition(thePosX, thePosY);
                    }
                    catch (VetoException.VetoRuntimeException e) {
                        LOGGER.log(Level.WARNING, "Change player <" + DragPlayerEventHandler.this._player + "> position to (" + thePosX + ", " + thePosY + ") has been vetoed: " + ExceptionUtility.toMessage((Throwable)e), e);
                        theStepX = 0.0;
                        theStepY = 0.0;
                    }
                    if (theStepX == 0.0 && theStepY == 0.0) {
                        DragPlayerEventHandler.this.this$0.fxMovePlayer(DragPlayerEventHandler.this._player, (Position)DragPlayerEventHandler.this._player, DragPlayerEventHandler.this.this$0._movePlayerDurationMillis);
                    }
                    theSprite.setOpacity(1.0);
                    aEvent.consume();
                }
            }
        };
        final /* synthetic */ FxCheckerboardViewer this$0;

        public DragPlayerEventHandler(P aPlayer, Node aSprite) {
            this.this$0 = var1_1;
            aSprite.setOnMousePressed(this._onMousePressedEventHandler);
            aSprite.setOnMouseDragged(this._onMouseDraggedEventHandler);
            aSprite.setOnMouseReleased(this._onMouseReleasedEventHandler);
            this._player = aPlayer;
            this._sprite = aSprite;
        }

        public void dispose() {
            this._sprite.removeEventHandler(MouseEvent.MOUSE_PRESSED, this._onMousePressedEventHandler);
            this._sprite.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this._onMouseDraggedEventHandler);
            this._sprite.removeEventHandler(MouseEvent.MOUSE_RELEASED, this._onMouseReleasedEventHandler);
            this._sprite = null;
            this._player = null;
        }
    }

    private static class ClickPlayerEventHandler
    implements Disposable {
        private EventHandler<MouseEvent> _onMouseClickedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                if (ClickPlayerEventHandler.this._player != null && ClickPlayerEventHandler.this._player.isVisible()) {
                    LOGGER.log(Level.FINE, "Player mouse press X := " + aEvent.getSceneX());
                    LOGGER.log(Level.FINE, "Player mouse press Y := " + aEvent.getSceneY());
                    ClickPlayerEventHandler.this._player.click();
                    aEvent.consume();
                }
            }
        };
        private P _player;
        private Node _sprite;
        final /* synthetic */ FxCheckerboardViewer this$0;

        public ClickPlayerEventHandler(P aPlayer, Node aSprite) {
            this.this$0 = var1_1;
            aSprite.setOnMouseClicked(this._onMouseClickedEventHandler);
            this._player = aPlayer;
            this._sprite = aSprite;
        }

        public void dispose() {
            this._sprite.removeEventHandler(MouseEvent.MOUSE_CLICKED, this._onMouseClickedEventHandler);
            this._sprite = null;
            this._player = null;
        }
    }
}

