/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard.alt.javafx;

import javafx.scene.Node;
import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxSpriteFactory;

public abstract class AbstractFxSpriteFactory<S, B extends AbstractFxSpriteFactory<S, B>>
implements FxSpriteFactory<S> {
    private double _scaleFactor = 1.0;
    private double _opacity = 1.0;

    public double getScaleFactor() {
        return this._scaleFactor;
    }

    public void setScaleFactor(double aScaleFactor) {
        this._scaleFactor = aScaleFactor;
    }

    public B withScaleFactor(double aScaleFactor) {
        this._scaleFactor = aScaleFactor;
        return (B)this;
    }

    public double getOpacity() {
        return this._opacity;
    }

    public void setOpacity(double aOpacity) {
        this._opacity = aOpacity;
    }

    public B withOpacity(double aOpacity) {
        this._opacity = aOpacity;
        return (B)this;
    }

    protected static double getScaleX(Node aSprite, FxCheckerboardViewer<?, ?> aCheckerboard) {
        return (double)aCheckerboard.getFieldWidth() / aSprite.getBoundsInLocal().getWidth();
    }

    protected static double getScaleY(Node aSprite, FxCheckerboardViewer<?, ?> aCheckerboard) {
        return (double)aCheckerboard.getFieldHeight() / aSprite.getBoundsInLocal().getHeight();
    }

    protected <N extends Node> N toInitNode(N aSprite, FxCheckerboardViewer<?, ?> aCheckerboard) {
        double theScaleY;
        double theScaleX = AbstractFxSpriteFactory.getScaleX(aSprite, aCheckerboard) - (1.0 - this._scaleFactor);
        double theScale = theScaleX > (theScaleY = AbstractFxSpriteFactory.getScaleY(aSprite, aCheckerboard) - (1.0 - this._scaleFactor)) ? theScaleX : theScaleY;
        aSprite.setScaleX(theScale);
        aSprite.setScaleY(theScale);
        aSprite.setOpacity(this.getOpacity());
        return aSprite;
    }

    protected <N extends Node> N toInitNode(double aScale, N aSprite, FxCheckerboardViewer<?, ?> aCheckerboard) {
        double theScaleY;
        double theScaleX = AbstractFxSpriteFactory.getScaleX(aSprite, aCheckerboard) - (1.0 - this._scaleFactor);
        double theScale = theScaleX > (theScaleY = AbstractFxSpriteFactory.getScaleY(aSprite, aCheckerboard) - (1.0 - this._scaleFactor)) ? theScaleX : theScaleY;
        aSprite.setScaleX(theScale * aScale);
        aSprite.setScaleY(theScale * aScale);
        aSprite.setOpacity(this.getOpacity());
        return aSprite;
    }
}

