package org.refcodes.checkerboard.alt.javafx;

import org.refcodes.checkerboard.GraphicalCheckerboardViewer;
import org.refcodes.checkerboard.Player;

import javafx.scene.Node;

/**
 * The Interface FxCheckerboardViewer.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public interface FxCheckerboardViewer<P extends Player<P, S>, S> extends GraphicalCheckerboardViewer<P, S, Node, FxSpriteFactory<S>, FxBackgroundFactory<P, S>, FxCheckerboardViewer<P, S>> {

	/**
	 * Gets the move player duration in millis.
	 *
	 * @return the move player duration in millis
	 */
	int getMovePlayerDurationInMillis();

	/**
	 * Sets the move player duration in millis.
	 *
	 * @param aMovePlayerDurationInMillis the new move player duration in millis
	 */
	void setMovePlayerDurationInMillis( int aMovePlayerDurationInMillis );

	/**
	 * With move player duration in millis.
	 *
	 * @param aMovePlayerDurationInMillis the move player duration in millis
	 * @return the fx checkerboard viewer
	 */
	default FxCheckerboardViewer<P, S> withMovePlayerDurationInMillis( int aMovePlayerDurationInMillis ) {
		setMovePlayerDurationInMillis( aMovePlayerDurationInMillis );
		return this;
	}

	/**
	 * Gets the adds the player duration in millis.
	 *
	 * @return the adds the player duration in millis
	 */
	int getAddPlayerDurationInMillis();

	/**
	 * Sets the adds the player duration in millis.
	 *
	 * @param aAddPlayerDurationInMillis the new adds the player duration in
	 *        millis
	 */
	void setAddPlayerDurationInMillis( int aAddPlayerDurationInMillis );

	/**
	 * With add player duration in millis.
	 *
	 * @param aAddPlayerDurationInMillis the add player duration in millis
	 * @return the fx checkerboard viewer
	 */
	default FxCheckerboardViewer<P, S> withAddPlayerDurationInMillis( int aAddPlayerDurationInMillis ) {
		setAddPlayerDurationInMillis( aAddPlayerDurationInMillis );
		return this;
	}

	/**
	 * Gets the removes the player duration in millis.
	 *
	 * @return the removes the player duration in millis
	 */
	int getRemovePlayerDurationInMillis();

	/**
	 * Sets the removes the player duration in millis.
	 *
	 * @param aRemovePlayerDurationInMillis the new removes the player duration
	 *        in millis
	 */
	void setRemovePlayerDurationInMillis( int aRemovePlayerDurationInMillis );

	/**
	 * With remove player duration in millis.
	 *
	 * @param aRemovePlayerDurationInMillis the remove player duration in millis
	 * @return the fx checkerboard viewer
	 */
	default FxCheckerboardViewer<P, S> withRemovePlayerDurationInMillis( int aRemovePlayerDurationInMillis ) {
		setRemovePlayerDurationInMillis( aRemovePlayerDurationInMillis );
		return this;
	}

	/**
	 * Gets the change player state in millis.
	 *
	 * @return the change player state in millis
	 */
	int getChangePlayerStateInMillis();

	/**
	 * Sets the change player state in millis.
	 *
	 * @param aChangePlayerStateInMillis the new change player state in millis
	 */
	void setChangePlayerStateInMillis( int aChangePlayerStateInMillis );

	/**
	 * With change player state in millis.
	 *
	 * @param aChangePlayerStateInMillis the change player state in millis
	 * @return the fx checkerboard viewer
	 */
	default FxCheckerboardViewer<P, S> withChangePlayerStateInMillis( int aChangePlayerStateInMillis ) {
		setChangePlayerStateInMillis( aChangePlayerStateInMillis );
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default FxCheckerboardViewer<P, S> withDragOpacity( double aOpacity ) {
		setDragOpacity( aOpacity );
		return this;
	}
}
