// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard.alt.javafx.impls;

import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxChessboardFactory;
import org.refcodes.graphical.ext.javafx.FxRasterFactory;
import org.refcodes.graphical.ext.javafx.impls.FxRasterFactoryImpl;

import javafx.scene.Node;
import javafx.scene.paint.Color;

/**
 * The Class FxChessboardFactoryImpl.
 *
 * @author steiner
 * @param <P> the generic type
 * @param <S> the generic type
 */
public class FxChessboardFactoryImpl<P extends Player<P, S>, S> implements FxChessboardFactory<P, S> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private FxRasterFactory _factory = new FxRasterFactoryImpl();

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public FxChessboardFactory<P, S> withEvenFieldColor( Color aEvenFieldColor ) {
		_factory.setEvenFieldColor( aEvenFieldColor );
		return this;
	}

	@Override
	public FxChessboardFactory<P, S> withOddFieldColor( Color aOddFieldColor ) {
		_factory.setOddFieldColor( aOddFieldColor );
		return this;
	}

	@Override
	public FxChessboardFactory<P, S> withFieldGapColor( Color aFieldGapColor ) {
		_factory.setFieldGapColor( aFieldGapColor );
		return this;
	}

	@Override
	public Color getEvenFieldColor() {
		return _factory.getEvenFieldColor();
	}

	@Override
	public void setEvenFieldColor( Color eEvenFieldColor ) {
		_factory.setEvenFieldColor( eEvenFieldColor );
	}

	@Override
	public Color getOddFieldColor() {
		return _factory.getOddFieldColor();
	}

	@Override
	public void setOddFieldColor( Color aOddFieldColor ) {
		_factory.setOddFieldColor( aOddFieldColor );
	}

	@Override
	public void setFieldGapColor( Color aFieldGapColor ) {
		_factory.setFieldGapColor( aFieldGapColor );
	}

	@Override
	public Color getFieldGapColor() {
		return _factory.getFieldGapColor();
	}

	// /////////////////////////////////////////////////////////////////////////
	// FACTORIES:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public Node toInstance( FxCheckerboardViewer<P, S> aContext ) {
		return _factory.toInstance( aContext );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
