/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard.alt.javafx.impls;

import javafx.application.Application;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import org.refcodes.checkerboard.BackgroundFactory;
import org.refcodes.checkerboard.ChangePositionEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.ChessmanStatus;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.SpriteFactory;
import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.impls.FxCheckerboardViewerImpl;
import org.refcodes.checkerboard.alt.javafx.impls.FxChessboardFactoryImpl;
import org.refcodes.checkerboard.alt.javafx.impls.FxChessmenFactoryImpl;
import org.refcodes.checkerboard.impls.CheckerboardImpl;
import org.refcodes.checkerboard.impls.PlayerImpl;
import org.refcodes.component.InitializeException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.VetoException;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.ScaleMode;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;

public class CheckerboardDemo
extends Application {
    private static final double SCALE_FACTOR = 0.75;
    private static RuntimeLogger LOGGER = (RuntimeLogger)RuntimeLoggerFactorySingleton.getInstance().createInstance();
    private FxCheckerboardViewerImpl<ChessmanStatus> _checkerboardViewer = null;
    private Checkerboard<ChessmanStatus> _checkerboard = null;
    private Player<ChessmanStatus> _blackRookA = new PlayerImpl(0, 0).withState((Object)ChessmanStatus.BLACK_ROOK);
    private Player<ChessmanStatus> _blackKnightB = new PlayerImpl(1, 0).withState((Object)ChessmanStatus.BLACK_KNIGHT);
    private Player<ChessmanStatus> _blackBishopC = new PlayerImpl(2, 0).withState((Object)ChessmanStatus.BLACK_BISHOP);
    private Player<ChessmanStatus> _blackQueen = new PlayerImpl(3, 0).withState((Object)ChessmanStatus.BLACK_QUEEN);
    private Player<ChessmanStatus> _blackKing = new PlayerImpl(4, 0).withState((Object)ChessmanStatus.BLACK_KING);
    private Player<ChessmanStatus> _blackBishopF = new PlayerImpl(5, 0).withState((Object)ChessmanStatus.BLACK_BISHOP);
    private Player<ChessmanStatus> _blackKnightG = new PlayerImpl(6, 0).withState((Object)ChessmanStatus.BLACK_KNIGHT);
    private Player<ChessmanStatus> _blackRookH = new PlayerImpl(7, 0).withState((Object)ChessmanStatus.BLACK_ROOK);
    private Player<ChessmanStatus> _blackPawnA = new PlayerImpl(0, 1).withState((Object)ChessmanStatus.BLACK_PAWN);
    private Player<ChessmanStatus> _blackPawnB = new PlayerImpl(1, 1).withState((Object)ChessmanStatus.BLACK_PAWN);
    private Player<ChessmanStatus> _blackPawnC = new PlayerImpl(2, 1).withState((Object)ChessmanStatus.BLACK_PAWN);
    private Player<ChessmanStatus> _blackPawnD = new PlayerImpl(3, 1).withState((Object)ChessmanStatus.BLACK_PAWN);
    private Player<ChessmanStatus> _blackPawnE = new PlayerImpl(4, 1).withState((Object)ChessmanStatus.BLACK_PAWN);
    private Player<ChessmanStatus> _blackPawnF = new PlayerImpl(5, 1).withState((Object)ChessmanStatus.BLACK_PAWN);
    private Player<ChessmanStatus> _blackPawnG = new PlayerImpl(6, 1).withState((Object)ChessmanStatus.BLACK_PAWN);
    private Player<ChessmanStatus> _blackPawnH = new PlayerImpl(7, 1).withState((Object)ChessmanStatus.BLACK_PAWN);
    private Player<ChessmanStatus> _whiteRookA = new PlayerImpl(0, 7).withState((Object)ChessmanStatus.WHITE_ROOK);
    private Player<ChessmanStatus> _whiteKnightB = new PlayerImpl(1, 7).withState((Object)ChessmanStatus.WHITE_KNIGHT);
    private Player<ChessmanStatus> _whiteBishopC = new PlayerImpl(2, 7).withState((Object)ChessmanStatus.WHITE_BISHOP);
    private Player<ChessmanStatus> _whiteQueen = new PlayerImpl(3, 7).withState((Object)ChessmanStatus.WHITE_QUEEN);
    private Player<ChessmanStatus> _whiteKing = new PlayerImpl(4, 7).withState((Object)ChessmanStatus.WHITE_KING);
    private Player<ChessmanStatus> _whiteBishopF = new PlayerImpl(5, 7).withState((Object)ChessmanStatus.WHITE_BISHOP);
    private Player<ChessmanStatus> _whiteKnightG = new PlayerImpl(6, 7).withState((Object)ChessmanStatus.WHITE_KNIGHT);
    private Player<ChessmanStatus> _whiteRookH = new PlayerImpl(7, 7).withState((Object)ChessmanStatus.WHITE_ROOK);
    private Player<ChessmanStatus> _whitePawnA = new PlayerImpl(0, 6).withState((Object)ChessmanStatus.WHITE_PAWN);
    private Player<ChessmanStatus> _whitePawnB = new PlayerImpl(1, 6).withState((Object)ChessmanStatus.WHITE_PAWN);
    private Player<ChessmanStatus> _whitePawnC = new PlayerImpl(2, 6).withState((Object)ChessmanStatus.WHITE_PAWN);
    private Player<ChessmanStatus> _whitePawnD = new PlayerImpl(3, 6).withState((Object)ChessmanStatus.WHITE_PAWN);
    private Player<ChessmanStatus> _whitePawnE = new PlayerImpl(4, 6).withState((Object)ChessmanStatus.WHITE_PAWN);
    private Player<ChessmanStatus> _whitePawnF = new PlayerImpl(5, 6).withState((Object)ChessmanStatus.WHITE_PAWN);
    private Player<ChessmanStatus> _whitePawnG = new PlayerImpl(6, 6).withState((Object)ChessmanStatus.WHITE_PAWN);
    private Player<ChessmanStatus> _whitePawnH = new PlayerImpl(7, 6).withState((Object)ChessmanStatus.WHITE_PAWN);

    private void initializePlayer(Checkerboard<ChessmanStatus> aCheckerboard) {
        LOGGER.info("Initializing players on checkerboard ...");
        aCheckerboard.putPlayer(this._blackRookA);
        aCheckerboard.putPlayer(this._blackKnightB);
        aCheckerboard.putPlayer(this._blackBishopC);
        aCheckerboard.putPlayer(this._blackQueen);
        aCheckerboard.putPlayer((Player)((Player)this._blackKing.withHide()).withState((Object)ChessmanStatus.BLACK_KING_KO));
        aCheckerboard.putPlayer(this._blackBishopF);
        aCheckerboard.putPlayer(this._blackKnightG);
        aCheckerboard.putPlayer(this._blackRookH);
        aCheckerboard.putPlayer(this._blackPawnA);
        aCheckerboard.putPlayer(this._blackPawnB);
        aCheckerboard.putPlayer(this._blackPawnC);
        aCheckerboard.putPlayer(this._blackPawnD);
        aCheckerboard.putPlayer(this._blackPawnE);
        aCheckerboard.putPlayer(this._blackPawnF);
        aCheckerboard.putPlayer(this._blackPawnG);
        aCheckerboard.putPlayer(this._blackPawnH);
        aCheckerboard.putPlayer(this._whiteRookA);
        aCheckerboard.putPlayer(this._whiteKnightB);
        aCheckerboard.putPlayer(this._whiteBishopC);
        aCheckerboard.putPlayer(this._whiteQueen);
        aCheckerboard.putPlayer(this._whiteKing);
        aCheckerboard.putPlayer(this._whiteBishopF);
        aCheckerboard.putPlayer(this._whiteKnightG);
        aCheckerboard.putPlayer(this._whiteRookH);
        aCheckerboard.putPlayer(this._whitePawnA);
        aCheckerboard.putPlayer(this._whitePawnB);
        aCheckerboard.putPlayer(this._whitePawnC);
        aCheckerboard.putPlayer(this._whitePawnD);
        aCheckerboard.putPlayer(this._whitePawnE);
        aCheckerboard.putPlayer(this._whitePawnF);
        aCheckerboard.putPlayer(this._whitePawnG);
        aCheckerboard.putPlayer(this._whitePawnH);
    }

    public void start(Stage aPrimaryStage) {
        try {
            aPrimaryStage.setTitle("Checkerboard");
            this._checkerboard = new CheckerboardImpl();
            this._checkerboardViewer = new FxCheckerboardViewerImpl<ChessmanStatus>(this._checkerboard){

                public void onChangePositionEvent(ChangePositionEvent<ChessmanStatus> aEvent, Checkerboard<ChessmanStatus> aSource) throws VetoException {
                    if (aEvent.getPrecedingPosition().getPositionX() == 0 && aEvent.getPrecedingPosition().getPositionY() == 0) {
                        throw new VetoException("Player <" + aEvent.getSource() + "> is glued to position (1, 1).");
                    }
                }
            };
            this._checkerboard.withGridDimension(20, 20);
            this._checkerboard.withGridMode(GridMode.CLOSED);
            ((FxCheckerboardViewer)this._checkerboardViewer.withMoveMode(MoveMode.SMOOTH)).withScaleMode(ScaleMode.SCALE_GRID);
            this._checkerboardViewer.withSpriteFactory((SpriteFactory)new FxChessmenFactoryImpl().withScaleFactor(0.75));
            ((FxCheckerboardViewer)((FxCheckerboardViewer)((FxCheckerboardViewer)this._checkerboardViewer.withViewportDimension(16, 16)).withFieldDimension(32, 32)).withFieldGap(2)).withMinViewportDimension(8, 8);
            this._checkerboardViewer.withBackgroundFactory((BackgroundFactory)new FxChessboardFactoryImpl().withFieldGapColor(Color.rgb((int)95, (int)255, (int)0)).withOddFieldColor(Color.rgb((int)0, (int)95, (int)0)).withEvenFieldColor(Color.rgb((int)0, (int)135, (int)0)));
            this._checkerboardViewer.withInitialize(aPrimaryStage).show();
            this._checkerboardViewer.withViewportOffset(0, 0);
            ControlFlowUtility.createExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        CheckerboardDemo.this.initializePlayer((Checkerboard<ChessmanStatus>)CheckerboardDemo.this._checkerboard);
                        CheckerboardDemo.this._blackRookA.blink();
                        CheckerboardDemo.this.changeOffset();
                        CheckerboardDemo.this.movePlayer();
                        CheckerboardDemo.this.showPlayer();
                        CheckerboardDemo.this.resizeGrid();
                        CheckerboardDemo.this._blackKing.blink();
                        CheckerboardDemo.this._blackKing.show();
                        CheckerboardDemo.this.removePlayer();
                        CheckerboardDemo.this.dragPlayer();
                    }
                    catch (Exception ignore) {
                        LOGGER.error(ExceptionUtility.toMessage((Throwable)ignore), (Throwable)ignore);
                    }
                }
            });
        }
        catch (InitializeException e) {
            LOGGER.error(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            System.exit(1);
        }
    }

    private void changeOffset() {
        this._checkerboardViewer.setViewportOffset(this._checkerboardViewer.getViewportOffsetX() - 2, this._checkerboardViewer.getViewportOffsetY() - 1);
    }

    private void movePlayer() throws InterruptedException {
        this._whitePawnA.setPosition(this._whitePawnA.getPositionX(), this._whitePawnA.getPositionY() - 2);
        Thread.sleep(500L);
        this._blackPawnH.setPosition(this._blackPawnH.getPositionX(), this._blackPawnH.getPositionY() + 2);
        Thread.sleep(500L);
        this._whitePawnB.setPosition(this._whitePawnB.getPositionX(), this._whitePawnB.getPositionY() - 1);
        Thread.sleep(500L);
        this._blackKnightB.setPosition(this._blackKnightB.getPositionX() + 1, this._blackKnightB.getPositionY() + 2);
        Thread.sleep(500L);
        this._whitePawnC.setPosition(this._whitePawnC.getPositionX(), this._whitePawnC.getPositionY() - 2);
    }

    private void resizeGrid() throws InitializeException, InterruptedException {
        this._checkerboardViewer.withViewportWidth(this._checkerboardViewer.getViewportWidth() + 2);
        Thread.sleep(500L);
        this._checkerboardViewer.withViewportHeight(this._checkerboardViewer.getViewportHeight() + 2);
        Thread.sleep(500L);
        this._checkerboardViewer.withViewportWidth(this._checkerboardViewer.getViewportWidth() + 2);
        Thread.sleep(500L);
        this._checkerboardViewer.withViewportWidth(this._checkerboardViewer.getViewportWidth() - 1);
        Thread.sleep(500L);
        this._checkerboardViewer.withViewportWidth(this._checkerboardViewer.getViewportWidth() - 1);
        Thread.sleep(500L);
        this._checkerboardViewer.withViewportWidth(this._checkerboardViewer.getViewportWidth() - 2);
        this._checkerboardViewer.withViewportHeight(this._checkerboardViewer.getViewportHeight() + 1);
        Thread.sleep(500L);
        this._checkerboardViewer.withViewportHeight(this._checkerboardViewer.getViewportHeight() - 3);
    }

    private void removePlayer() throws InterruptedException {
        this._checkerboard.removePlayer(this._whitePawnA);
        Thread.sleep(500L);
        this._checkerboard.removePlayer(this._blackPawnH);
        Thread.sleep(500L);
        this._checkerboard.removePlayer(this._whitePawnB);
        Thread.sleep(500L);
        this._checkerboard.removePlayer(this._blackKnightB);
        Thread.sleep(500L);
        this._checkerboard.removePlayer(this._whitePawnC);
    }

    private void showPlayer() throws InterruptedException {
        this._whitePawnA.blink();
    }

    private void dragPlayer() throws InterruptedException {
        this._blackKing.blink();
        this._blackKing.setState((Object)ChessmanStatus.BLACK_KING);
        this._blackKing.draggable();
        this._whiteKing.blink();
        this._whiteKing.setState((Object)ChessmanStatus.WHITE_KING_KO);
        this._whiteKing.stationary();
    }

    public void stop() {
        this._checkerboardViewer.destroy();
    }

    public static void main(String[] args) {
        CheckerboardDemo.launch((String[])args);
    }
}

