// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard.alt.javafx.impls;

import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxBoulderDashFactory;
import org.refcodes.checkerboard.BoulderDashStatus;
import org.refcodes.data.ext.boulderdash.BoulderDashPixmapDataLocator;
import org.refcodes.graphical.ext.javafx.impls.FxFlipBookImpl;
import org.refcodes.graphical.ext.javafx.FxGraphicalUtility;

import javafx.scene.Node;
import javafx.scene.image.ImageView;

/**
 * @author steiner
 *
 */
public class FxBoulderDashFactoryImpl extends AbstractFxSpriteFactory<BoulderDashStatus, FxBoulderDashFactoryImpl> implements FxBoulderDashFactory {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	private static final int IMAGE_DURATION = 150;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public FxBoulderDashFactoryImpl() {}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public Node createInstance( BoulderDashStatus aIdentifier, FxCheckerboardViewer<BoulderDashStatus> aContext ) {
		switch ( aIdentifier ) {
		case AMOEBA: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toAmoebaAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case BOULDER:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( BoulderDashPixmapDataLocator.BOULDER.getDataInputStream() ) ), aContext );
		case BUTTERFLY: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toButterflyAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case DIAMOND: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toDiamondBirthAnimationInputStreams() ) );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toDiamondAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case DIAMOND_BIRTH: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toDiamondBirthAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case DIRT:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( BoulderDashPixmapDataLocator.DIRT.getDataInputStream() ) ), aContext );
		case EXPANDING_WALL:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( BoulderDashPixmapDataLocator.EXPANDING_WALL.getDataInputStream() ) ), aContext );
		case FIREFLY: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toFireflyAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case MAGIC_WALL: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toMagicWallAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case MAGIC_WALL_EXPIRED:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( BoulderDashPixmapDataLocator.MAGIC_WALL_EXPIRED.getDataInputStream() ) ), aContext );
		case ROCKFORD_BIRTH: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toRockfordBirthAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_FORWARD: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toSteelWallAnimationInputStreams() ) );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toSteelWallAnimationInputStreams() ) );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toSteelWallAnimationInputStreams() ) );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toRockfordBirthAnimationInputStreams() ) );
			theSprite.withMainLoopImage( FxGraphicalUtility.toImage( BoulderDashPixmapDataLocator.ROCKFORD_FACING_FORWARD.getDataInputStream() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_FORWARD_BLINKING: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toRockfordFacingForwardBlinkingAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_FORWARD_BLINKING_TRAPPING_FOOT: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toRockfordFacingForwardBlinkingTappingFootAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_FORWARD_TRAPPING_FOOT: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toRockfordFacingForwardTappingFootAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_LEFT: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toRockfordFacingLeftAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_RIGHT: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toRockfordFacingRightAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case STEEL_WALL:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( BoulderDashPixmapDataLocator.STEEL_WALL.getDataInputStream() ) ), aContext );
		case STEEL_WALL_BLINKING: {
			FxFlipBookImpl theSprite = new FxFlipBookImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( BoulderDashPixmapDataLocator.toSteelWallAnimationInputStreams() ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case STEEL_WALL_OPEN:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( BoulderDashPixmapDataLocator.STEEL_WALL_OPEN.getDataInputStream() ) ), aContext );
		default:
			return null;
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
