package org.refcodes.checkerboard.alt.javafx;

import org.refcodes.checkerboard.GraphicalCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxBackgroundFactory;
import org.refcodes.checkerboard.alt.javafx.FxSpriteFactory;
import org.refcodes.component.Configurable;
import org.refcodes.component.Configurable.ConfigureBuilder;

import javafx.scene.Node;
import javafx.stage.Stage;

public interface FxCheckerboardViewer<S> extends GraphicalCheckerboardViewer<S, Node, FxSpriteFactory<S>, FxBackgroundFactory<S>, FxCheckerboardViewer<S>>, Configurable<Stage>, ConfigureBuilder<Stage, FxCheckerboardViewer<S>> {

	int getMovePlayerDurationInMillis();

	void setMovePlayerDurationInMillis( int aMovePlayerDurationInMillis );

	FxCheckerboardViewer<S> withMovePlayerDurationInMillis( int aMovePlayerDurationInMillis );

	int getAddPlayerDurationInMillis();

	void setAddPlayerDurationInMillis( int aAddPlayerDurationInMillis );

	FxCheckerboardViewer<S> withAddPlayerDurationInMillis( int aAddPlayerDurationInMillis );

	int getRemovePlayerDurationInMillis();

	void setRemovePlayerDurationInMillis( int aRemovePlayerDurationInMillis );

	FxCheckerboardViewer<S> withRemovePlayerDurationInMillis( int aRemovePlayerDurationInMillis );

	int getChangePlayerStateInMillis();

	void setChangePlayerStateInMillis( int aChangePlayerStateInMillis );

	FxCheckerboardViewer<S> withChangePlayerStateInMillis( int aChangePlayerStateInMillis );
}
