/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.Manager;
import org.apache.catalina.session.StandardSession;
import org.redisson.api.RMap;
import org.redisson.tomcat.RedissonSessionManager;

public class RedissonSession
extends StandardSession {
    private final RedissonSessionManager redissonManager;
    private RMap<String, Object> map;
    private static final long serialVersionUID = -2518607181636076487L;

    public RedissonSession(RedissonSessionManager manager) {
        super((Manager)manager);
        this.redissonManager = manager;
    }

    public void setId(String id, boolean notify) {
        super.setId(id, notify);
        this.map = this.redissonManager.getMap(id);
    }

    public void setCreationTime(long time) {
        super.setCreationTime(time);
        if (this.map != null) {
            HashMap<String, Long> newMap = new HashMap<String, Long>(3);
            newMap.put("session:creationTime", this.creationTime);
            newMap.put("session:lastAccessedTime", this.lastAccessedTime);
            newMap.put("session:thisAccessedTime", this.thisAccessedTime);
            this.map.putAll(newMap);
        }
    }

    public void access() {
        super.access();
        if (this.map != null) {
            HashMap<String, Long> newMap = new HashMap<String, Long>(2);
            newMap.put("session:lastAccessedTime", this.lastAccessedTime);
            newMap.put("session:thisAccessedTime", this.thisAccessedTime);
            this.map.putAll(newMap);
            if (this.getMaxInactiveInterval() >= 0) {
                this.map.expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
            }
        }
    }

    public void setMaxInactiveInterval(int interval) {
        super.setMaxInactiveInterval(interval);
        if (this.map != null) {
            this.map.fastPut((Object)"session:maxInactiveInterval", (Object)this.maxInactiveInterval);
            if (this.maxInactiveInterval >= 0) {
                this.map.expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
            }
        }
    }

    public void setValid(boolean isValid) {
        super.setValid(isValid);
        if (this.map != null) {
            this.map.fastPut((Object)"session:isValid", (Object)isValid);
        }
    }

    public void setNew(boolean isNew) {
        super.setNew(isNew);
        if (this.map != null) {
            this.map.fastPut((Object)"session:isNew", (Object)isNew);
        }
    }

    public void endAccess() {
        boolean oldValue = this.isNew;
        super.endAccess();
        if (this.isNew != oldValue) {
            this.map.fastPut((Object)"session:isNew", (Object)this.isNew);
        }
    }

    public void setAttribute(String name, Object value, boolean notify) {
        super.setAttribute(name, value, notify);
        if (this.map != null && value != null) {
            this.map.fastPut((Object)name, value);
        }
    }

    protected void removeAttributeInternal(String name, boolean notify) {
        super.removeAttributeInternal(name, notify);
        if (this.map != null) {
            this.map.fastRemove((Object[])new String[]{name});
        }
    }

    public void save() {
        HashMap<String, Serializable> newMap = new HashMap<String, Serializable>();
        newMap.put("session:creationTime", Long.valueOf(this.creationTime));
        newMap.put("session:lastAccessedTime", Long.valueOf(this.lastAccessedTime));
        newMap.put("session:thisAccessedTime", Long.valueOf(this.thisAccessedTime));
        newMap.put("session:maxInactiveInterval", Integer.valueOf(this.maxInactiveInterval));
        newMap.put("session:isValid", Boolean.valueOf(this.isValid));
        newMap.put("session:isNew", Boolean.valueOf(this.isNew));
        for (Map.Entry entry : this.attributes.entrySet()) {
            newMap.put((String)entry.getKey(), (Serializable)entry.getValue());
        }
        this.map.putAll(newMap);
        if (this.maxInactiveInterval >= 0) {
            this.map.expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
        }
    }

    public void load() {
        Set entrySet = this.map.readAllEntrySet();
        for (Map.Entry entry : entrySet) {
            if ("session:creationTime".equals(entry.getKey())) {
                this.creationTime = (Long)entry.getValue();
                continue;
            }
            if ("session:lastAccessedTime".equals(entry.getKey())) {
                this.lastAccessedTime = (Long)entry.getValue();
                continue;
            }
            if ("session:thisAccessedTime".equals(entry.getKey())) {
                this.thisAccessedTime = (Long)entry.getValue();
                continue;
            }
            if ("session:maxInactiveInterval".equals(entry.getKey())) {
                this.maxInactiveInterval = (Integer)entry.getValue();
                continue;
            }
            if ("session:isValid".equals(entry.getKey())) {
                this.isValid = (Boolean)entry.getValue();
                continue;
            }
            if ("session:isNew".equals(entry.getKey())) {
                this.isNew = (Boolean)entry.getValue();
                continue;
            }
            this.setAttribute((String)entry.getKey(), entry.getValue(), false);
        }
    }
}

