/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.Manager;
import org.apache.catalina.session.StandardSession;
import org.redisson.api.RMap;
import org.redisson.tomcat.RedissonSessionManager;

public class RedissonSession
extends StandardSession {
    private final RedissonSessionManager redissonManager;
    private final Map<String, Object> attrs;
    private RMap<String, Object> map;
    private final RedissonSessionManager.ReadMode readMode;
    private static final long serialVersionUID = -2518607181636076487L;

    public RedissonSession(RedissonSessionManager manager, RedissonSessionManager.ReadMode readMode) {
        super((Manager)manager);
        this.redissonManager = manager;
        this.readMode = readMode;
        try {
            Field attr = StandardSession.class.getDeclaredField("attributes");
            this.attrs = (Map)attr.get((Object)this);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Object getAttribute(String name) {
        if (this.readMode == RedissonSessionManager.ReadMode.REDIS) {
            return this.map.get((Object)name);
        }
        return super.getAttribute(name);
    }

    public void setId(String id, boolean notify) {
        super.setId(id, notify);
        this.map = this.redissonManager.getMap(id);
    }

    public void delete() {
        this.map.delete();
        this.map = null;
    }

    public void setCreationTime(long time) {
        super.setCreationTime(time);
        if (this.map != null) {
            HashMap<String, Long> newMap = new HashMap<String, Long>(3);
            newMap.put("session:creationTime", this.creationTime);
            newMap.put("session:lastAccessedTime", this.lastAccessedTime);
            newMap.put("session:thisAccessedTime", this.thisAccessedTime);
            this.map.putAll(newMap);
        }
    }

    public void access() {
        super.access();
        if (this.map != null) {
            HashMap<String, Long> newMap = new HashMap<String, Long>(2);
            newMap.put("session:lastAccessedTime", this.lastAccessedTime);
            newMap.put("session:thisAccessedTime", this.thisAccessedTime);
            this.map.putAll(newMap);
            if (this.getMaxInactiveInterval() >= 0) {
                this.map.expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
            }
        }
    }

    public void setMaxInactiveInterval(int interval) {
        super.setMaxInactiveInterval(interval);
        if (this.map != null) {
            this.map.fastPut((Object)"session:maxInactiveInterval", (Object)this.maxInactiveInterval);
            if (this.maxInactiveInterval >= 0) {
                this.map.expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
            }
        }
    }

    public void setValid(boolean isValid) {
        super.setValid(isValid);
        if (this.map != null) {
            this.map.fastPut((Object)"session:isValid", (Object)isValid);
        }
    }

    public void setNew(boolean isNew) {
        super.setNew(isNew);
        if (this.map != null) {
            this.map.fastPut((Object)"session:isNew", (Object)isNew);
        }
    }

    public void endAccess() {
        boolean oldValue = this.isNew;
        super.endAccess();
        if (this.isNew != oldValue) {
            this.map.fastPut((Object)"session:isNew", (Object)this.isNew);
        }
    }

    public void setAttribute(String name, Object value, boolean notify) {
        super.setAttribute(name, value, notify);
        if (this.map != null && value != null) {
            this.map.fastPut((Object)name, value);
        }
    }

    protected void removeAttributeInternal(String name, boolean notify) {
        super.removeAttributeInternal(name, notify);
        if (this.map != null) {
            this.map.fastRemove((Object[])new String[]{name});
        }
    }

    public void save() {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("session:creationTime", this.creationTime);
        newMap.put("session:lastAccessedTime", this.lastAccessedTime);
        newMap.put("session:thisAccessedTime", this.thisAccessedTime);
        newMap.put("session:maxInactiveInterval", this.maxInactiveInterval);
        newMap.put("session:isValid", this.isValid);
        newMap.put("session:isNew", this.isNew);
        for (Map.Entry<String, Object> entry : this.attrs.entrySet()) {
            newMap.put(entry.getKey(), entry.getValue());
        }
        this.map.putAll(newMap);
        if (this.maxInactiveInterval >= 0) {
            this.map.expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
        }
    }

    public void load(Map<String, Object> attrs) {
        Boolean isNew;
        Boolean isValid;
        Long thisAccessedTime;
        Long lastAccessedTime;
        Long creationTime = (Long)attrs.remove("session:creationTime");
        if (creationTime != null) {
            this.creationTime = creationTime;
        }
        if ((lastAccessedTime = (Long)attrs.remove("session:lastAccessedTime")) != null) {
            this.lastAccessedTime = lastAccessedTime;
        }
        if ((thisAccessedTime = (Long)attrs.remove("session:thisAccessedTime")) != null) {
            this.thisAccessedTime = thisAccessedTime;
        }
        if ((isValid = (Boolean)attrs.remove("session:isValid")) != null) {
            this.isValid = isValid;
        }
        if ((isNew = (Boolean)attrs.remove("session:isNew")) != null) {
            this.isNew = isNew;
        }
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue(), false);
        }
    }
}

