/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.Valve;
import org.apache.catalina.session.ManagerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.api.RMap;
import org.redisson.api.RSet;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.CompositeCodec;
import org.redisson.config.Config;
import org.redisson.pubsub.PublishSubscribeService;
import org.redisson.tomcat.AttributeMessage;
import org.redisson.tomcat.AttributeRemoveMessage;
import org.redisson.tomcat.AttributeUpdateMessage;
import org.redisson.tomcat.AttributesClearMessage;
import org.redisson.tomcat.AttributesPutAllMessage;
import org.redisson.tomcat.RedissonSession;
import org.redisson.tomcat.SessionCreatedMessage;
import org.redisson.tomcat.SessionDestroyedMessage;
import org.redisson.tomcat.UpdateValve;
import org.redisson.tomcat.UsageValve;

public class RedissonSessionManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(RedissonSessionManager.class);
    protected RedissonClient redisson;
    private String configPath;
    private Config config;
    private ReadMode readMode = ReadMode.REDIS;
    private UpdateMode updateMode = UpdateMode.DEFAULT;
    protected String keyPrefix = "";
    private boolean broadcastSessionEvents = false;
    private boolean broadcastSessionUpdates = true;
    private final String nodeId = UUID.randomUUID().toString();
    private MessageListener messageListener;
    private Codec codecToUse;

    public String getNodeId() {
        return this.nodeId;
    }

    public String getUpdateMode() {
        return this.updateMode.toString();
    }

    public void setUpdateMode(String updateMode) {
        this.updateMode = UpdateMode.valueOf(updateMode);
    }

    public boolean isBroadcastSessionEvents() {
        return this.broadcastSessionEvents;
    }

    public void setBroadcastSessionEvents(boolean replicateSessionEvents) {
        this.broadcastSessionEvents = replicateSessionEvents;
    }

    public boolean isBroadcastSessionUpdates() {
        return this.broadcastSessionUpdates;
    }

    public void setBroadcastSessionUpdates(boolean broadcastSessionUpdates) {
        this.broadcastSessionUpdates = broadcastSessionUpdates;
    }

    public String getReadMode() {
        return this.readMode.toString();
    }

    public void setReadMode(String readMode) {
        this.readMode = ReadMode.valueOf(readMode);
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public String getName() {
        return RedissonSessionManager.class.getSimpleName();
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public Session createSession(String sessionId) {
        Session session = super.createSession(sessionId);
        if (this.broadcastSessionEvents) {
            this.getTopic().publish((Object)new SessionCreatedMessage(this.getNodeId(), session.getId()));
        }
        return session;
    }

    public RSet<String> getNotifiedNodes(String sessionId) {
        String separator = this.keyPrefix == null || this.keyPrefix.isEmpty() ? "" : ":";
        String name = this.keyPrefix + separator + "redisson:tomcat_notified_nodes:" + sessionId;
        return this.redisson.getSet(name, (Codec)StringCodec.INSTANCE);
    }

    public String getTomcatSessionKeyName(String sessionId) {
        String separator = this.keyPrefix == null || this.keyPrefix.isEmpty() ? "" : ":";
        return this.keyPrefix + separator + "redisson:tomcat_session:" + sessionId;
    }

    public RMap<String, Object> getMap(String sessionId) {
        String name = this.getTomcatSessionKeyName(sessionId);
        return this.redisson.getMap(name, (Codec)new CompositeCodec((Codec)StringCodec.INSTANCE, this.codecToUse, this.codecToUse));
    }

    public RTopic getTopic() {
        String separator = this.keyPrefix == null || this.keyPrefix.isEmpty() ? "" : ":";
        String name = this.keyPrefix + separator + "redisson:tomcat_session_updates:" + this.getContainer().getName();
        PublishSubscribeService ss = ((Redisson)this.redisson).getConnectionManager().getSubscribeService();
        if (ss.isShardingSupported()) {
            return this.redisson.getShardedTopic(name);
        }
        return this.redisson.getTopic(name);
    }

    public Session findSession(String id) throws IOException {
        return this.findSession(id, true);
    }

    private Session findSession(String id, boolean notify) throws IOException {
        RedissonSession result = (RedissonSession)super.findSession(id);
        if (result == null) {
            if (id != null) {
                Map<String, Object> attrs = new HashMap();
                try {
                    attrs = this.getMap(id).getAll(RedissonSession.ATTRS);
                }
                catch (Exception e) {
                    this.log.error((Object)("Can't read session object by id: " + id), (Throwable)e);
                }
                if (attrs.isEmpty() || this.broadcastSessionEvents && this.getNotifiedNodes(id).contains((Object)this.nodeId)) {
                    this.log.debug((Object)("Session " + id + " can't be found"));
                    return null;
                }
                RedissonSession session = (RedissonSession)this.createEmptySession();
                session.load(attrs);
                session.setId(id, notify);
                session.superAccess();
                session.endAccess();
                return session;
            }
            return null;
        }
        result.superAccess();
        result.endAccess();
        return result;
    }

    public Session createEmptySession() {
        RedissonSession session = new RedissonSession(this, this.readMode, this.updateMode, this.broadcastSessionEvents, this.broadcastSessionUpdates);
        if (this.broadcastSessionEvents) {
            session.addSessionListener(arg_0 -> this.lambda$createEmptySession$0((Session)session, arg_0));
        }
        return session;
    }

    public void superRemove(Session session) {
        super.remove(session, false);
    }

    public void remove(Session session, boolean update) {
        super.remove(session, update);
        if (session.getIdInternal() != null && !this.redisson.isShuttingDown()) {
            ((RedissonSession)session).delete();
        }
    }

    public void superAdd(Session session) {
        super.add(session);
    }

    public void add(Session session) {
        super.add(session);
        ((RedissonSession)session).save();
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startInternal() throws LifecycleException {
        Pipeline pipeline;
        super.startInternal();
        this.redisson = this.buildClient();
        ClassLoader applicationClassLoader = this.getContainer().getLoader().getClassLoader() != null ? this.getContainer().getLoader().getClassLoader() : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : ((Object)((Object)this)).getClass().getClassLoader());
        Codec codec = this.redisson.getConfig().getCodec();
        try {
            this.codecToUse = (Codec)codec.getClass().getConstructor(ClassLoader.class, codec.getClass()).newInstance(applicationClassLoader, codec);
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
        Pipeline pipeline2 = pipeline = this.getContainer().getPipeline();
        synchronized (pipeline2) {
            Optional<Valve> res;
            if (this.readMode == ReadMode.REDIS) {
                res = Arrays.stream(pipeline.getValves()).filter(v -> v.getClass() == UsageValve.class).findAny();
                if (res.isPresent()) {
                    ((UsageValve)res.get()).incUsage();
                } else {
                    pipeline.addValve((Valve)new UsageValve());
                }
            }
            if (this.updateMode == UpdateMode.AFTER_REQUEST) {
                res = Arrays.stream(pipeline.getValves()).filter(v -> v.getClass() == UpdateValve.class).findAny();
                if (res.isPresent()) {
                    ((UpdateValve)res.get()).incUsage();
                } else {
                    pipeline.addValve((Valve)new UpdateValve());
                }
            }
        }
        if (this.readMode == ReadMode.MEMORY && this.broadcastSessionUpdates || this.broadcastSessionEvents) {
            RTopic updatesTopic = this.getTopic();
            this.messageListener = new MessageListener<AttributeMessage>(){

                public void onMessage(CharSequence channel, AttributeMessage msg) {
                    try {
                        if (msg.getNodeId().equals(RedissonSessionManager.this.nodeId)) {
                            return;
                        }
                        RedissonSession session = (RedissonSession)RedissonSessionManager.super.findSession(msg.getSessionId());
                        if (session != null) {
                            AttributeMessage m;
                            if (msg instanceof SessionDestroyedMessage) {
                                session.expire();
                            }
                            if (msg instanceof AttributeRemoveMessage) {
                                for (String name : ((AttributeRemoveMessage)msg).getNames()) {
                                    session.superRemoveAttributeInternal(name, true);
                                }
                            }
                            if (msg instanceof AttributesClearMessage) {
                                RedissonSessionManager.super.remove((Session)session, false);
                            }
                            if (msg instanceof AttributesPutAllMessage) {
                                m = (AttributesPutAllMessage)msg;
                                Map<String, Object> attrs = ((AttributesPutAllMessage)m).getAttrs(RedissonSessionManager.this.codecToUse.getMapValueDecoder());
                                session.load(attrs);
                            }
                            if (msg instanceof AttributeUpdateMessage) {
                                m = (AttributeUpdateMessage)msg;
                                session.superSetAttribute(((AttributeUpdateMessage)m).getName(), ((AttributeUpdateMessage)m).getValue(RedissonSessionManager.this.codecToUse.getMapValueDecoder()), true);
                            }
                        } else {
                            if (msg instanceof SessionCreatedMessage) {
                                RedissonSessionManager.this.findSession(msg.getSessionId());
                            }
                            if (msg instanceof SessionDestroyedMessage) {
                                Session s = RedissonSessionManager.this.findSession(msg.getSessionId(), false);
                                if (s != null) {
                                    s.expire();
                                }
                                RSet<String> set = RedissonSessionManager.this.getNotifiedNodes(msg.getSessionId());
                                set.add((Object)RedissonSessionManager.this.nodeId);
                                set.expire(Duration.ofSeconds(60L));
                            }
                        }
                    }
                    catch (Exception e) {
                        RedissonSessionManager.this.log.error((Object)"Unable to handle topic message", (Throwable)e);
                    }
                }
            };
            updatesTopic.addListener(AttributeMessage.class, this.messageListener);
        }
        this.setState(LifecycleState.STARTING);
    }

    protected RedissonClient buildClient() throws LifecycleException {
        if (this.config == null) {
            try {
                this.config = Config.fromYAML((File)new File(this.configPath), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (IOException e) {
                try {
                    this.config = Config.fromJSON((File)new File(this.configPath), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                }
                catch (IOException e1) {
                    this.log.error((Object)("Can't parse json config " + this.configPath), (Throwable)e);
                    throw new LifecycleException("Can't parse yaml config " + this.configPath, (Throwable)e1);
                }
            }
        }
        try {
            return Redisson.create((Config)this.config);
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopInternal() throws LifecycleException {
        Pipeline pipeline;
        super.stopInternal();
        this.setState(LifecycleState.STOPPING);
        Pipeline pipeline2 = pipeline = this.getContainer().getPipeline();
        synchronized (pipeline2) {
            if (this.readMode == ReadMode.REDIS) {
                Arrays.stream(pipeline.getValves()).filter(v -> v.getClass() == UsageValve.class).forEach(v -> {
                    if (((UsageValve)((Object)v)).decUsage() == 0) {
                        pipeline.removeValve(v);
                    }
                });
            }
            if (this.updateMode == UpdateMode.AFTER_REQUEST) {
                Arrays.stream(pipeline.getValves()).filter(v -> v.getClass() == UpdateValve.class).forEach(v -> {
                    if (((UpdateValve)((Object)v)).decUsage() == 0) {
                        pipeline.removeValve(v);
                    }
                });
            }
        }
        if (this.messageListener != null) {
            RTopic updatesTopic = this.getTopic();
            updatesTopic.removeListener(this.messageListener);
        }
        this.codecToUse = null;
        try {
            this.shutdownRedisson();
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    protected void shutdownRedisson() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }

    public void store(HttpSession session) throws IOException {
        if (session == null) {
            return;
        }
        RedissonSession sess = (RedissonSession)super.findSession(session.getId());
        if (sess != null) {
            sess.superAccess();
            sess.superEndAccess();
            sess.save();
        }
    }

    private /* synthetic */ void lambda$createEmptySession$0(Session session, SessionEvent event) {
        if (event.getType().equals("destroySession")) {
            this.getTopic().publish((Object)new SessionDestroyedMessage(this.getNodeId(), session.getId()));
        }
    }

    public static enum ReadMode {
        REDIS,
        MEMORY;

    }

    public static enum UpdateMode {
        DEFAULT,
        AFTER_REQUEST;

    }
}

