/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.File;
import java.io.IOException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.tomcat.RedissonSession;

public class RedissonSessionManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(RedissonSessionManager.class);
    private RedissonClient redisson;
    private String configPath;

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getName() {
        return RedissonSessionManager.class.getSimpleName();
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public Session createSession(String sessionId) {
        RedissonSession session = (RedissonSession)this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(((Context)this.getContainer()).getSessionTimeout() * 60);
        if (sessionId == null) {
            sessionId = this.generateSessionId();
        }
        session.setId(sessionId);
        session.save();
        return session;
    }

    public RMap<String, Object> getMap(String sessionId) {
        return this.redisson.getMap("redisson_tomcat_session:" + sessionId);
    }

    public Session findSession(String id) throws IOException {
        Session result = super.findSession(id);
        if (result == null && id != null) {
            RedissonSession session = (RedissonSession)this.createEmptySession();
            session.setId(id);
            session.load();
            return session;
        }
        return result;
    }

    public Session createEmptySession() {
        return new RedissonSession(this);
    }

    public void remove(Session session) {
        super.remove(session);
        this.getMap(session.getId()).delete();
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        Config config = null;
        try {
            config = Config.fromJSON((File)new File(this.configPath), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            try {
                config = Config.fromYAML((File)new File(this.configPath), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (IOException e1) {
                this.log.error((Object)("Can't parse json config " + this.configPath), (Throwable)e);
                throw new LifecycleException("Can't parse yaml config " + this.configPath, (Throwable)e1);
            }
        }
        try {
            this.redisson = Redisson.create((Config)config);
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
        this.setState(LifecycleState.STARTING);
    }

    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.setState(LifecycleState.STOPPING);
        try {
            if (this.redisson != null) {
                this.redisson.shutdown();
            }
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }
}

