/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.ManagerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.api.RMap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;
import org.redisson.tomcat.AttributeMessage;
import org.redisson.tomcat.AttributeRemoveMessage;
import org.redisson.tomcat.AttributeUpdateMessage;
import org.redisson.tomcat.AttributesClearMessage;
import org.redisson.tomcat.AttributesPutAllMessage;
import org.redisson.tomcat.RedissonSession;
import org.redisson.tomcat.UpdateValve;

public class RedissonSessionManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(RedissonSessionManager.class);
    private RedissonClient redisson;
    private String configPath;
    private ReadMode readMode = ReadMode.MEMORY;
    private UpdateMode updateMode = UpdateMode.DEFAULT;
    private String keyPrefix = "";

    public String getUpdateMode() {
        return this.updateMode.toString();
    }

    public void setUpdateMode(String updateMode) {
        this.updateMode = UpdateMode.valueOf(updateMode);
    }

    public String getReadMode() {
        return this.readMode.toString();
    }

    public void setReadMode(String readMode) {
        this.readMode = ReadMode.valueOf(readMode);
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public String getName() {
        return RedissonSessionManager.class.getSimpleName();
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public Session createSession(String sessionId) {
        RedissonSession session = (RedissonSession)this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(((Context)this.getContainer()).getSessionTimeout() * 60);
        if (sessionId == null) {
            sessionId = this.generateSessionId();
        }
        session.setManager((Manager)this);
        session.setId(sessionId);
        session.save();
        return session;
    }

    public RMap<String, Object> getMap(String sessionId) {
        String separator = this.keyPrefix == null || this.keyPrefix.isEmpty() ? "" : ":";
        String name = this.keyPrefix + separator + "redisson:tomcat_session:" + sessionId;
        return this.redisson.getMap(name);
    }

    public RTopic<AttributeMessage> getTopic() {
        return this.redisson.getTopic("redisson:tomcat_session_updates:" + this.container.getName());
    }

    public Session findSession(String id) throws IOException {
        Session result = super.findSession(id);
        if (result == null) {
            if (id != null) {
                Map<String, Object> attrs = new HashMap();
                attrs = this.readMode == ReadMode.MEMORY ? this.getMap(id).readAllMap() : this.getMap(id).getAll(RedissonSession.ATTRS);
                if (attrs.isEmpty() || !Boolean.valueOf(String.valueOf(attrs.get("session:isValid"))).booleanValue()) {
                    this.log.info((Object)("Session " + id + " can't be found"));
                    return null;
                }
                RedissonSession session = (RedissonSession)this.createEmptySession();
                session.setId(id);
                session.setManager((Manager)this);
                session.load(attrs);
                session.access();
                session.endAccess();
                return session;
            }
            return null;
        }
        result.access();
        result.endAccess();
        return result;
    }

    public Session createEmptySession() {
        return new RedissonSession(this, this.readMode, this.updateMode);
    }

    public void remove(Session session, boolean update) {
        super.remove(session, update);
        if (session.getIdInternal() != null) {
            ((RedissonSession)session).delete();
        }
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.redisson = this.buildClient();
        if (this.updateMode == UpdateMode.AFTER_REQUEST) {
            this.getEngine().getPipeline().addValve((Valve)new UpdateValve(this));
        }
        if (this.readMode == ReadMode.MEMORY) {
            RTopic<AttributeMessage> updatesTopic = this.getTopic();
            updatesTopic.addListener((MessageListener)new MessageListener<AttributeMessage>(){

                public void onMessage(CharSequence channel, AttributeMessage msg) {
                    try {
                        RedissonSession session = (RedissonSession)RedissonSessionManager.super.findSession(msg.getSessionId());
                        if (session != null) {
                            AttributeMessage m;
                            if (msg instanceof AttributeRemoveMessage) {
                                session.superRemoveAttributeInternal(((AttributeRemoveMessage)msg).getName(), true);
                            }
                            if (msg instanceof AttributesClearMessage) {
                                RedissonSessionManager.super.remove((Session)session, false);
                            }
                            if (msg instanceof AttributesPutAllMessage) {
                                m = (AttributesPutAllMessage)msg;
                                for (Map.Entry<String, Object> entry : ((AttributesPutAllMessage)m).getAttrs().entrySet()) {
                                    session.superSetAttribute(entry.getKey(), entry.getValue(), true);
                                }
                            }
                            if (msg instanceof AttributeUpdateMessage) {
                                m = (AttributeUpdateMessage)msg;
                                session.superSetAttribute(((AttributeUpdateMessage)m).getName(), ((AttributeUpdateMessage)m).getValue(), true);
                            }
                        }
                    }
                    catch (IOException e) {
                        RedissonSessionManager.this.log.error((Object)"Can't handle topic message", (Throwable)e);
                    }
                }
            });
        }
        this.setState(LifecycleState.STARTING);
    }

    protected RedissonClient buildClient() throws LifecycleException {
        Config config = null;
        try {
            config = Config.fromJSON((File)new File(this.configPath), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            try {
                config = Config.fromYAML((File)new File(this.configPath), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (IOException e1) {
                this.log.error((Object)("Can't parse json config " + this.configPath), (Throwable)e);
                throw new LifecycleException("Can't parse yaml config " + this.configPath, (Throwable)e1);
            }
        }
        try {
            try {
                Config c = new Config(config);
                Codec codec = (Codec)c.getCodec().getClass().getConstructor(ClassLoader.class).newInstance(Thread.currentThread().getContextClassLoader());
                config.setCodec(codec);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to initialize codec with ClassLoader parameter", e);
            }
            return Redisson.create((Config)config);
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.setState(LifecycleState.STOPPING);
        try {
            if (this.redisson != null) {
                this.redisson.shutdown();
            }
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    public void store(HttpSession session) throws IOException {
        RedissonSession sess;
        if (session == null) {
            return;
        }
        if (this.updateMode == UpdateMode.AFTER_REQUEST && (sess = (RedissonSession)super.findSession(session.getId())) != null) {
            sess.save();
        }
    }

    public static enum UpdateMode {
        DEFAULT,
        AFTER_REQUEST;

    }

    public static enum ReadMode {
        REDIS,
        MEMORY;

    }
}

