/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.Manager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.redisson.tomcat.RedissonSessionManager;

public class UpdateValve
extends ValveBase {
    private static final String ALREADY_FILTERED_NOTE = UpdateValve.class.getName() + ".ALREADY_FILTERED_NOTE";
    private final AtomicInteger usage = new AtomicInteger(1);

    public UpdateValve() {
        super(true);
    }

    public void incUsage() {
        this.usage.incrementAndGet();
    }

    public int decUsage() {
        return this.usage.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.getNext() == null) {
            return;
        }
        if (request.getNote(ALREADY_FILTERED_NOTE) == null) {
            request.setNote(ALREADY_FILTERED_NOTE, (Object)Boolean.TRUE);
            try {
                this.getNext().invoke(request, response);
            }
            finally {
                request.removeNote(ALREADY_FILTERED_NOTE);
                if (request.getContext() == null) {
                    return;
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader applicationClassLoader = request.getContext().getLoader().getClassLoader();
                    Thread.currentThread().setContextClassLoader(applicationClassLoader);
                    Manager manager = request.getContext().getManager();
                    ((RedissonSessionManager)manager).store(request.getSession(false));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
        }
        this.getNext().invoke(request, response);
    }
}

