/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveClusterKeyCommands;
import org.springframework.data.redis.connection.RedisClusterNode;
import reactor.core.publisher.Mono;

public class RedissonReactiveClusterKeyCommands
extends RedissonReactiveKeyCommands
implements ReactiveClusterKeyCommands {
    public RedissonReactiveClusterKeyCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Mono<List<ByteBuffer>> keys(RedisClusterNode node, ByteBuffer pattern) {
        Mono m = this.executorService.reactive(() -> this.executorService.readAllAsync((Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.KEYS, new Object[]{RedissonReactiveClusterKeyCommands.toByteArray(pattern)}));
        return m.map(v -> v.stream().map(t -> ByteBuffer.wrap(t.getBytes(CharsetUtil.UTF_8))).collect(Collectors.toList()));
    }

    public Mono<ByteBuffer> randomKey(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        Mono m = this.executorService.reactive(() -> this.executorService.readRandomAsync(entry, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.RANDOM_KEY, new Object[0]));
        return m.map(v -> ByteBuffer.wrap(v));
    }
}

