/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.DoubleNullSafeReplayConvertor;
import org.redisson.client.protocol.decoder.ListMultiDecoder;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.LongMultiDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.SetReactiveIterator;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.redisson.spring.data.connection.ScoredSortedListReplayDecoder;
import org.redisson.spring.data.connection.ScoredSortedSetReplayDecoder;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveZSetCommands
extends RedissonBaseReactive
implements ReactiveZSetCommands {
    private static final RedisCommand<Double> ZADD_FLOAT = new RedisCommand("ZADD", (Convertor)new DoubleNullSafeReplayConvertor());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZRANGE_ENTRY = new RedisCommand("ZRANGE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Object>> ZRANGE = new RedisCommand("ZRANGE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZREVRANGE_ENTRY = new RedisCommand("ZREVRANGE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Object>> ZREVRANGE = new RedisCommand("ZREVRANGE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZRANGEBYSCORE = new RedisCommand("ZRANGEBYSCORE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZREVRANGEBYSCORE = new RedisCommand("ZREVRANGEBYSCORE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<ListScanResult<RedisZSetCommands.Tuple>> ZSCAN = new RedisCommand("ZSCAN", (MultiDecoder)new ListMultiDecoder(new MultiDecoder[]{new LongMultiDecoder(), new ScoredSortedListReplayDecoder(), new ListScanResultReplayDecoder()}));
    private static final RedisStrictCommand<Long> ZCOUNT = new RedisStrictCommand("ZCOUNT");
    private static final RedisStrictCommand<Long> ZREMRANGEBYRANK = new RedisStrictCommand("ZREMRANGEBYRANK");
    private static final RedisStrictCommand<Long> ZREMRANGEBYSCORE = new RedisStrictCommand("ZREMRANGEBYSCORE");
    private static final RedisStrictCommand<Long> ZUNIONSTORE = new RedisStrictCommand("ZUNIONSTORE");
    private static final RedisStrictCommand<Long> ZINTERSTORE = new RedisStrictCommand("ZINTERSTORE");
    private static final RedisCommand<Set<Object>> ZRANGEBYLEX = new RedisCommand("ZRANGEBYLEX", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Object>> ZREVRANGEBYLEX = new RedisCommand("ZREVRANGEBYLEX", (MultiDecoder)new ObjectSetReplayDecoder());

    RedissonReactiveZSetCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Number>> zAdd(Publisher<ReactiveZSetCommands.ZAddCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notEmpty((Collection)command.getTuples(), (String)"Tuples must not be empty or null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            ArrayList<Object> params = new ArrayList<Object>(command.getTuples().size() * 2 + 1);
            params.add(keyBuf);
            if (command.isIncr() || command.isUpsert() || command.isReturnTotalChanged()) {
                if (command.isUpsert()) {
                    params.add("NX");
                } else {
                    params.add("XX");
                }
                if (command.isReturnTotalChanged()) {
                    params.add("CH");
                }
                if (command.isIncr()) {
                    params.add("INCR");
                }
            }
            for (RedisZSetCommands.Tuple entry : command.getTuples()) {
                params.add(BigDecimal.valueOf(entry.getScore()).toPlainString());
                params.add(entry.getValue());
            }
            Mono m = command.isIncr() ? this.write(keyBuf, (Codec)DoubleCodec.INSTANCE, ZADD_FLOAT, params.toArray()) : this.write(keyBuf, (Codec)StringCodec.INSTANCE, RedisCommands.ZADD, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>> zRem(Publisher<ReactiveZSetCommands.ZRemCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValues(), (String)"Values must not be null!");
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getValues().size() + 1);
            args.add(RedissonReactiveZSetCommands.toByteArray(command.getKey()));
            args.addAll(command.getValues().stream().map(v -> RedissonReactiveZSetCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write((byte[])args.get(0), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZREM_LONG, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>> zIncrBy(Publisher<ReactiveZSetCommands.ZIncrByCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Member must not be null!");
            Assert.notNull((Object)command.getIncrement(), (String)"Increment value must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveZSetCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)DoubleCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZINCRBY, keyBuf, new BigDecimal(command.getIncrement().doubleValue()).toPlainString(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>> zRank(Publisher<ReactiveZSetCommands.ZRankCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Member must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveZSetCommands.toByteArray(command.getValue());
            RedisStrictCommand cmd = RedisCommands.ZRANK;
            if (command.getDirection() == Sort.Direction.DESC) {
                cmd = RedisCommands.ZREVRANK;
            }
            Mono m = this.read(keyBuf, (Codec)DoubleCodec.INSTANCE, (RedisCommand<?>)cmd, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux<RedisZSetCommands.Tuple>>> zRange(Publisher<ReactiveZSetCommands.ZRangeCommand> commands) {
        return this.execute(commands, command -> {
            Flux flux;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            long start = command.getRange().getLowerBound().getValue().orElse(0L);
            long end = (Long)command.getRange().getUpperBound().getValue().get();
            if (command.getDirection() == Sort.Direction.ASC) {
                if (command.isWithScores()) {
                    Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGE_ENTRY, keyBuf, start, end, "WITHSCORES");
                    flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
                } else {
                    Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGE, keyBuf, start, end);
                    flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(b -> new DefaultTuple(b, Double.valueOf(Double.NaN))));
                }
            } else if (command.isWithScores()) {
                Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGE_ENTRY, keyBuf, start, end, "WITHSCORES");
                flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            } else {
                Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGE, keyBuf, start, end);
                flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(b -> new DefaultTuple(b, Double.valueOf(Double.NaN))));
            }
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux<RedisZSetCommands.Tuple>>> zRangeByScore(Publisher<ReactiveZSetCommands.ZRangeByScoreCommand> commands) {
        return this.execute(commands, command -> {
            Flux flux;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            String start = this.toLowerBound(command.getRange(), "-inf");
            String end = this.toUpperBound(command.getRange(), "+inf");
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(keyBuf);
            if (command.getDirection() == Sort.Direction.ASC) {
                args.add(start);
            } else {
                args.add(end);
            }
            if (command.getDirection() == Sort.Direction.ASC) {
                args.add(end);
            } else {
                args.add(start);
            }
            if (command.isWithScores()) {
                args.add("WITHSCORES");
            }
            if (command.getLimit().isPresent() && !((RedisZSetCommands.Limit)command.getLimit().get()).isUnlimited()) {
                args.add("LIMIT");
                args.add(((RedisZSetCommands.Limit)command.getLimit().get()).getOffset());
                args.add(((RedisZSetCommands.Limit)command.getLimit().get()).getCount());
            }
            if (command.getDirection() == Sort.Direction.ASC) {
                if (command.isWithScores()) {
                    Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYSCORE, args.toArray());
                    flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
                } else {
                    Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZRANGEBYSCORE, args.toArray());
                    flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(b -> new DefaultTuple(b, Double.valueOf(Double.NaN))));
                }
            } else if (command.isWithScores()) {
                Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYSCORE, args.toArray());
                flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            } else {
                Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZREVRANGEBYSCORE, args.toArray());
                flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(b -> new DefaultTuple(b, Double.valueOf(Double.NaN))));
            }
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<RedisZSetCommands.Tuple>>> zScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getOptions(), (String)"ScanOptions must not be null!");
            final byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Flux flux = Flux.create((Consumer)new SetReactiveIterator<RedisZSetCommands.Tuple>(){

                protected RFuture<ListScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                    if (command.getOptions().getPattern() == null) {
                        return RedissonReactiveZSetCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZSCAN, new Object[]{keyBuf, nextIterPos, "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L)});
                    }
                    return RedissonReactiveZSetCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZSCAN, new Object[]{keyBuf, nextIterPos, "MATCH", command.getOptions().getPattern(), "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L)});
                }
            });
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    String toLowerBound(Range range, Object defaultValue) {
        StringBuilder s = new StringBuilder();
        if (!range.getLowerBound().isInclusive()) {
            s.append("(");
        }
        if (!range.getLowerBound().getValue().isPresent() || range.getLowerBound().getValue().get().toString().isEmpty()) {
            s.append(defaultValue);
        } else {
            s.append(range.getLowerBound().getValue().get());
        }
        return s.toString();
    }

    String toUpperBound(Range range, Object defaultValue) {
        StringBuilder s = new StringBuilder();
        if (!range.getUpperBound().isInclusive()) {
            s.append("(");
        }
        if (!range.getUpperBound().getValue().isPresent() || range.getUpperBound().getValue().get().toString().isEmpty()) {
            s.append(defaultValue);
        } else {
            s.append(range.getUpperBound().getValue().get());
        }
        return s.toString();
    }

    String toLexLowerBound(Range range, Object defaultValue) {
        StringBuilder s = new StringBuilder();
        if (range.getLowerBound().isInclusive()) {
            s.append("[");
        } else {
            s.append("(");
        }
        if (!range.getLowerBound().getValue().isPresent() || range.getLowerBound().getValue().get().toString().isEmpty()) {
            s.append(defaultValue);
        } else {
            s.append(range.getLowerBound().getValue().get());
        }
        return s.toString();
    }

    String toLexUpperBound(Range range, Object defaultValue) {
        StringBuilder s = new StringBuilder();
        if (range.getUpperBound().isInclusive()) {
            s.append("[");
        } else {
            s.append("(");
        }
        if (!range.getUpperBound().getValue().isPresent() || range.getUpperBound().getValue().get().toString().isEmpty()) {
            s.append(defaultValue);
        } else {
            s.append(range.getUpperBound().getValue().get());
        }
        return s.toString();
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>> zCount(Publisher<ReactiveZSetCommands.ZCountCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZCOUNT, keyBuf, this.toLowerBound(command.getRange(), 0), this.toUpperBound(command.getRange(), -1));
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> zCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZCARD, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>> zScore(Publisher<ReactiveZSetCommands.ZScoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveZSetCommands.toByteArray(command.getValue());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZSCORE, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>> zRemRangeByRank(Publisher<ReactiveZSetCommands.ZRemRangeByRankCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYRANK, keyBuf, command.getRange().getLowerBound().getValue().orElse(0L), command.getRange().getUpperBound().getValue().get());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>> zRemRangeByScore(Publisher<ReactiveZSetCommands.ZRemRangeByScoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYSCORE, keyBuf, this.toLowerBound(command.getRange(), 0), this.toUpperBound(command.getRange(), -1));
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZUnionStoreCommand, Long>> zUnionStore(Publisher<ReactiveZSetCommands.ZUnionStoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Assert.notEmpty((Collection)command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            ArrayList<Object> args = new ArrayList<Object>(command.getSourceKeys().size() * 2 + 5);
            args.add(keyBuf);
            args.add(command.getSourceKeys().size());
            args.addAll(command.getSourceKeys().stream().map(e -> RedissonReactiveZSetCommands.toByteArray(e)).collect(Collectors.toList()));
            if (!command.getWeights().isEmpty()) {
                args.add("WEIGHTS");
                for (Double weight : command.getWeights()) {
                    args.add(BigDecimal.valueOf(weight).toPlainString());
                }
            }
            if (command.getAggregateFunction().isPresent()) {
                args.add("AGGREGATE");
                args.add(((RedisZSetCommands.Aggregate)command.getAggregateFunction().get()).name());
            }
            Mono m = this.write(keyBuf, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)ZUNIONSTORE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZInterStoreCommand, Long>> zInterStore(Publisher<ReactiveZSetCommands.ZInterStoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Assert.notEmpty((Collection)command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            ArrayList<Object> args = new ArrayList<Object>(command.getSourceKeys().size() * 2 + 5);
            args.add(keyBuf);
            args.add(command.getSourceKeys().size());
            args.addAll(command.getSourceKeys().stream().map(e -> RedissonReactiveZSetCommands.toByteArray(e)).collect(Collectors.toList()));
            if (!command.getWeights().isEmpty()) {
                args.add("WEIGHTS");
                for (Double weight : command.getWeights()) {
                    args.add(BigDecimal.valueOf(weight).toPlainString());
                }
            }
            if (command.getAggregateFunction().isPresent()) {
                args.add("AGGREGATE");
                args.add(((RedisZSetCommands.Aggregate)command.getAggregateFunction().get()).name());
            }
            Mono m = this.write(keyBuf, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)ZINTERSTORE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByLexCommand, Flux<ByteBuffer>>> zRangeByLex(Publisher<ReactiveZSetCommands.ZRangeByLexCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            String start = null;
            String end = null;
            if (command.getDirection() == Sort.Direction.ASC) {
                start = this.toLexLowerBound(command.getRange(), "-");
                end = this.toLexUpperBound(command.getRange(), "+");
            } else {
                start = this.toLexUpperBound(command.getRange(), "-");
                end = this.toLexLowerBound(command.getRange(), "+");
            }
            Mono m = !command.getLimit().isUnlimited() ? (command.getDirection() == Sort.Direction.ASC ? this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYLEX, keyBuf, start, end, "LIMIT", command.getLimit().getOffset(), command.getLimit().getCount()) : this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYLEX, keyBuf, start, end, "LIMIT", command.getLimit().getOffset(), command.getLimit().getCount())) : (command.getDirection() == Sort.Direction.ASC ? this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYLEX, keyBuf, start, end) : this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYLEX, keyBuf, start, end));
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(v -> ByteBuffer.wrap(v)));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }
}

