/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveStringCommands
extends RedissonBaseReactive
implements ReactiveStringCommands {
    private static final RedisCommand<Boolean> SET = new RedisCommand("SET", (Convertor)new BooleanReplayConvertor());
    private static final RedisCommand<Boolean> SETEX = new RedisCommand("SETEX", (Convertor)new BooleanReplayConvertor());
    private static final RedisCommand<String> PSETEX = new RedisCommand("PSETEX");
    private static final RedisCommand<Boolean> MSET = new RedisCommand("MSET", (Convertor)new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> APPEND = new RedisStrictCommand("APPEND");
    private static final RedisCommand<Object> GETRANGE = new RedisCommand("GETRANGE");
    private static final RedisCommand<Long> SETRANGE = new RedisCommand("SETRANGE");
    private static final RedisStrictCommand<Long> BITOP = new RedisStrictCommand("BITOP");

    RedissonReactiveStringCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> set(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            byte[] key = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] value = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono m = Mono.empty();
            if (!command.getExpiration().isPresent()) {
                m = this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value);
            } else if (((Expiration)command.getExpiration().get()).isPersistent()) {
                if (!command.getOption().isPresent() || command.getOption().get() == RedisStringCommands.SetOption.UPSERT) {
                    m = this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value);
                }
                if (command.getOption().get() == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                    m = this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "NX");
                }
                if (command.getOption().get() == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                    m = this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "XX");
                }
            } else {
                if (!command.getOption().isPresent() || command.getOption().get() == RedisStringCommands.SetOption.UPSERT) {
                    m = this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "PX", ((Expiration)command.getExpiration().get()).getExpirationTimeInMilliseconds());
                }
                if (command.getOption().get() == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                    m = this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "PX", ((Expiration)command.getExpiration().get()).getExpirationTimeInMilliseconds(), "NX");
                }
                if (command.getOption().get() == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                    m = this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "PX", ((Expiration)command.getExpiration().get()).getExpirationTimeInMilliseconds(), "XX");
                }
            }
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v)).switchIfEmpty(Mono.just((Object)new ReactiveRedisConnection.BooleanResponse(command, Boolean.FALSE)));
        });
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> get(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse(command, ByteBuffer.wrap(v))).defaultIfEmpty((Object)new ReactiveRedisConnection.AbsentByteBufferResponse(command));
        });
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.SetCommand>> getSet(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            if (command.getExpiration().isPresent() || command.getOption().isPresent()) {
                throw new IllegalArgumentException("Command must not define expiration nor option for GETSET.");
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GETSET, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse(command, ByteBuffer.wrap(v)));
        });
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<List<ByteBuffer>, ByteBuffer>> mGet(Publisher<List<ByteBuffer>> keysets) {
        return this.execute(keysets, coll -> {
            Assert.notNull((Object)coll, (String)"List must not be null!");
            Object[] params = coll.stream().map(buf -> RedissonReactiveStringCommands.toByteArray(buf)).toArray(Object[]::new);
            Mono m = this.read(null, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.MGET, params);
            return m.map(v -> {
                List values = v.stream().map(array -> {
                    if (array == null) {
                        return ByteBuffer.allocate(0);
                    }
                    return ByteBuffer.wrap(array);
                }).collect(Collectors.toList());
                return new ReactiveRedisConnection.MultiValueResponse(coll, values);
            });
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> setNX(Publisher<ReactiveStringCommands.SetCommand> values) {
        return this.execute(values, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            if (command.getExpiration().isPresent() || command.getOption().isPresent()) {
                throw new IllegalArgumentException("Command must not define expiration nor option for GETSET.");
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, RedisCommands.SETNX, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> setEX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            if (!command.getExpiration().isPresent()) {
                throw new IllegalArgumentException("Expiration must not be null!");
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, SETEX, keyBuf, ((Expiration)command.getExpiration().get()).getExpirationTimeInSeconds(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> pSetEX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            if (!command.getExpiration().isPresent()) {
                throw new IllegalArgumentException("Expiration must not be null!");
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, PSETEX, keyBuf, ((Expiration)command.getExpiration().get()).getExpirationTimeInMilliseconds(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, Boolean.valueOf(true)));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>> mSet(Publisher<ReactiveStringCommands.MSetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKeyValuePairs(), (String)"KeyValuePairs must not be null!");
            List<byte[]> params = this.convert((ReactiveStringCommands.MSetCommand)command);
            Mono m = this.write(params.get(0), (Codec)StringCodec.INSTANCE, MSET, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    protected List<byte[]> convert(ReactiveStringCommands.MSetCommand command) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(command.getKeyValuePairs().size());
        command.getKeyValuePairs().entrySet().forEach(e -> {
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray((ByteBuffer)e.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray((ByteBuffer)e.getValue());
            params.add(keyBuf);
            params.add(valueBuf);
        });
        return params;
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>> mSetNX(Publisher<ReactiveStringCommands.MSetCommand> source) {
        return this.execute(source, command -> {
            Assert.notNull((Object)command.getKeyValuePairs(), (String)"KeyValuePairs must not be null!");
            List<byte[]> params = this.convert((ReactiveStringCommands.MSetCommand)command);
            Mono m = this.write(params.get(0), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.MSETNX, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.AppendCommand, Long>> append(Publisher<ReactiveStringCommands.AppendCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)APPEND, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.RangeCommand>> getRange(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, GETRANGE, keyBuf, command.getRange().getLowerBound().getValue().orElse(0L), command.getRange().getUpperBound().getValue().orElse(-1L));
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse(command, ByteBuffer.wrap(v)));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.SetRangeCommand, Long>> setRange(Publisher<ReactiveStringCommands.SetRangeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            Assert.notNull((Object)command.getOffset(), (String)"Offset must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, SETRANGE, keyBuf, command.getOffset(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.GetBitCommand>> getBit(Publisher<ReactiveStringCommands.GetBitCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getOffset(), (String)"Offset must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.GETBIT, keyBuf, command.getOffset());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetBitCommand>> setBit(Publisher<ReactiveStringCommands.SetBitCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getOffset(), (String)"Offset must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.SETBIT, keyBuf, command.getOffset(), command.getValue() ? 1 : 0);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitCountCommand, Long>> bitCount(Publisher<ReactiveStringCommands.BitCountCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Range range = command.getRange();
            if (range == null) {
                range = Range.unbounded();
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono m = range == Range.unbounded() ? this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.BITCOUNT, new Object[]{keyBuf}) : this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.BITCOUNT, keyBuf, range.getLowerBound().getValue().orElse(0L), range.getUpperBound().getValue().get());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitOpCommand, Long>> bitOp(Publisher<ReactiveStringCommands.BitOpCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getDestinationKey(), (String)"DestinationKey must not be null!");
            Assert.notEmpty((Collection)command.getKeys(), (String)"Keys must not be null or empty");
            if (command.getBitOp() == RedisStringCommands.BitOperation.NOT && command.getKeys().size() > 1) {
                throw new UnsupportedOperationException("NOT operation doesn't support more than single source key");
            }
            ArrayList<Object> params = new ArrayList<Object>(command.getKeys().size() + 2);
            params.add(command.getBitOp());
            params.add(RedissonReactiveStringCommands.toByteArray(command.getDestinationKey()));
            params.addAll(command.getKeys().stream().map(v -> RedissonReactiveStringCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write(RedissonReactiveStringCommands.toByteArray(command.getDestinationKey()), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)BITOP, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> strLen(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.STRLEN, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }
}

