/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.redisson.Redisson;
import org.redisson.SlotCallback;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisException;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.DoubleReplayConvertor;
import org.redisson.client.protocol.convertor.VoidReplayConvertor;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.GeoDistanceDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.LongMultiDecoder;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.client.protocol.decoder.TimeLongObjectDecoder;
import org.redisson.command.CommandAsyncService;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.spring.data.connection.BinaryConvertor;
import org.redisson.spring.data.connection.DataTypeConvertor;
import org.redisson.spring.data.connection.DistanceConvertor;
import org.redisson.spring.data.connection.GeoResultsDecoder;
import org.redisson.spring.data.connection.ObjectListReplayDecoder2;
import org.redisson.spring.data.connection.PointDecoder;
import org.redisson.spring.data.connection.PropertiesDecoder;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.data.connection.RedissonSubscription;
import org.redisson.spring.data.connection.ScoredSortedListReplayDecoder;
import org.redisson.spring.data.connection.ScoredSortedSetReplayDecoder;
import org.redisson.spring.data.connection.SecondsConvertor;
import org.redisson.spring.data.connection.SetReplayDecoder;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class RedissonConnection
extends AbstractRedisConnection {
    private boolean closed;
    protected final Redisson redisson;
    CommandAsyncService executorService;
    private RedissonSubscription subscription;
    private static final RedisStrictCommand<DataType> TYPE = new RedisStrictCommand("TYPE", (Convertor)new DataTypeConvertor());
    private static final RedisStrictCommand<Set<byte[]>> KEYS = new RedisStrictCommand("KEYS", new SetReplayDecoder((Decoder<Object>)ByteArrayCodec.INSTANCE.getValueDecoder()));
    private static final RedisStrictCommand<Boolean> EXPIRE = new RedisStrictCommand("EXPIRE", (Convertor)new BooleanReplayConvertor());
    private static final RedisStrictCommand<Boolean> EXPIREAT = new RedisStrictCommand("EXPIREAT", (Convertor)new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> TTL = new RedisStrictCommand("TTL");
    private static final RedisCommand<Long> SORT_TO = new RedisCommand("SORT");
    private static final RedisCommand<List<Object>> MGET = new RedisCommand("MGET", (MultiDecoder)new ObjectListReplayDecoder());
    RedisCommand<Void> SETEX = new RedisCommand("SETEX", (Convertor)new VoidReplayConvertor());
    private static final RedisStrictCommand<Long> DECRBY = new RedisStrictCommand("DECRBY");
    private static final RedisStrictCommand<Long> APPEND = new RedisStrictCommand("APPEND");
    private static final RedisCommand<Object> GETRANGE = new RedisCommand("GETRANGE");
    private static final RedisCommand<Void> SETRANGE = new RedisCommand("SETRANGE", (Convertor)new VoidReplayConvertor());
    private static final RedisStrictCommand<Long> BITOP = new RedisStrictCommand("BITOP");
    private static final RedisStrictCommand<Long> RPUSH = new RedisStrictCommand("RPUSH");
    private static final RedisStrictCommand<Integer> LPUSH = new RedisStrictCommand("LPUSH");
    private static final RedisStrictCommand<Integer> RPUSHX = new RedisStrictCommand("RPUSHX");
    private static final RedisStrictCommand<Integer> LPUSHX = new RedisStrictCommand("LPUSHX");
    private static final RedisStrictCommand<Long> LLEN = new RedisStrictCommand("LLEN");
    private static final RedisStrictCommand<Long> LINSERT = new RedisStrictCommand("LINSERT");
    private final List<String> commandsToRemove = Arrays.asList("SET", "RESTORE", "LTRIM", "SETEX", "SETRANGE", "FLUSHDB", "LSET", "MSET", "HMSET", "RENAME");
    private final List<Integer> indexToRemove = new ArrayList<Integer>();
    private int index = -1;
    private static final RedisStrictCommand<Long> LREM = new RedisStrictCommand("LREM");
    private static final RedisCommand<Long> SADD = new RedisCommand("SADD");
    private static final RedisStrictCommand<Long> SREM = new RedisStrictCommand("SREM");
    private static final RedisStrictCommand<Long> SCARD = new RedisStrictCommand("SCARD");
    private static final RedisCommand<Set<Object>> ZRANGE = new RedisCommand("ZRANGE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZRANGE_ENTRY = new RedisCommand("ZRANGE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZRANGEBYSCORE = new RedisCommand("ZRANGEBYSCORE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Object>> ZREVRANGE = new RedisCommand("ZREVRANGE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZREVRANGE_ENTRY = new RedisCommand("ZREVRANGE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<byte[]>> ZREVRANGEBYSCORE = new RedisCommand("ZREVRANGEBYSCORE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZREVRANGEBYSCOREWITHSCORES = new RedisCommand("ZREVRANGEBYSCORE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisStrictCommand<Long> ZREMRANGEBYRANK = new RedisStrictCommand("ZREMRANGEBYRANK");
    private static final RedisStrictCommand<Long> ZREMRANGEBYSCORE = new RedisStrictCommand("ZREMRANGEBYSCORE");
    private static final RedisStrictCommand<Long> ZUNIONSTORE = new RedisStrictCommand("ZUNIONSTORE");
    private static final RedisStrictCommand<Long> ZINTERSTORE = new RedisStrictCommand("ZINTERSTORE");
    private static final RedisCommand<ListScanResult<Object>> ZSCAN = new RedisCommand("ZSCAN", (MultiDecoder)new ListMultiDecoder(new MultiDecoder[]{new LongMultiDecoder(), new ScoredSortedListReplayDecoder(), new ListScanResultReplayDecoder()}));
    private static final RedisCommand<Set<Object>> ZRANGEBYLEX = new RedisCommand("ZRANGEBYLEX", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<List<Object>> HMGET = new RedisCommand("HMGET", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<Long> HINCRBY = new RedisCommand("HINCRBY");
    private static final RedisCommand<Double> HINCRBYFLOAT = new RedisCommand("HINCRBYFLOAT", (Convertor)new DoubleReplayConvertor());
    private static final RedisStrictCommand<Long> HLEN = new RedisStrictCommand("HLEN");
    private static final RedisCommand<Object> ECHO = new RedisCommand("ECHO");
    private static final RedisStrictCommand<Void> SAVE = new RedisStrictCommand("SAVE", (Convertor)new VoidReplayConvertor());
    private static final RedisStrictCommand<Properties> INFO_DEFAULT = new RedisStrictCommand("INFO", "DEFAULT", (Decoder)new PropertiesDecoder());
    private static final RedisStrictCommand<Properties> INFO = new RedisStrictCommand("INFO", (Decoder)new PropertiesDecoder());
    private static final RedisStrictCommand<Long> TIME = new RedisStrictCommand("TIME", (MultiDecoder)new TimeLongObjectDecoder());
    private static final RedisCommand<List<Object>> GEOHASH = new RedisCommand("GEOHASH", (MultiDecoder)new ObjectListReplayDecoder());
    private final MultiDecoder<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> postitionDecoder = new ListMultiDecoder(new MultiDecoder[]{new CodecDecoder(), new PointDecoder(), new ObjectListReplayDecoder(ListMultiDecoder.RESET), new GeoResultsDecoder()});
    private static final RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> GEORADIUSBYMEMBER = new RedisCommand("GEORADIUSBYMEMBER", (MultiDecoder)new GeoResultsDecoder());
    private static final RedisCommand<Long> PFADD = new RedisCommand("PFADD");

    public RedissonConnection(RedissonClient redisson) {
        this.redisson = (Redisson)redisson;
        this.executorService = (CommandAsyncService)this.redisson.getCommandExecutor();
    }

    public void close() throws DataAccessException {
        super.close();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Object getNativeConnection() {
        return this.redisson;
    }

    public boolean isQueueing() {
        if (this.executorService instanceof CommandBatchService) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            return es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC;
        }
        return false;
    }

    public boolean isPipelined() {
        if (this.executorService instanceof CommandBatchService) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            return es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.IN_MEMORY || es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC;
        }
        return false;
    }

    public boolean isPipelinedAtomic() {
        if (this.executorService instanceof CommandBatchService) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            return es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC;
        }
        return false;
    }

    public void openPipeline() {
        BatchOptions options = BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.IN_MEMORY);
        this.executorService = new CommandBatchService(this.redisson.getConnectionManager(), options);
    }

    public List<Object> closePipeline() throws RedisPipelineException {
        if (this.isPipelined()) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            try {
                BatchResult result = es.execute();
                this.filterResults(result);
                if (this.isPipelinedAtomic()) {
                    List<Object> list = Arrays.asList(result.getResponses());
                    return list;
                }
                List list = result.getResponses();
                return list;
            }
            catch (Exception ex) {
                throw new RedisPipelineException(ex);
            }
            finally {
                this.resetConnection();
            }
        }
        return Collections.emptyList();
    }

    public Object execute(String command, byte[] ... args) {
        for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
            if (!method.getName().equalsIgnoreCase(command) || !Modifier.isPublic(method.getModifiers())) continue;
            try {
                Object t = this.execute(method, args);
                if (t instanceof String) {
                    return ((String)t).getBytes();
                }
                return t;
            }
            catch (IllegalArgumentException e) {
                if (this.isPipelined()) {
                    throw new RedisPipelineException((Exception)e);
                }
                throw new InvalidDataAccessApiUsageException(e.getMessage(), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Object execute(Method method, byte[] ... args) {
        if (method.getParameterTypes().length > 0 && method.getParameterTypes()[0] == byte[][].class) {
            return ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])args);
        }
        if (args == null) {
            return ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this));
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])Arrays.asList(args).toArray());
    }

    <V> V syncFuture(RFuture<V> future) {
        try {
            return (V)this.executorService.get(future);
        }
        catch (Exception ex) {
            throw this.transform(ex);
        }
    }

    protected RuntimeException transform(Exception ex) {
        DataAccessException exception = RedissonConnectionFactory.EXCEPTION_TRANSLATION.translate(ex);
        if (exception != null) {
            return exception;
        }
        return new RedisSystemException(ex.getMessage(), (Throwable)ex);
    }

    public Boolean exists(byte[] key) {
        return (Boolean)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.EXISTS, new Object[]{key});
    }

    private void checkExecution(RPromise<Long> result, AtomicReference<Throwable> failed, AtomicLong count, AtomicLong executed) {
        if (executed.decrementAndGet() == 0L) {
            if (failed.get() != null) {
                if (count.get() > 0L) {
                    RedisException ex = new RedisException("" + count.get() + " keys has been deleted. But one or more nodes has an error", failed.get());
                    result.tryFailure((Throwable)ex);
                } else {
                    result.tryFailure(failed.get());
                }
            } else {
                result.trySuccess((Object)count.get());
            }
        }
    }

    private RFuture<Long> executeAsync(RedisStrictCommand<Long> command, byte[] ... keys) {
        if (!this.executorService.getConnectionManager().isClusterMode()) {
            return this.executorService.writeAsync(null, command, Arrays.asList(keys).toArray());
        }
        HashMap<MasterSlaveEntry, ArrayList<byte[]>> range2key = new HashMap<MasterSlaveEntry, ArrayList<byte[]>>();
        for (byte[] key : keys) {
            int slot = this.executorService.getConnectionManager().calcSlot(key);
            MasterSlaveEntry entry = this.executorService.getConnectionManager().getEntry(slot);
            ArrayList<byte[]> list = (ArrayList<byte[]>)range2key.get(entry);
            if (list == null) {
                list = new ArrayList<byte[]>();
                range2key.put(entry, list);
            }
            list.add(key);
        }
        RedissonPromise result = new RedissonPromise();
        final AtomicReference failed = new AtomicReference();
        final AtomicLong count = new AtomicLong();
        AtomicLong executed = new AtomicLong(range2key.size());
        BiConsumer listener = new BiConsumer<List<?>, Throwable>((RPromise)result, executed){
            final /* synthetic */ RPromise val$result;
            final /* synthetic */ AtomicLong val$executed;
            {
                this.val$result = rPromise;
                this.val$executed = atomicLong2;
            }

            @Override
            public void accept(List<?> r, Throwable u) {
                if (u == null) {
                    List<?> result = r;
                    for (Long res : result) {
                        if (res == null) continue;
                        count.addAndGet(res);
                    }
                } else {
                    failed.set(u);
                }
                RedissonConnection.this.checkExecution((RPromise<Long>)this.val$result, failed, count, this.val$executed);
            }
        };
        for (Map.Entry entry : range2key.entrySet()) {
            CommandBatchService es = new CommandBatchService(this.executorService.getConnectionManager());
            for (byte[] key : (List)entry.getValue()) {
                es.writeAsync((MasterSlaveEntry)entry.getKey(), null, command, new Object[]{key});
            }
            RFuture future = es.executeAsync();
            future.onComplete(listener);
        }
        return result;
    }

    public Long del(byte[] ... keys) {
        RFuture<Long> f = this.executeAsync((RedisStrictCommand<Long>)RedisCommands.DEL, keys);
        return this.sync(f);
    }

    public DataType type(byte[] key) {
        return (DataType)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)TYPE, new Object[]{key});
    }

    public Set<byte[]> keys(byte[] pattern) {
        if (this.isQueueing()) {
            return (Set)this.read(null, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand<?>)KEYS, new Object[]{pattern});
        }
        HashSet results = new HashSet();
        RFuture f = this.executorService.readAllAsync(results, (Codec)ByteArrayCodec.INSTANCE, KEYS, new Object[]{pattern});
        return (Set)this.sync(f);
    }

    public Cursor<byte[]> scan(ScanOptions options) {
        return new ScanCursor<byte[]>(0L, options){
            private RedisClient client;
            private Iterator<MasterSlaveEntry> entries;
            private MasterSlaveEntry entry;
            {
                this.entries = RedissonConnection.this.redisson.getConnectionManager().getEntrySet().iterator();
                this.entry = this.entries.next();
            }

            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                if (this.entry == null) {
                    return null;
                }
                ArrayList<Object> args = new ArrayList<Object>();
                cursorId = Math.max(cursorId, 0L);
                args.add(cursorId);
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, this.entry, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonConnection.this.syncFuture(f);
                long pos = res.getPos();
                this.client = res.getRedisClient();
                if (pos == 0L) {
                    if (this.entries.hasNext()) {
                        pos = -1L;
                        this.entry = this.entries.next();
                    } else {
                        this.entry = null;
                    }
                }
                return new ScanIteration(pos, (Collection)res.getValues());
            }
        }.open();
    }

    public byte[] randomKey() {
        if (this.isQueueing()) {
            return (byte[])this.read(null, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand<?>)RedisCommands.RANDOM_KEY, new Object[0]);
        }
        RFuture f = this.executorService.readRandomAsync((Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.RANDOM_KEY, new Object[0]);
        return (byte[])this.sync(f);
    }

    public void rename(byte[] oldName, byte[] newName) {
        this.write(oldName, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.RENAME, oldName, newName);
    }

    public Boolean renameNX(byte[] oldName, byte[] newName) {
        return (Boolean)this.write(oldName, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.RENAMENX, oldName, newName);
    }

    public Boolean expire(byte[] key, long seconds) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIRE, key, seconds);
    }

    public Boolean pExpire(byte[] key, long millis) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PEXPIRE, key, millis);
    }

    public Boolean expireAt(byte[] key, long unixTime) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIREAT, key, unixTime);
    }

    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PEXPIREAT, key, unixTimeInMillis);
    }

    public Boolean persist(byte[] key) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PERSIST, new Object[]{key});
    }

    public Boolean move(byte[] key, int dbIndex) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.MOVE, key, dbIndex);
    }

    public Long ttl(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)TTL, new Object[]{key});
    }

    protected <T> T sync(RFuture<T> f) {
        if (this.isPipelined()) {
            return null;
        }
        if (this.isQueueing()) {
            f.syncUninterruptibly();
            return null;
        }
        return this.syncFuture(f);
    }

    public Long ttl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)new RedisStrictCommand("TTL", (Convertor)new SecondsConvertor(timeUnit, TimeUnit.SECONDS)), new Object[]{key});
    }

    public Long pTtl(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PTTL, new Object[]{key});
    }

    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)new RedisStrictCommand("PTTL", (Convertor)new SecondsConvertor(timeUnit, TimeUnit.MILLISECONDS)), new Object[]{key});
    }

    public List<byte[]> sort(byte[] key, SortParameters sortParams) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (sortParams != null) {
            Boolean isAlpha;
            if (sortParams.getByPattern() != null) {
                params.add("BY");
                params.add(sortParams.getByPattern());
            }
            if (sortParams.getLimit() != null) {
                params.add("LIMIT");
                if (sortParams.getLimit().getStart() != -1L) {
                    params.add(sortParams.getLimit().getStart());
                }
                if (sortParams.getLimit().getCount() != -1L) {
                    params.add(sortParams.getLimit().getCount());
                }
            }
            if (sortParams.getGetPattern() != null) {
                for (byte[] pattern : sortParams.getGetPattern()) {
                    params.add("GET");
                    params.add(pattern);
                }
            }
            if (sortParams.getOrder() != null) {
                params.add(sortParams.getOrder());
            }
            if ((isAlpha = sortParams.isAlphabetic()) != null && isAlpha.booleanValue()) {
                params.add("ALPHA");
            }
        }
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SORT_LIST, params.toArray());
    }

    public Long sort(byte[] key, SortParameters sortParams, byte[] storeKey) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (sortParams != null) {
            Boolean isAlpha;
            if (sortParams.getByPattern() != null) {
                params.add("BY");
                params.add(sortParams.getByPattern());
            }
            if (sortParams.getLimit() != null) {
                params.add("LIMIT");
                if (sortParams.getLimit().getStart() != -1L) {
                    params.add(sortParams.getLimit().getStart());
                }
                if (sortParams.getLimit().getCount() != -1L) {
                    params.add(sortParams.getLimit().getCount());
                }
            }
            if (sortParams.getGetPattern() != null) {
                for (byte[] pattern : sortParams.getGetPattern()) {
                    params.add("GET");
                    params.add(pattern);
                }
            }
            if (sortParams.getOrder() != null) {
                params.add(sortParams.getOrder());
            }
            if ((isAlpha = sortParams.isAlphabetic()) != null && isAlpha.booleanValue()) {
                params.add("ALPHA");
            }
        }
        params.add("STORE");
        params.add(storeKey);
        return (Long)this.read(key, (Codec)ByteArrayCodec.INSTANCE, SORT_TO, params.toArray());
    }

    public byte[] dump(byte[] key) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.DUMP, new Object[]{key});
    }

    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.RESTORE, key, ttlInMillis, serializedValue);
    }

    public byte[] get(byte[] key) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{key});
    }

    public byte[] getSet(byte[] key, byte[] value) {
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GETSET, key, value);
    }

    public List<byte[]> mGet(byte[] ... keys) {
        return (List)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, MGET, Arrays.asList(keys).toArray());
    }

    public void set(byte[] key, byte[] value) {
        this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.SET, key, value);
    }

    public void set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        if (expiration == null) {
            this.set(key, value);
        } else if (expiration.isPersistent()) {
            if (option == null || option == RedisStringCommands.SetOption.UPSERT) {
                this.set(key, value);
            }
            if (option == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.SET, key, value, "NX");
            }
            if (option == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.SET, key, value, "XX");
            }
        } else {
            if (option == null || option == RedisStringCommands.SetOption.UPSERT) {
                this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.SET, key, value, "PX", expiration.getExpirationTimeInMilliseconds());
            }
            if (option == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.SET, key, value, "PX", expiration.getExpirationTimeInMilliseconds(), "NX");
            }
            if (option == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.SET, key, value, "PX", expiration.getExpirationTimeInMilliseconds(), "XX");
            }
        }
    }

    public Boolean setNX(byte[] key, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.SETNX, key, value);
    }

    public void setEx(byte[] key, long seconds, byte[] value) {
        this.write(key, (Codec)StringCodec.INSTANCE, this.SETEX, key, seconds, value);
    }

    public void pSetEx(byte[] key, long milliseconds, byte[] value) {
        this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.PSETEX, key, milliseconds, value);
    }

    public void mSet(Map<byte[], byte[]> tuple) {
        List<byte[]> params = this.convert(tuple);
        this.write(tuple.keySet().iterator().next(), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.MSET, params.toArray());
    }

    protected List<byte[]> convert(Map<byte[], byte[]> tuple) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(tuple.size() * 2);
        for (Map.Entry<byte[], byte[]> entry : tuple.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        return params;
    }

    public Boolean mSetNX(Map<byte[], byte[]> tuple) {
        List<byte[]> params = this.convert(tuple);
        return (Boolean)this.write(tuple.keySet().iterator().next(), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.MSETNX, params.toArray());
    }

    public Long incr(byte[] key) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.INCR, new Object[]{key});
    }

    public Long incrBy(byte[] key, long value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.INCRBY, key, value);
    }

    public Double incrBy(byte[] key, double value) {
        return (Double)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.INCRBYFLOAT, key, BigDecimal.valueOf(value).toPlainString());
    }

    public Long decr(byte[] key) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.DECR, new Object[]{key});
    }

    public Long decrBy(byte[] key, long value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)DECRBY, key, value);
    }

    public Long append(byte[] key, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)APPEND, key, value);
    }

    public byte[] getRange(byte[] key, long begin, long end) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, GETRANGE, key, begin, end);
    }

    public void setRange(byte[] key, byte[] value, long offset) {
        this.write(key, (Codec)ByteArrayCodec.INSTANCE, SETRANGE, key, offset, value);
    }

    public Boolean getBit(byte[] key, long offset) {
        return (Boolean)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.GETBIT, key, offset);
    }

    public Boolean setBit(byte[] key, long offset, boolean value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.SETBIT, key, offset, value ? 1 : 0);
    }

    public Long bitCount(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.BITCOUNT, new Object[]{key});
    }

    public Long bitCount(byte[] key, long begin, long end) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.BITCOUNT, key, begin, end);
    }

    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("NOT operation doesn't support more than single source key");
        }
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 2);
        params.add(op);
        params.add(destination);
        params.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)BITOP, params.toArray());
    }

    public Long strLen(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.STRLEN, new Object[]{key});
    }

    public Long rPush(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RPUSH, args.toArray());
    }

    public Long lPush(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LPUSH, args.toArray());
    }

    public Long rPushX(byte[] key, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RPUSHX, key, value);
    }

    public Long lPushX(byte[] key, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LPUSHX, key, value);
    }

    public Long lLen(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LLEN, new Object[]{key});
    }

    public List<byte[]> lRange(byte[] key, long start, long end) {
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.LRANGE, key, start, end);
    }

    public void lTrim(byte[] key, long start, long end) {
        this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.LTRIM, key, start, end);
    }

    public byte[] lIndex(byte[] key, long index) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.LINDEX, key, index);
    }

    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LINSERT, key, where, pivot, value);
    }

    <T> T write(byte[] key, Codec codec, RedisCommand<?> command, Object ... params) {
        RFuture f = this.executorService.writeAsync(key, codec, command, params);
        this.indexCommand(command);
        return this.sync(f);
    }

    protected void indexCommand(RedisCommand<?> command) {
        if (this.isQueueing() || this.isPipelined()) {
            ++this.index;
            if (this.commandsToRemove.contains(command.getName())) {
                this.indexToRemove.add(this.index);
            }
        }
    }

    <T> T read(byte[] key, Codec codec, RedisCommand<?> command, Object ... params) {
        RFuture f = this.executorService.readAsync(key, codec, command, params);
        this.indexCommand(command);
        return this.sync(f);
    }

    public void lSet(byte[] key, long index, byte[] value) {
        this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.LSET, key, index, value);
    }

    public Long lRem(byte[] key, long count, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LREM, key, count, value);
    }

    public byte[] lPop(byte[] key) {
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.LPOP, new Object[]{key});
    }

    public byte[] rPop(byte[] key) {
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.RPOP, new Object[]{key});
    }

    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 1);
        params.addAll(Arrays.asList(keys));
        params.add(timeout);
        return (List)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, RedisCommands.BLPOP, params.toArray());
    }

    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 1);
        params.addAll(Arrays.asList(keys));
        params.add(timeout);
        return (List)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, RedisCommands.BRPOP, params.toArray());
    }

    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        return (byte[])this.write(srcKey, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.RPOPLPUSH, srcKey, dstKey);
    }

    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        return (byte[])this.write(srcKey, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.BRPOPLPUSH, srcKey, dstKey, timeout);
    }

    public Long sAdd(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, SADD, args.toArray());
    }

    public Long sRem(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)SREM, args.toArray());
    }

    public byte[] sPop(byte[] key) {
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SPOP, new Object[]{key});
    }

    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        return (Boolean)this.write(srcKey, (Codec)StringCodec.INSTANCE, RedisCommands.SMOVE, srcKey, destKey, value);
    }

    public Long sCard(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)SCARD, new Object[]{key});
    }

    public Boolean sIsMember(byte[] key, byte[] value) {
        return (Boolean)this.read(key, (Codec)StringCodec.INSTANCE, RedisCommands.SISMEMBER, key, value);
    }

    public Set<byte[]> sInter(byte[] ... keys) {
        return (Set)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SINTER, Arrays.asList(keys).toArray());
    }

    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(destKey);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.SINTERSTORE, args.toArray());
    }

    public Set<byte[]> sUnion(byte[] ... keys) {
        return (Set)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SUNION, Arrays.asList(keys).toArray());
    }

    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(destKey);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.SUNIONSTORE, args.toArray());
    }

    public Set<byte[]> sDiff(byte[] ... keys) {
        return (Set)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SDIFF, Arrays.asList(keys).toArray());
    }

    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(destKey);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.SDIFFSTORE, args.toArray());
    }

    public Set<byte[]> sMembers(byte[] key) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SMEMBERS, new Object[]{key});
    }

    public byte[] sRandMember(byte[] key) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SRANDMEMBER_SINGLE, new Object[]{key});
    }

    public List<byte[]> sRandMember(byte[] key, long count) {
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SRANDMEMBER, key, count);
    }

    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return new KeyBoundCursor<byte[]>(key, 0L, options){
            private RedisClient client;

            protected ScanIteration<byte[]> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(key);
                args.add(cursorId);
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SSCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonConnection.this.syncFuture(f);
                this.client = res.getRedisClient();
                return new ScanIteration(res.getPos(), (Collection)res.getValues());
            }
        }.open();
    }

    public Boolean zAdd(byte[] key, double score, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.ZADD_BOOL, key, BigDecimal.valueOf(score).toPlainString(), value);
    }

    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        ArrayList<Object> params = new ArrayList<Object>(tuples.size() * 2 + 1);
        params.add(key);
        for (RedisZSetCommands.Tuple entry : tuples) {
            params.add(BigDecimal.valueOf(entry.getScore()).toPlainString());
            params.add(entry.getValue());
        }
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.ZADD, params.toArray());
    }

    public Long zRem(byte[] key, byte[] ... values) {
        ArrayList<Object> params = new ArrayList<Object>(values.length + 1);
        params.add(key);
        params.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZREM_LONG, params.toArray());
    }

    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        return (Double)this.write(key, (Codec)DoubleCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZINCRBY, key, new BigDecimal(increment).toPlainString(), value);
    }

    public Long zRank(byte[] key, byte[] value) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZRANK, key, value);
    }

    public Long zRevRank(byte[] key, byte[] value) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZREVRANK, key, value);
    }

    public Set<byte[]> zRange(byte[] key, long start, long end) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGE, key, start, end);
    }

    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGE_ENTRY, key, start, end, "WITHSCORES");
    }

    private String value(Object score, boolean inclusive, String defaultValue) {
        if (score == null) {
            return defaultValue;
        }
        StringBuilder element = new StringBuilder();
        if (!inclusive) {
            element.append("(");
        } else if (!(score instanceof Double)) {
            element.append("[");
        }
        if (score instanceof Double) {
            if (Double.isInfinite((Double)score)) {
                element.append((Double)score > 0.0 ? "+inf" : "-inf");
            }
            element.append(BigDecimal.valueOf((Double)score).toPlainString());
        } else {
            element.append(score);
        }
        return element.toString();
    }

    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return this.zRangeByScore(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return this.zRangeByScoreWithScores(key, range, null);
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRangeByScoreWithScores(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max));
    }

    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScore(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max), new RedisZSetCommands.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScoreWithScores(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max), new RedisZSetCommands.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        String min = this.value(range.getMin().getValue(), range.getMin().isIncluding(), "-inf");
        String max = this.value(range.getMax().getValue(), range.getMax().isIncluding(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(min);
        args.add(max);
        args.add("WITHSCORES");
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYSCORE, args.toArray());
    }

    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGE, key, start, end);
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGE_ENTRY, key, start, end, "WITHSCORES");
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.zRevRangeByScore(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return this.zRevRangeByScore(key, range, null);
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRevRangeByScoreWithScores(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScore(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max), new RedisZSetCommands.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        String min = this.value(range.getMin().getValue(), range.getMin().isIncluding(), "-inf");
        String max = this.value(range.getMax().getValue(), range.getMax().isIncluding(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(max);
        args.add(min);
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYSCORE, args.toArray());
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScoreWithScores(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max), new RedisZSetCommands.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return this.zRevRangeByScoreWithScores(key, range, null);
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        String min = this.value(range.getMin().getValue(), range.getMin().isIncluding(), "-inf");
        String max = this.value(range.getMax().getValue(), range.getMax().isIncluding(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(max);
        args.add(min);
        args.add("WITHSCORES");
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYSCOREWITHSCORES, args.toArray());
    }

    public Long zCount(byte[] key, double min, double max) {
        return this.zCount(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max));
    }

    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        String min = this.value(range.getMin().getValue(), range.getMin().isIncluding(), "-inf");
        String max = this.value(range.getMax().getValue(), range.getMax().isIncluding(), "+inf");
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZCOUNT, key, min, max);
    }

    public Long zCard(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZCARD, new Object[]{key});
    }

    public Double zScore(byte[] key, byte[] value) {
        return (Double)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZSCORE, key, value);
    }

    public Long zRemRange(byte[] key, long start, long end) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYRANK, key, start, end);
    }

    public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.zRemRangeByScore(key, new RedisZSetCommands.Range().gte((Object)min).lte((Object)max));
    }

    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        String min = this.value(range.getMin().getValue(), range.getMin().isIncluding(), "-inf");
        String max = this.value(range.getMax().getValue(), range.getMax().isIncluding(), "+inf");
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYSCORE, key, min, max);
    }

    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        return this.zUnionStore(destKey, (RedisZSetCommands.Aggregate)null, (int[])null, sets);
    }

    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 5);
        args.add(destKey);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (int weight : weights) {
                args.add(weight);
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        return (Long)this.write(destKey, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)ZUNIONSTORE, args.toArray());
    }

    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        return this.zInterStore(destKey, (RedisZSetCommands.Aggregate)null, (int[])null, sets);
    }

    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 5);
        args.add(destKey);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (int weight : weights) {
                args.add(weight);
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        return (Long)this.write(destKey, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZINTERSTORE, args.toArray());
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return new KeyBoundCursor<RedisZSetCommands.Tuple>(key, 0L, options){
            private RedisClient client;

            protected ScanIteration<RedisZSetCommands.Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(key);
                args.add(cursorId);
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, key, (Codec)ByteArrayCodec.INSTANCE, ZSCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonConnection.this.syncFuture(f);
                this.client = res.getRedisClient();
                return new ScanIteration(res.getPos(), (Collection)res.getValues());
            }
        }.open();
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZRANGEBYSCORE, key, min, max);
    }

    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        String min = this.value(range.getMin().getValue(), range.getMin().isIncluding(), "-inf");
        String max = this.value(range.getMax().getValue(), range.getMax().isIncluding(), "+inf");
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZRANGEBYSCORE, key, min, max);
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZRANGEBYSCORE, key, min, max, "LIMIT", offset, count);
    }

    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        String min = this.value(range.getMin().getValue(), range.getMin().isIncluding(), "-inf");
        String max = this.value(range.getMax().getValue(), range.getMax().isIncluding(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(min);
        args.add(max);
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZRANGEBYSCORE, args.toArray());
    }

    public Set<byte[]> zRangeByLex(byte[] key) {
        return this.zRangeByLex(key, RedisZSetCommands.Range.unbounded());
    }

    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (range.getMin() != null) {
            String min = this.value(range.getMin().getValue(), range.getMin().isIncluding(), "-");
            params.add(min);
        } else {
            params.add("-");
        }
        if (range.getMax() != null) {
            String max = this.value(range.getMax().getValue(), range.getMax().isIncluding(), "+");
            params.add(max);
        } else {
            params.add("+");
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYLEX, params.toArray());
    }

    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        String min = this.value(range.getMin().getValue(), range.getMin().isIncluding(), "-");
        String max = this.value(range.getMax().getValue(), range.getMax().isIncluding(), "+");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(min);
        args.add(max);
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYLEX, args.toArray());
    }

    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.HSET, key, field, value);
    }

    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.HSETNX, key, field, value);
    }

    public byte[] hGet(byte[] key, byte[] field) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HGET, key, field);
    }

    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        ArrayList<Object> args = new ArrayList<Object>(fields.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(fields));
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, HMGET, args.toArray());
    }

    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(hashes.size() * 2 + 1);
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hashes.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.HMSET, params.toArray());
    }

    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, HINCRBY, key, field, delta);
    }

    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        return (Double)this.write(key, (Codec)StringCodec.INSTANCE, HINCRBYFLOAT, key, field, BigDecimal.valueOf(delta).toPlainString());
    }

    public Boolean hExists(byte[] key, byte[] field) {
        return (Boolean)this.read(key, (Codec)StringCodec.INSTANCE, RedisCommands.HEXISTS, key, field);
    }

    public Long hDel(byte[] key, byte[] ... fields) {
        ArrayList<Object> args = new ArrayList<Object>(fields.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(fields));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, RedisCommands.HDEL, args.toArray());
    }

    public Long hLen(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)HLEN, new Object[]{key});
    }

    public Set<byte[]> hKeys(byte[] key) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HKEYS, new Object[]{key});
    }

    public List<byte[]> hVals(byte[] key) {
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HVALS, new Object[]{key});
    }

    public Map<byte[], byte[]> hGetAll(byte[] key) {
        return (Map)this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HGETALL, new Object[]{key});
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, 0L, options){
            private RedisClient client;

            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'HSCAN' cannot be called in pipeline / transaction mode.");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(key);
                args.add(cursorId);
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HSCAN, args.toArray());
                MapScanResult res = (MapScanResult)RedissonConnection.this.syncFuture(f);
                this.client = res.getRedisClient();
                return new ScanIteration(res.getPos(), res.getValues());
            }
        }.open();
    }

    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        if (this.isPipelined()) {
            BatchOptions options = BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC);
            this.executorService = new CommandBatchService(this.redisson.getConnectionManager(), options);
            return;
        }
        BatchOptions options = BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC);
        this.executorService = new CommandBatchService(this.redisson.getConnectionManager(), options);
    }

    public List<Object> exec() {
        if (this.isPipelinedAtomic()) {
            return null;
        }
        if (this.isQueueing()) {
            try {
                BatchResult result = ((CommandBatchService)this.executorService).execute();
                this.filterResults(result);
                List list = result.getResponses();
                return list;
            }
            catch (Exception ex) {
                throw this.transform(ex);
            }
            finally {
                this.resetConnection();
            }
        }
        throw new InvalidDataAccessApiUsageException("Not in transaction mode. Please invoke multi method");
    }

    protected void filterResults(BatchResult<?> result) {
        int t = 0;
        for (Integer index : this.indexToRemove) {
            index = index - t;
            result.getResponses().remove(index);
            ++t;
        }
        ListIterator<byte[]> iterator = result.getResponses().listIterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.set(((String)object).getBytes());
        }
    }

    protected void resetConnection() {
        this.executorService = (CommandAsyncService)this.redisson.getCommandExecutor();
        this.index = -1;
        this.indexToRemove.clear();
    }

    public void discard() {
        if (!this.isQueueing()) {
            throw new InvalidDataAccessApiUsageException("Not in transaction mode. Please invoke multi method");
        }
        this.syncFuture(this.executorService.writeAsync(null, (RedisCommand)RedisCommands.DISCARD, new Object[0]));
        this.resetConnection();
    }

    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        this.syncFuture(this.executorService.writeAsync(null, (RedisCommand)RedisCommands.WATCH, (Object[])keys));
    }

    public void unwatch() {
        this.syncFuture(this.executorService.writeAsync(null, (RedisCommand)RedisCommands.UNWATCH, new Object[0]));
    }

    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public Long publish(byte[] channel, byte[] message) {
        return (Long)this.write(channel, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PUBLISH, channel, message);
    }

    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.checkSubscription();
        this.subscription = new RedissonSubscription(this.redisson.getConnectionManager(), this.redisson.getConnectionManager().getSubscribeService(), listener);
        this.subscription.subscribe(channels);
    }

    private void checkSubscription() {
        if (this.subscription != null) {
            throw new RedisSubscribedConnectionException("Connection already subscribed");
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException("Not supported in queueing mode");
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException("Not supported in pipelined mode");
        }
    }

    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.checkSubscription();
        this.subscription = new RedissonSubscription(this.redisson.getConnectionManager(), this.redisson.getConnectionManager().getSubscribeService(), listener);
        this.subscription.pSubscribe(patterns);
    }

    public void select(int dbIndex) {
        throw new UnsupportedOperationException();
    }

    public byte[] echo(byte[] message) {
        return (byte[])this.read(null, (Codec)ByteArrayCodec.INSTANCE, ECHO, new Object[]{message});
    }

    public String ping() {
        return (String)this.read(null, (Codec)StringCodec.INSTANCE, RedisCommands.PING, new Object[0]);
    }

    public void bgWriteAof() {
        throw new UnsupportedOperationException();
    }

    public void bgReWriteAof() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.BGREWRITEAOF, new Object[0]);
    }

    public void bgSave() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.BGSAVE, new Object[0]);
    }

    public Long lastSave() {
        return (Long)this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.LASTSAVE, new Object[0]);
    }

    public void save() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)SAVE, new Object[0]);
    }

    public Long dbSize() {
        if (this.isQueueing()) {
            return (Long)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.DBSIZE, new Object[0]);
        }
        RFuture f = this.executorService.readAllAsync((RedisCommand)RedisCommands.DBSIZE, (SlotCallback)new SlotCallback<Long, Long>(){
            AtomicLong results = new AtomicLong();

            public void onSlotResult(Long result) {
                this.results.addAndGet(result);
            }

            public Long onFinish() {
                return this.results.get();
            }
        }, new Object[0]);
        return (Long)this.sync(f);
    }

    public void flushDb() {
        if (this.isQueueing() || this.isPipelined()) {
            this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.FLUSHDB, new Object[0]);
            return;
        }
        RFuture f = this.executorService.writeAllAsync((RedisCommand)RedisCommands.FLUSHDB, new Object[0]);
        this.sync(f);
    }

    public void flushAll() {
        RFuture f = this.executorService.writeAllAsync((RedisCommand)RedisCommands.FLUSHALL, new Object[0]);
        this.sync(f);
    }

    public Properties info() {
        return (Properties)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)INFO_DEFAULT, new Object[0]);
    }

    public Properties info(String section) {
        return (Properties)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)INFO, section);
    }

    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    public void shutdown(RedisServerCommands.ShutdownOption option) {
        throw new UnsupportedOperationException();
    }

    public List<String> getConfig(String pattern) {
        return (List)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.CONFIG_GET, pattern);
    }

    public void setConfig(String param, String value) {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.CONFIG_SET, param, value);
    }

    public void resetConfigStats() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.CONFIG_RESETSTAT, new Object[0]);
    }

    public Long time() {
        return (Long)this.read(null, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)TIME, new Object[0]);
    }

    public void killClient(String host, int port) {
        throw new UnsupportedOperationException();
    }

    public void setClientName(byte[] name) {
        throw new UnsupportedOperationException("Should be defined through Redisson Config object");
    }

    public String getClientName() {
        throw new UnsupportedOperationException();
    }

    public List<RedisClientInfo> getClientList() {
        throw new UnsupportedOperationException();
    }

    public void slaveOf(String host, int port) {
        throw new UnsupportedOperationException();
    }

    public void slaveOfNoOne() {
        throw new UnsupportedOperationException();
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.MIGRATE, target.getHost(), target.getPort(), key, dbIndex, timeout);
    }

    public void scriptFlush() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RFuture f = this.executorService.writeAllAsync((RedisCommand)RedisCommands.SCRIPT_FLUSH, new Object[0]);
        this.sync(f);
    }

    public void scriptKill() {
        throw new UnsupportedOperationException();
    }

    public String scriptLoad(byte[] script) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RFuture f = this.executorService.writeAllAsync((Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.SCRIPT_LOAD, (SlotCallback)new SlotCallback<String, String>(){
            volatile String result;

            public void onSlotResult(String result) {
                this.result = result;
            }

            public String onFinish() {
                return this.result;
            }
        }, new Object[]{script});
        return (String)this.sync(f);
    }

    public List<Boolean> scriptExists(final String ... scriptShas) {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RFuture f = this.executorService.writeAllAsync((RedisCommand)RedisCommands.SCRIPT_EXISTS, (SlotCallback)new SlotCallback<List<Boolean>, List<Boolean>>(){
            List<Boolean> result;
            {
                this.result = new ArrayList<Boolean>(scriptShas.length);
            }

            public synchronized void onSlotResult(List<Boolean> result) {
                for (int i = 0; i < result.size(); ++i) {
                    if (this.result.size() == i) {
                        this.result.add(false);
                    }
                    this.result.set(i, this.result.get(i) | result.get(i));
                }
            }

            public List<Boolean> onFinish() {
                return this.result;
            }
        }, (Object[])scriptShas);
        return (List)this.sync(f);
    }

    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RedisCommand<?> c = this.toCommand(returnType, "EVAL");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(script);
        params.add(numKeys);
        params.addAll(Arrays.asList(keysAndArgs));
        return this.write(null, (Codec)StringCodec.INSTANCE, c, params.toArray());
    }

    protected RedisCommand<?> toCommand(ReturnType returnType, String name) {
        RedisCommand c = null;
        if (returnType == ReturnType.BOOLEAN) {
            c = RScript.ReturnType.BOOLEAN.getCommand();
        } else if (returnType == ReturnType.INTEGER) {
            c = RScript.ReturnType.INTEGER.getCommand();
        } else {
            if (returnType == ReturnType.MULTI) {
                c = RScript.ReturnType.MULTI.getCommand();
                return new RedisCommand(c, name, (Convertor)new BinaryConvertor());
            }
            if (returnType == ReturnType.STATUS) {
                c = RScript.ReturnType.STATUS.getCommand();
            } else if (returnType == ReturnType.VALUE) {
                c = RScript.ReturnType.VALUE.getCommand();
                return new RedisCommand(c, name, (Convertor)new BinaryConvertor());
            }
        }
        return new RedisCommand(c, name);
    }

    public <T> T evalSha(String scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RedisCommand<?> c = this.toCommand(returnType, "EVALSHA");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(scriptSha);
        params.add(numKeys);
        params.addAll(Arrays.asList(keysAndArgs));
        return this.write(null, (Codec)ByteArrayCodec.INSTANCE, c, params.toArray());
    }

    public <T> T evalSha(byte[] scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        RedisCommand<?> c = this.toCommand(returnType, "EVALSHA");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(scriptSha);
        params.add(numKeys);
        params.addAll(Arrays.asList(keysAndArgs));
        return this.write(null, (Codec)ByteArrayCodec.INSTANCE, c, params.toArray());
    }

    public Long geoAdd(byte[] key, Point point, byte[] member) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.GEOADD, key, point.getX(), point.getY(), member);
    }

    public Long geoAdd(byte[] key, RedisGeoCommands.GeoLocation<byte[]> location) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.GEOADD, key, location.getPoint().getX(), location.getPoint().getY(), location.getName());
    }

    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        ArrayList<Object> params = new ArrayList<Object>(memberCoordinateMap.size() * 3 + 1);
        params.add(key);
        for (Map.Entry<byte[], Point> entry : memberCoordinateMap.entrySet()) {
            params.add(entry.getValue().getX());
            params.add(entry.getValue().getY());
            params.add(entry.getKey());
        }
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.GEOADD, params.toArray());
    }

    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            params.add(location.getPoint().getX());
            params.add(location.getPoint().getY());
            params.add(location.getName());
        }
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.GEOADD, params.toArray());
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        return this.geoDist(key, member1, member2, (Metric)RedisGeoCommands.DistanceUnit.METERS);
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        return (Distance)this.read(key, (Codec)DoubleCodec.INSTANCE, new RedisCommand("GEODIST", (Convertor)new DistanceConvertor(metric)), key, member1, member2, metric.getAbbreviation());
    }

    public List<String> geoHash(byte[] key, byte[] ... members) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(members.length + 1);
        params.add(key);
        for (byte[] member : members) {
            params.add(member);
        }
        return (List)this.read(key, (Codec)StringCodec.INSTANCE, GEOHASH, params.toArray());
    }

    public List<Point> geoPos(byte[] key, byte[] ... members) {
        ArrayList<Object> params = new ArrayList<Object>(members.length + 1);
        params.add(key);
        params.addAll(Arrays.asList(members));
        ListMultiDecoder decoder = new ListMultiDecoder(new MultiDecoder[]{new PointDecoder(), new ObjectListReplayDecoder2((Decoder<Object>)ListMultiDecoder.RESET)});
        RedisCommand command = new RedisCommand("GEOPOS", (MultiDecoder)decoder);
        return (List)this.read(key, (Codec)StringCodec.INSTANCE, command, params.toArray());
    }

    private String convert(double longitude) {
        return BigDecimal.valueOf(longitude).toPlainString();
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        RedisCommand command = new RedisCommand("GEORADIUS", (MultiDecoder)new GeoResultsDecoder());
        return (GeoResults)this.read(key, (Codec)ByteArrayCodec.INSTANCE, command, key, this.convert(within.getCenter().getX()), this.convert(within.getCenter().getY()), within.getRadius().getValue(), within.getRadius().getMetric().getAbbreviation());
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        RedisCommand command;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(this.convert(within.getCenter().getX()));
        params.add(this.convert(within.getCenter().getY()));
        params.add(within.getRadius().getValue());
        params.add(within.getRadius().getMetric().getAbbreviation());
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
            command = new RedisCommand("GEORADIUS", this.postitionDecoder);
            params.add("WITHCOORD");
        } else {
            ListMultiDecoder distanceDecoder = new ListMultiDecoder(new MultiDecoder[]{new GeoDistanceDecoder(), new GeoResultsDecoder(within.getRadius().getMetric())});
            command = new RedisCommand("GEORADIUS", (MultiDecoder)distanceDecoder);
            params.add("WITHDIST");
        }
        if (args.getLimit() != null) {
            params.add("COUNT");
            params.add(args.getLimit());
        }
        if (args.getSortDirection() != null) {
            params.add(args.getSortDirection().name());
        }
        return (GeoResults)this.read(key, (Codec)ByteArrayCodec.INSTANCE, command, params.toArray());
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, (Metric)RedisGeoCommands.DistanceUnit.METERS));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        return (GeoResults)this.read(key, (Codec)ByteArrayCodec.INSTANCE, GEORADIUSBYMEMBER, key, member, radius.getValue(), radius.getMetric().getAbbreviation());
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        RedisCommand command;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(member);
        params.add(radius.getValue());
        params.add(radius.getMetric().getAbbreviation());
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
            command = new RedisCommand("GEORADIUSBYMEMBER", this.postitionDecoder);
            params.add("WITHCOORD");
        } else {
            ListMultiDecoder distanceDecoder = new ListMultiDecoder(new MultiDecoder[]{new GeoDistanceDecoder(), new GeoResultsDecoder(radius.getMetric())});
            command = new RedisCommand("GEORADIUSBYMEMBER", (MultiDecoder)distanceDecoder);
            params.add("WITHDIST");
        }
        if (args.getLimit() != null) {
            params.add("COUNT");
            params.add(args.getLimit());
        }
        if (args.getSortDirection() != null) {
            params.add(args.getSortDirection().name());
        }
        return (GeoResults)this.read(key, (Codec)ByteArrayCodec.INSTANCE, command, params.toArray());
    }

    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.zRem(key, members);
    }

    public Long pfAdd(byte[] key, byte[] ... values) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(values.length + 1);
        params.add(key);
        for (byte[] member : values) {
            params.add(member);
        }
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, PFADD, params.toArray());
    }

    public Long pfCount(byte[] ... keys) {
        Assert.notEmpty((Object[])keys, (String)"PFCOUNT requires at least one non 'null' key.");
        Assert.noNullElements((Object[])keys, (String)"Keys for PFOUNT must not contain 'null'.");
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PFCOUNT, Arrays.asList(keys).toArray());
    }

    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        ArrayList<Object> args = new ArrayList<Object>(sourceKeys.length + 1);
        args.add(destinationKey);
        args.addAll(Arrays.asList(sourceKeys));
        this.write(destinationKey, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PFMERGE, args.toArray());
    }
}

