/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redisson.client.runtime;

import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.config.PropertiesConvertor;

@ApplicationScoped
public class RedissonClientProducer {
    private RedissonClient redisson;
    @Inject
    @ConfigProperty(name="quarkus.shutdown.timeout")
    Optional<Duration> shutdownTimeout;

    @Produces
    @Singleton
    @DefaultBean
    public RedissonClient create() throws IOException {
        String config = null;
        Optional configFile = ConfigProvider.getConfig().getOptionalValue("quarkus.redisson.file", String.class);
        String configFileName = configFile.orElse("redisson.yaml");
        try (InputStream configStream = Optional.ofNullable(this.getClass().getResourceAsStream(configFileName)).orElse(Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileName));){
            byte[] array;
            if (configStream != null && configStream.read(array = new byte[configStream.available()]) != -1) {
                config = new String(array, StandardCharsets.UTF_8);
            }
        }
        if (config == null) {
            Stream s = StreamSupport.stream(ConfigProvider.getConfig().getPropertyNames().spliterator(), false);
            config = PropertiesConvertor.toYaml((String)"quarkus.redisson.", (Iterable)s.sorted().collect(Collectors.toList()), prop -> (String)ConfigProvider.getConfig().getValue(prop, String.class), (boolean)false);
        }
        ConfigSupport support = new ConfigSupport(true);
        Config c = (Config)support.fromYAML(config, Config.class);
        this.redisson = Redisson.create((Config)c);
        return this.redisson;
    }

    @PreDestroy
    public void close() {
        if (this.redisson != null) {
            if (this.shutdownTimeout.isPresent()) {
                Duration grace = this.shutdownTimeout.get();
                this.redisson.shutdown(grace.toMillis(), grace.toMillis() * 2L, TimeUnit.MILLISECONDS);
            } else {
                this.redisson.shutdown();
            }
        }
    }
}

