/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redisson.client.runtime;

import com.fasterxml.jackson.databind.MapperFeature;
import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.ConfigProvider;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.config.PropertiesConvertor;

@ApplicationScoped
public class RedissonClientProducer {
    private RedissonClient redisson;

    @Produces
    @Singleton
    @DefaultBean
    public RedissonClient create() throws IOException {
        String config;
        Optional configFile = ConfigProvider.getConfig().getOptionalValue("quarkus.redisson.file", String.class);
        InputStream configStream = configFile.isPresent() ? this.getClass().getResourceAsStream((String)configFile.get()) : Thread.currentThread().getContextClassLoader().getResourceAsStream("redisson.yaml");
        if (configStream != null) {
            byte[] array = new byte[configStream.available()];
            configStream.read(array);
            config = new String(array, StandardCharsets.UTF_8);
        } else {
            String yaml;
            Stream s = StreamSupport.stream(ConfigProvider.getConfig().getPropertyNames().spliterator(), false);
            config = yaml = PropertiesConvertor.toYaml((String)"quarkus.redisson.", (Iterable)s.sorted().collect(Collectors.toList()), prop -> (String)ConfigProvider.getConfig().getValue(prop, String.class), (boolean)false);
        }
        ConfigSupport support = new ConfigSupport(){
            {
                this.yamlMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            }
        };
        Config c = (Config)support.fromYAML(config, Config.class);
        this.redisson = Redisson.create((Config)c);
        return this.redisson;
    }

    @PreDestroy
    public void close() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }
}

